; hcompo22 - stewart
;	assembled with nasm 0.98.34
;
;	initial state:
;
;          EAX = xxxx****  EBX = xxxx0000	 ECX = xxxx00FF EDX = xxxxxxxx
;          ESI = xxxx0100	EDI = xxxxFFFE	 EBP = xxxx09xx ESP = xxxxFFFE
;          EIP = xxxx0100
;  DX  = CS = DS = ES = SS = xxxx, 0080 <= DX <=9000.
;
;  EFLAGS (binary) = xxxxxxxx xxxxxxxx xxxx0x1x xx0x0x1x
;
; assumes - ch=0 and bx=0 on entry



	org	100h

	SECTION	.text
start:

	push	0xa0a7					; one row down, 14 across
	pop		es
	mov		si,DataArea				; si=data area..	

restart:

;	************************************* 
;	set up the graphics
; 	*************************************
	
	mov		ax,0x13		
	int		0x10					; set mode 13 

;	set score to zero

	mov		[si],bx					; grand bretagne, nul points!

; *****************************************
;	the game..
; *****************************************

new_piece_loop:		

	mov		bl,10					; bx=10 = score increment/2
	push	bx						; save 10 for later
	xor		di,di					; current line start = 0
	mov		cl,23					; number of rows to check

line_check_loop:
	lea		ax,[di+320*8]			; ax=8 lines down from current line
	
	pusha	

	mov		cl,88					; scan for a line
	repne	scasb					; repeat until match found or checked row of pixels.
	
	popa

	xchg	ax,di					; di= new value,ax=old
	
	jz		not_full_line			; if z set, repne bailed early

;	advance the score

	add		bl,bl					; double points, pt_add max is 160, so ok - and want bh=zero in drawScore
	add		[si],bx					; add points to score

	pusha

;	drag pieces downwards..
	
	std								; change to backwards
	xchg	ax,bx					; bx=previous line, ax=00ss
cp_loop:
	mov		al,[es:bx]   			; hmm. seemed smaller than movsb at the time, as si needed for waitTick
	stosb						
	dec		bx
	jnz		cp_loop

;	clear top row of pieces on the board

	mov		cx,di						; remaining count
	xchg	ax,bx						; ax=0000,bx=00ss
	rep		stosb	
	cld									; restore direction

line_wait_loop:
	call	waitTickAndDraw				; wait for tick + draw the score and board
	dec		bp							; decrement ticks
	jg		line_wait_loop
	
	popa

not_full_line:
	loop	line_check_loop

;	ax=dc00,di=e600
;	bx=00xx
;	cx=0000 

;	now set up the fall_rate , the rand number and the player..

	pop		ax							; ax=10
	sub		al,[byte si+1]				; 10-score/256
	xchg	ax,bp						; bp = fall-rate, ax=old fall rate or ????

;	get new random number

	mov		ax,9421						; 0x24cd
	mul		word [byte si+(mov_rseed+1-DataArea)]
	inc		ax
	mov		[byte si+(mov_rseed+1-DataArea)],ax

	xor		bx,bx						; page#, also - bx=0 =>test mode, and bh=0 for score at top
	mov		dx,18						; y=0,x=18
	mov		ah,0x02						; ah=2 - set cursor pos
	int		0x10						; set cursor

; set up the player position

	mov		dl,6						; x=6 			; loc=(6,0)
	mov		di,dx						; set previous piece to be current pos so ecd is ok

; bx=0 for test mode from above..

	call	drawPiece					; test piece
	jz		first_draw					; if test passed, draw the piece and continue the game

; ******************************************************************************
; oh, no, couldn't draw the piece.
; ******************************************************************************

game_over_loop:							; night is long, 
	jz		restart						; when home is 
	push	game_over_loop 				; far away.

; ******************************************************************************
;  get a key, abort if 'esc' else compare to space and return
; ******************************************************************************

getKey:	
	xor		ax,ax		; ax=0
	int		0x16
	dec		ah
	jz		hit_escape	; if hit escape, it's time to bail
	cmp		al,' '
	ret

;	***************************************
;	main loop while falling
;	if fall from above Z is set
; 	if come from below, then NZ => can't move
;	keep ch=0
; 	***************************************

main_loop:
	jnz		new_piece_loop		; failed to move, so go to new_piece_loop

	jcxz	skip_increment		; if cx hit zero, then ticks expired naturally
	inc		word [si]			; increment the score	
skip_increment:
	or		cx,bp				; or in the timer value to the tick + latch 
		
								
inner_loop:
	mov		ah,1				; ah=1 key  ready?
	int		0x16				; key ready
	je		no_key_ready		; Zf=1 if no data

	call	getKey
	jne		not_space
	
	mov		cl,-1				; set the space bar hit latch

not_space:
	sub		al,'j'
	cmp		al,2		
	ja		no_key_ready		; 0,1,2
	dec		al					; -1,0,1
	jne		not_rot
	inc		dh			
not_rot:
	add		dl,al
	
	call	doECD				; do the erase/check/draw 

no_key_ready:
	call	waitTickAndDraw

;	update timer

	dec		cl					
	jg		inner_loop				; timer>0 then back for more		

	add		dl,11					; 1 row down
                                                                        
	jc		main_loop				; cope with the case of the red piece falling through the end of the well..
  
first_draw:
	push	main_loop				; fall into erase/check/draw - jump back to main loop

; ******************************************************************************
;	erase previous, test current, if ok - update current, set to old pos , draw
;	has to have previous piece position valid.	
;	on exit - ax=ffff or 0000, bx=0003
; ******************************************************************************

doECD:
	mov		bx,-1					; erase mode, also flags for the sahf
ecd_loop_failed:
	mov		ax,bx					; ax=bx, either -1, or 0 if test fails, for sahf later on 
ecd_loop:
	xchg	dx,di					; swap new, old pos
	call	drawPiece
	jnz		ecd_loop_failed			; if test fails, then redo (so test old which will pass)
	inc		bx
	jz		ecd_loop				; 
	mov		di,dx					; load old pos
	jpo		ecd_loop				; do for 1,2
	sahf							; set flags from ah
	ret

; ****************************************************************************
;	escape got pressed - so exit the code
;	fall through to drawBlock, that will write a block at (cl,al) = (ticks,3)
;	but that's ok, as the write is before text mode 
;	ah=0 because the dec hit zero, so drawBlock is ok
; ****************************************************************************

hit_escape:
	pop		bx			; reclaim stack
	mov		al,3
	int		0x10
;	ret

;	and fall through to..

; ******************************************************************************
; draw a block at cl=x,al=y
;		bl=0  ->test Zf = passed
;		bx=<0 -> erase
;		else -> draw block with shadow colour bp+0x68+14
;	requires ah=0 
;	safe to call with al=-1,-2 for testing rotate against outside of well..
; ******************************************************************************
drawBlock:
	pusha
	
	mov		si,320			
	mul		si
	
	add		al,cl

	mov		cx,8		; initial width
	mul		cx			; so dx=0,or 8 if trying to rotate a block outside top of well..
	xchg	ax,di

	or		bx,bx					; look at draw command .. 
	xchg	ax,dx					; ax=dx from mul - 
	jz		only_test				; if 0 => test mode -> ok to move if find ax here..
	js		skip_colset				; if was <0 then keep 0
	lea		ax,[byte bp+0x68+14]	; else, ax=shadow colour  (14 coz of -7*2)
skip_colset:

	; draw the square

sq_outer:
	pusha
	mov		ah,cl		; save cl in ah
sq_inner:
	pusha
	mov		cl,ah		; cx=count	
	rep		stosb		; draw cx bytes of al
	popa	
	add		di,si		; one line down
	loop	sq_inner	; and more lines
	popa
	dec		cx			; decrement width
	jpo		width7		; 7 is odd parity, 6,5 cause following to execute:
	sub		al,24		; decrease colour
	add		di,si		; one row down
	inc		di			; one pixel to the right	
width7:
	sub		al,24
	cmp		al,5
	jge		sq_outer	; back for more if colour still is >=5

;	ax=00xx, and want to exit with Z set..

	db		0x25		; and ax,0xae00 
	db		0x00
only_test:
	scasb				; ok-to-draw if find al here - since 8 never gets written to frame, -ve al reports a fail
	popa
	ret

; ******************************************************************************
;	hang on, wait a tick
;	requires bh=0 and ch=0 on entry 
; ******************************************************************************
	
waitTickAndDraw:

	pusha

; draw the score

	mov		ax,[si]
	mov		cl,4	
numloop:
	cwd						; dx=0
	mov		bl,10
	div		bx				; ax=val/10 dx=val%10
	xchg	ax,dx			; dx=val/10,ax=val%10
	add		ax,0x0a00+'0'	; al = number char, ah=0x0a = int num
	mov		bl,7			; bl=colour, bh=0 whenever called
	int		0x10			; draw cx chars.
	xchg	ax,dx			; ax=val/10 
	loop	numloop

	; score < 9999, so 
	; ax=0 - in particular, ah=0..
	; dx = 0x0axx
	; bx = 7

; draw the board..

	mov		bp,124-(0x68+14)		; bl=border-1, bh=0 
more_ax:
	xor		cx,cx					; x=0
	call	drawBlock				; draw left hand block first time, then right hand block
	mov		cl,11					; x=11 = right hand side
bloop:	
	call	drawBlock				; draw left hand block first time, then right hand block
	inc		ax						; y++
	cmp		al,24					; hit end of board?
	jnz		more_ax					; if not, back for more
	dec		ax						; reset to 23 
	loop	bloop					; loop on x

;	cx=0 ax=0023

;	and wait for a tick	
	
	int		0x1a			; int 1a = get time
							; cx/dx = ticks since midnight, al = midnight flag
	mov		bx,dx			; save dx
wait_loop:
	int		0x1a
	cmp		bx,dx
	je		wait_loop		; spin until dx changes..

	popa
	ret



; ******************************************************************************
; draw a piece at dl=loc,dx=rot,bl=mode..
; called with:
;	bl=-1  erase
;	bl=0   test
;   bl=1,2
; ******************************************************************************

drawPiece:
	pusha	
	mov		ax,7					; ouch - start at y=2
mov_rseed:
	mov		bp,12345				; get random value
moda:
	sub		bp,ax					;  
	jnz		not_block_0				; if Z set, then block zero, so ..
	xor		dh,dh					; zero rotate 
not_block_0:
	jae		moda
	mov		cl,[bp+si]				; so read block to cl
	add		bp,bp					; offset for colours
pat_loop:
	jcxz	done_piece
	inc		ax
	shr		cl,1					; get bit from cl
	jnc		pat_loop	
	pusha
	aam		4						; mod 4 - al=num%4==x ah=num/4 == y
pat_rot:							; has to be a nicer way to code this..
	sub		al,4
	neg		al
	xchg	al,ah
	dec		dh
	jnz		pat_rot
	xchg	ax,dx
	aam		11						; mod 11 - so left edge of board stops movement
	add		ax,dx
	sub		ax,0x0202				; recenter- ax=yyxx ch=00bb
	xchg	ax,cx					; ax=00bb ch=yyxx
	mov		al,ch					; ax=00yy ch=yyxx
	call	drawBlock				; test pass = Z flag, test fail = NZ
out_of_well:						; can only hit here in test mode.. or somehow current pos was screwed up
	popa
	jz		pat_loop
test_failed:
done_piece:
	popa							
	ret


; ******************************************************************************
;	block definitions
;	0123 01+3
;	4567 4567
; ******************************************************************************

%macro	blk	4
	db	(1<<%1)|(1<<%2)|(1<<%3)|(1<<%4)
%endmacro

PatternTable:
	blk	1,2,5,6
	blk	2,3,5,6
	blk 1,2,3,7
	blk	1,2,6,7
	blk	0,1,2,3
	blk	1,2,3,5
	blk	1,2,3,6
DataArea:



; the end. 

