\PENTS.XPL	APR-01-94
\Pentomino Puzzle Solver by Lenny Boreal

inc	C:\CXPL\CODESI;	\Include code definitions for intrinsic routines

int	Mode0,		\Original video display mode (restored upon exit)
	Pieces,		\Array: All puzzle pieces and their orientations
	Orientations,	\Array: Number of orientations for each piece
	Solutions,	\Number of solutions found so far
	Time,		\Amount of time to delay for moves (18ths of seconds)
	CellEnd;	\Last cell in Box +1
real	Moves;		\Number of tries (pieces inserted or removed)
char	Box,		\Array: Contains the pieces (i.e. the puzzle)
	Avail;		\Array of flags: Piece is not in Box (hence available)
def	BoxW=10, BoxH=6;\Box width and height
			\Also possible: 12x5, 15x4 and 20x3
int	Cpureg;		\Address of CPU register array (from Getreg)
def	AX, BX, CX, DX, DI, SI, BP, CF, CS, DS, SS, ES;	\Getreg registers
def	Bel=$07, CR=$0D, FF=$0C, Esc=$1B;		\Ascii characters



func	GetVid;			\Return current video mode
begin
Cpureg(AX):= $0f00;		\Function $0f
Softint($10);			\Call BIOS routine
return Cpureg(AX) & $ff;
end;	\GetVid



proc	CursorOff;		\Turn off annoying flashing cursor
begin
Cpureg(AX):= $0100;
Cpureg(CX):= $2000;
Softint($10);
end;	\CursorOff



func	GetKey;			\Get character from low-level keyboard routine
begin				\No echo, no Ctrl-C, and no cursor
Cpureg(AX):= 0;
Softint($16);
return Cpureg(AX) & $ff;
end;	\GetKey



proc	Exit;			\Exit the program in a tidy fashion
begin
Setvid(Mode0);			\Restore original video display mode
exit;
end;	\Exit



proc	Delay(T);		\Delay T 18ths of a second
int	T;
int	I;
begin
for I:= 1, T do
	begin
	Sound(0, 1, 1);
	if Chkkey then return;	\Abort Delay if keystroke
	end;
end;	\Delay

\----------------------------------------------------------------------

proc	ShowCounts;		\Display numbers of solutions and moves
begin
Cursor(1, 24);   Intout(0, Solutions);
Text(0, "  ");   Rlout(0, Moves);
end;	\ShowCounts



proc	ShowBlock(Cell, Color);	\Display a block (5 blocks in a pentomino)
int	Cell, Color;
int	I, X, Y;
begin
I:= 40 /BoxW;			\Adjust size to fit screen
X:= (Cell >>3);			\Get X,Y coordinates from Cell
Y:= ((Cell & $07) -1);
Hilight(X*I, Y*I, (X+1)*I-1, (Y+1)*I-1, Color);
end;	\ShowBlock



proc	ShowPiece(Cell, P2, Color);	\Display a puzzle piece (pentomino)
int	Cell, P2, Color;
begin
ShowBlock(Cell+P2(0), Color);
ShowBlock(Cell+P2(1), Color);
ShowBlock(Cell+P2(2), Color);
ShowBlock(Cell+P2(3), Color);
ShowBlock(Cell+P2(4), Color);
ShowCounts;
Delay(Time-2);
end;	\ShowPiece



proc	ShowBox;		\Display the entire puzzle box
int	X, Y, C;
begin
C:= 0;
for X:= 0, BoxW-1 do
    for Y:= 0, 7 do
	begin
	if Y>=1 & Y<=BoxH then ShowBlock(C, Box(C));
	C:= C +1;
	end;
ShowCounts;
end;	\ShowBox



proc	DoKey;			\Get commands from keyboard
int	Ch;
begin
Ch:= Getkey;
if Ch = Esc then Exit;
if Ch>=^0 & Ch<=^9 then		\Speed command
	begin
	if Time <= 1 then ShowBox;  \Make display current if necessary
	Time:= Ch - ^0;
	if Time >4 then Time:= (Time-2)*(Time-2);
	if Time >=49 then Time:= $7fff;  \Forever = single step
	end;
end;	\DoKey

\----------------------------------------------------------------------

proc	PutPiece(Cell);		\Put piece into box at Cell location
char	Cell;	\Current cell position
int	P2;	\Array: Contains positions of cells for an oriented piece
int	P,	\Current piece
	O;	\Current piece's orientation
char	C;	\Scratch (cell/color)
begin
if Chkkey then DoKey;			\(This is here for maximum speed)

for P:= 0, 11 do			\For all available pieces...
    if Avail(P) then
	begin
	for O:= 0, Orientations(P) do	\For all orientations of the piece...
		begin
		P2:= Pieces(P, O);
		case of			\If any cell is occupied then forget it
		  Cell(P2(1)), Cell(P2(2)), Cell(P2(3)), Cell(P2(4)): []
		other	begin			\Piece fits!
			C:= P + 2;		\Put it in the Box
			Cell(0):= C;		\Color:= piece value +2
			Cell(P2(1)):= C;	\(Color can't be 0, which = empty)
			Cell(P2(2)):= C;
			Cell(P2(3)):= C;
			Cell(P2(4)):= C;

			Avail(P):= false;	\Piece is no longer available
			Moves:= Moves +1.0;	\This counts as a move (trial)

			if Time > 1 then	\If we have time, show the move
				begin
				ShowPiece(Cell-Box, P2, C);
				if Chkkey then DoKey;	\Check for new command
				end;

			C:= Cell +1;		\Scan for next empty cell in Box
			while C(0) \#0\ do C:= C +1;

			if C # CellEnd then	\Try to put next piece into box
				PutPiece(C)	\ (recurse)
			else	begin		\Solved !!
				Solutions:= Solutions +1;
				ShowBox;	\Show the solution
				if Time >= 1 then
					begin	\If going slow, wait for keystroke
					Cursor(17, 24);
					Attrib($70);	\Black on white
					Text(6, " Hit Enter to continue ");
					Openi(1); \(Messages must be same length)
					DoKey;		\Get command from keyboard
					Cursor(17, 24);	\Restore original message
					Attrib($07);	\White on black
					Text(6, "Keys 0-9 control speed ");
					end;
				end;

			Cell(0):= 0;		\Remove piece from box
			Cell(P2(1)):= 0;	\ (backtrack)
			Cell(P2(2)):= 0;
			Cell(P2(3)):= 0;
			Cell(P2(4)):= 0;

			Avail(P):= true;	\Piece is now available
			Moves:= Moves +1.0;	\This also counts as a move

			if Time > 1 then	\If we have time, show the move
				begin
				ShowPiece(Cell-Box, P2, 0);
				if Chkkey then DoKey;
				end;
			end;
		end;
	end;
end;	\PutPiece

\----------------------------------------------------------------------

proc	Initialize;
int	I, J, X, Y, C;
begin
Format(1,0);			\Reals are used to handle lots of Moves
Moves:= 0.0;
Solutions:= 0;			\There aren't that many solutions (use integers)
Time:= 3;			\Initial speed is about 10 moves per second

\Set up empty box with borders. Each column is scanned from top to bottom
\ starting at the left column.
C:= 0;
for X:= 0, BoxW do			\ # # # # # # # # # # _
    for Y:= 0, 7 do			\ _ _ _ _ _ _ _ _ _ _ #
	begin				\ _ _ _ _ _ _ _ _ _ _ #
	case of Y=0, Y>=BoxH+1, X=BoxW:	\ _ _ _ _ _ _ _ _ _ _ #
		Box(C):= ^#		\ _ _ _ _ _ _ _ _ _ _ #
	other	Box(C):= 0;		\ _ _ _ _ _ _ _ _ _ _ #
	C:= C +1;			\ _ _ _ _ _ _ _ _ _ _ #
	end;				\ # # # # # # # # # # #
Box(C-8):= 0;		\Upper-right corner is used to detect when box is full
CellEnd:= Box +C -8;	\Note that no piece can occupy this vacant cell

for I:= 0, 11 do Avail(I):= true;	\All pieces are available

\Maximum orientations for each piece (-1):
\      Piece:   0  1  2  3  4  5  6  7  8  9 10 11
Orientations:= [0, 1, 0, 3, 3, 3, 3, 7, 7, 7, 7, 7]; 

\This defines the pieces and all their orientations. Each piece consists of
\ five cells. The first cell scanned is the origin (=0). The other cells are
\ offsets from this origin.
Pieces:=
    [ [ [ 0,  7,  8,  9, 16] ],	\0  -#--
				\   ###-
				\   -#--

      [ [ 0,  8, 16, 24, 32],	\1  #####  #---
	[ 0,  1,  2,  3,  4] ],	\   -----  #---
				\   -----  #---
				\   -----  #---
				\   -----  #---

      [ [ 0,  1,  2,  8, 16] ],	\2  ###-  ###-  #---  --#-
	\(Three of these are	    #---  --#-  #---  --#-
	\ eliminated to elimate	    #---  --#-  ###-  ###-
	\ rotations & reflections in the final solution)

      [ [ 0,  1,  7,  8, 15],	\3  -##-  --#-  ##--  #---
	[ 0,  7,  8, 14, 15],	\   ##--  -##-  -##-  ##--
	[ 0,  8,  9, 17, 18],	\   #---  ##--  --#-  -##-
	[ 0,  1,  9, 10, 18] ],	\   ----  ----  ----  ----

      [ [ 0,  1,  2,  9, 17],	\4  #---  ###-  --#-  -#--
	[ 0,  8,  9, 10, 16],	\   ###-  -#--  ###-  -#--
	[ 0,  8, 15, 16, 17],	\   #---  -#--  --#-  ###-
	[ 0,  6,  7,  8, 16] ],	\   ----  ----  ----  ----

      [ [ 0,  1,  8, 15, 16],	\5  --#-  -##-  #---  ##--
	[ 0,  6,  7,  8, 14],	\   ###-  -#--  ###-  -#--
	[ 0,  1,  9, 17, 18],	\   #---  ##--  --#-  -##-
	[ 0,  8,  9, 10, 18] ],	\   ----  ----  ----  ----

      [ [ 0,  1,  8, 16, 17],	\6  ###-  #-#-  ##--  ##--
	[ 0,  1,  9, 16, 17],	\   #-#-  ###-  #---  -#--
	[ 0,  1,  2,  8, 10],	\   ----  ----  ##--  ##--
	[ 0,  2,  8,  9, 10] ],	\   ----  ----  ----  ----

      [ [ 0,  1,  8, 16, 24],	\7  ####  ####  #---  ---#  ##--  ##--  #---  -#--
	[ 0,  8, 16, 24, 25],	\   #---  ---#  ####  ####  #---  -#--  #---  -#--
	[ 0,  1,  9, 17, 25],	\   ----  ----  ----  ----  #---  -#--  #---  -#--
	[ 0,  8, 16, 23, 24],	\   ----  ----  ----  ----  #---  -#--  ##--  ##--
	[ 0,  1,  2,  3,  8],
	[ 0,  8,  9, 10, 11],
	[ 0,  1,  2,  3, 11],
	[ 0,  5,  6,  7,  8] ],

      [ [ 0,  8,  9, 16, 24],	\8  ####  ####  -#--  --#-  #---  #---  -#--  -#--
	[ 0,  8, 16, 17, 24],	\   -#--  --#-  ####  ####  ##--  #---  ##--  -#--
	[ 0,  7,  8, 16, 24],	\   ----  ----  ----  ----  #---  ##--  -#--  ##--
	[ 0,  8, 15, 16, 24],	\   ----  ----  ----  ----  #---  #---  -#--  -#--
	[ 0,  1,  2,  3,  9],
	[ 0,  1,  2,  3, 10],
	[ 0,  7,  8,  9, 10],
	[ 0,  6,  7,  8,  9] ],

      [ [ 0,  7,  8, 15, 23],	\9  -###  --##  ###-  ##--  -#--  -#--  #---  #---
	[ 0,  8, 15, 16, 23],	\   ##--  ###-  --##  -###  ##--  -#--  ##--  #---
	[ 0,  8, 16, 17, 25],	\   ----  ----  ----  ----  #---  ##--  -#--  ##--
	[ 0,  8,  9, 17, 25],	\   ----  ----  ----  ----  #---  #---  -#--  -#--
	[ 0,  1,  2,  7,  8],
	[ 0,  1,  6,  7,  8],
	[ 0,  1,  9, 10, 11],
	[ 0,  1,  2, 10, 11] ],

      [ [ 0,  1,  7,  8, 16],	\10 -#--  -##-  ##--  #---  --#-  -#--  -#--  -#--
	[ 0,  7,  8,  9, 15],	\   ###-  ##--  -##-  ###-  ###-  -##-  ###-  ##--
	[ 0,  8,  9, 10, 17],	\   #---  -#--  -#--  -#--  -#--  ##--  --#-  -##-
	[ 0,  1,  9, 10, 17],	\   ----  ----  ----  ----  ----  ----  ----  ----
	[ 0,  8,  9, 15, 16],
	[ 0,  6,  7,  8, 15],
	[ 0,  7,  8, 16, 17],
	[ 0,  7,  8,  9, 17] ],

      [ [ 0,  1,  8,  9, 16],	\11 ###-  ###-  ##--  -##-  ##--  ##--  #---  -#--
	[ 0,  8,  9, 16, 17],	\   ##--  -##-  ###-  ###-  ##--  ##--  ##--  ##--
	[ 0,  1,  8,  9, 17],	\   ----  ----  ----  ----  #---  -#--  ##--  ##--
	[ 0,  7,  8, 15, 16],	\   ----  ----  ----  ----  ----  ----  ----  ----
	[ 0,  1,  2,  8,  9],
	[ 0,  1,  8,  9, 10],
	[ 0,  1,  2,  9, 10],
	[ 0,  1,  7,  8,  9] ] ];

Attrib($00);			\Fill foreground so Hilight will give 16 colors
for J:= 0, 23 do		\ (we don't want to use the flashing colors)
	begin
	Cursor(0, J);				\(Required)
	for I:= 0, 39 do Chout(6, $db);		\Solid block
	end;
end;	\Initialize

\----------------------------------------------------------------------

begin	\Main
Box:= Reserve(8 *(BoxW+1));	\Reserve space for arrays
Avail:= Reserve(12);		\There are 12 pentominoes

Cpureg:= Getreg;		\Get address of CPU registers
Mode0:= Getvid;			\Save current display mode (to be restored later)
Setvid(1);			\Use 40-column text mode
CursorOff;			\Turn off the annoying flashing cursor

Initialize;
ShowBox;			\Show empty box
Attrib($07);			\White characters on black background
Cursor(17, 24);   TEXT(6, "Keys 0-9 control speed ");

PutPiece(Box+1);		\Put first piece into upper-left corner and go...

ShowBox;			\Show empty box, number of solutions and moves
Attrib($07);
Cursor(9, 10);   TEXT(6, " All solutions found  ");
Chout(0, Bel);   Delay(2);   Chout(0, Bel);   Delay(2);   Chout(0, Bel);

Openi(1);			\Wait for keystroke before clearing screen
if Chin(1) then;
Exit;				\Restore original text mode and exit
end;	\Main
