;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;  5.Jul.2003 - 429 bytes floppy boot sector Falling Tetromino Game
;		 by Asko Vuori		email: askovuori@hotmail.com
;		    Pyh. Katariinantie 14 B 26
;		    20780 Kaarina
;		    Finland
;
; compile:
;	tasm /m boot_tet
;	tlink /t /x boot_tet
; usage:
;	boot_tet d:      where d is A or B
; notes:
;	- to quit game: remove floppy and press ESC
;	- WARNING: Don't use DOS boot disk, because program don't save
;	  original boot sector (only parameters)
;
; Version history:
;   435 -  9.Jun.2003 by ATV
;   429 -  5.Jul.2003 by ATV
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
fieldHeight	Equ	25-1		;Playfield dimensions including border
fieldWidth	Equ	256
fieldX		Equ	(40-12)/2	;Position to display Field on screen
fieldY		Equ	(25-fieldHeight)/2 + 1

empty		Equ	0		;No tile = black
border		Equ	52+3*24 	;Border tile color = light cyan

;Keyboard commands:
leftCh		Equ	'j'		;move piece left
rotCh 		Equ	'k'		;rotate (counterclockwise)
rightCh		Equ	'l'		;move right
dropCh		Equ	' '		;drop piece (free fall to get points)
startCh 	Equ	' '		;start another game
quitCh		Equ	1Bh		;quit game

KEYINT		Equ	16h
TIMEINT 	Equ	1Ah

Tet_Ofs 	Equ	0300h
BootOfs 	Equ	7C00h-Tet_Ofs
DosDataOffs	Equ	DosData-Init	;offset where to copy it
DosDataLen	Equ	3Ch		;length of data to copy from original
					;boot sector

	.Model	Tiny
	.Code
	.186
	.Radix	10
	Org	0100h

EntPt:	Cld
	Mov	Dx,Offset msgUsage
	Mov	Si,0080h		;start of cmd line
GetChar:Inc	Si
	Mov	Ax,[Si]			;get char
	Cmp	Al,' '
	Jz	GetChar
	Cmp	Al,9
	Jz	GetChar			;skip blanks and tabs
	And	Al,0DFh			;upper case
	Cmp	Ah,':'			;is ':'?
	Jnz	ErrExit			;if not, args are not OK
	Cmp	Al,'B'
	Ja	ErrExit			;if drive > B, error
	Sub	Al,'A'
	Jc	ErrExit			;if drive < A, error
argOK:	Cbw				;clear ah
	Push	Ax 			;save drive
	Mov	Bx,Offset Buffer
	Mov	Cx,1
	Xor	Dx,Dx
	Int	25h			;read boot sector of specified drive
	Pop	Ax			;int 25h leaves flags on the stack
	Jc	DiskError
	Mov	Si,Offset Buffer + DosDataOffs
	Mov	Di,Offset Tet_Ofs + DosDataOffs
	Mov	Cx,DosDataLen
	Rep	Movsb			;get original disk data
	Pop	Ax			;drive number
	Mov	Bx,Offset Tet_Ofs
	Mov	Cx,1
	Xor	Dx,Dx
	Int	26h 			;write new sector
	Pop	Ax			;int 26h leaves flags on the stack
	Jc	DiskError
	Mov	Dx,Offset msgInstalled
	Mov	Ah,09h
	Int	21h
	Mov	Ax,4C00h
	Int	21h			;everything OK, exit to DOS

DiskError:
	Mov	Dx,Offset msgDiskError
ErrExit:
	Mov	Ah,09h
	Int	21h
	Mov	Ax,4C01h
	Int	21h		 	;exit to DOS

msgUsage	Db "Boot_Tet installer by ATV",0Dh,0Ah
		Db "WARNING: Don't use DOS boot disk, because program"
		Db " don't save",0Dh,0Ah
		Db "         original boot sector (only parameters)",0Dh,0Ah
		Db 0Dh,0Ah
		Db "Usage: BOOT_TET d:      where d is A or B"
		Db 0Dh,0Ah,"$"

msgDiskError	Db "Disk error !",0Dh,0Ah,"$"

msgInstalled	Db "Boot_Tet Installed OK. Reboot and play.",0Dh,0Ah
		Db "To quit game: Remove floppy and press ESC"
		Db 0Dh,0Ah,"$"

		Dw Offset pieceC-StartGame ;Just to see how big game is
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; BOOT_TET - New floppy boot sector
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	Org	Tet_Ofs
Init:	Jmp	Short StartGame		;real start of code

DosData Db	DosDataLen Dup(0)	;filled with old boot data
	Db	'BOOT_TET by ATV'

StartGame:
	Cld
	Xor	Cx,Cx
	Mov	Ss,Cx			;we need Ss:Bp
	Mov	Sp,7C00h		;create a stack
	Mov	Es,Cx
	Mov	Ds,Cx			;set data segments
Start:	Mov	Di,Offset emptyLn
	Mov	Ax,(fieldHeight*4-1)*256+empty
Clear:	Mov	Cl,10			;(10 emptys + 118 borders)*2*height
	Xor	Cl,Al			;10 xor 0 = 10, 10 xor 7Ch = 76h (118)
	Rep	Stosb			;Two 10*24 fields side by side
	Xor	Al,border		;second field has only Score
	Dec	Ah			;in [Bp-78h]
	Jne	Clear
	Mov	Ch,1
	Rep	Stosb			;draw bottom line
	Mov	Al,13h			;set mode 320x200x256
	Int	10h
	Mov	Bp,Offset field 	;Also screen segment
NewPiece:
	Cwd
	Mov	Di,Offset Seed+BootOfs
	Imul	Ax,[Di],24CDh		;Seed = Seed*9421+1
	Inc	Ax
	Stosw				;Di = Seed -> pieceC
	Mov	Cl,7
	Idiv	Cx
	Xchg	Dx,Ax			;randomNum = remainder(Seed/7)
	Stosb				;Di = pieceC -> pieceXY
	Xchg	Bx,Ax
	Mov	Dh,[Bx+Di+tblX_Y-pieceXY];get 7 upper bits
	Mov	Dl,50h			;set 5 lower bits
NePi10: Shr	Dx,03h			;rotate used bits out
	Je	NePi20
	Mov	Al,07h
	And	Ax,Dx
	Aam	04h			;Ah = row, Al = column
	Add	Al,03h			;add start position
	Stosw
	Xchg	Si,Ax			;Si = y*fieldWidth+x
	Cmp	[Bp+Si],Ch		;is place empty?
	Je	NePi10			;yes. check next tile
EndGame:Call	GetKey
	Jne	EndGame 		;loop until start key (or quit to DOS)
	Jmp	Short Start
NePi20:	Call	PutPiece		;put piece in starting position
	Xchg	Dx,Ax
	Sub	Dl,[Bp+Score-field+1]	;Speed = 10-Score/256
MoveDown:
	Test	Dh,Dh			;if dropped then add_score
	Jns	NoDrop  		;jump if not dropped
	Inc	Word Ptr [Bp+Score-field]	;Score = Score+1
	Org	$-1			;Score offset -78h = 88h ;-)
NoDrop: Db	88h,0D6h		;Mov Dh,Dl (+hidden dummy Setalc)
KeyLoop:Call	DoKeys
	Call	ShowField		;show move with delay
	Dec	Dh
	Jg	KeyLoop 		;loop until Cnt = 0 or Drop
	Mov	Bx,0100h		;Move piece down
	Call	TestPos
	Jcxz	MoveDown		;loop until down
Crunch:
	Mov	Di,Bx
	Mov	Cl,0Ah
Cru10:	Cmp	[Bp+Di],Ch		;is field[di] = Empty?
	Je	Cru40			;jump if a position is empty
	Inc	Di
	Loop	Cru10
Cru20:	Mov	Cl,[Bp+Di-fieldWidth]	;Move all tiles above current row
	Mov	[Bp+Di],Cl		; down one row
	Dec	Di
	Jne	Cru20
	Shl	Ax,1			;Points = Points<<1
	Add	[Bp+Score-field],Ax	;Score = Score+Points
					;20->40->80->160 => 20->60->140->300
	Mov	Cl,Dl			;speed of play (1/18th of seconds)
Cru30:	Call	ShowField		;show move with delay
	Loop	Cru30

Cru40:	Inc	Bh
	Cmp	Bh,fieldHeight-1	;Is last row
	Jb	Crunch
	Jmp	NewPiece

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
DoKeys:	Mov	Ah,01h			;Keyboard - Check for keystroke
	Int	KEYINT
	Je	DoRet			;jump if no keypressed
	Call	GetKey			;space key is tested
	Jne	DoKe20  		;free fall? (jump if not)
	Mov	Dh,-1			;It's dropped (Cnt < 0)
DoKe20: Cmp	Al,'6'			;move right?
	Ja	DoKe30
	Sub	Al,'4'-leftCh		;456 -> JKL (+6 bytes)
DoKe30:	Sub	Al,leftCh		;sub left key?
	Cmp	Al,3			;move right?
	Jnb	DoRet			;jump if not in range 6Ah..6Ch
	Cbw
	Dec	Ax			;rotate?
	Xchg	Bx,Ax			;Bl = direction
;Test if move is legal (not blocked) then actually do it
TestPos:Call	PutPiece		;remove piece from field
	Mov	Di,Si
	Mov	Cl,4
TePo10: Lodsw
	Test	Bx,Bx			;Is Bx with move info?
	Jnz	TePo20			;jump if not rotate
	Cmp	[Di+pieceC-pieceXY],Ch	;if PieceC # 32 then
	Je	PutPiece		;jump if blue block
	Xchg	Al,Ah			;newX(N)= PieceY(N)+PieceX(0)-PieceY(0)
	Neg	Ah			;newY(N)=-PieceX(N)+PieceX(0)+PieceY(0)
	Add	Ax,[Di]
	Sub	Al,[Di+1]
	Add	Ah,[Di]
TePo20:	Add	Ax,Bx			;newXY(N)= PieceXY(N)+dirXY
	Js	PutPiece		;out of field, can't rotate
	Mov	[Si+06h],Ax		;save newXY(N)
	Xchg	Di,Ax			;Di = y*fieldWidth+x
	Cmp	[Bp+Di],Ch		;is field[di] = free?
	Xchg	Di,Ax
	Jne	PutPiece
	Loop	TePo10
	Movsw				;PieceXY(N) = newXY(N)
	Movsw
	Movsw
	Movsw

PutPiece:
	Mov	Si,Offset pieceC-1+BootOfs	;Put a piece at new position
	Lodsw				;Si = pieceC-1 -> pieceXY
	Mov	Al,32+3*24		;set tile's dark color = P*2+32+72
	Aad	02h
	Pusha
	Mov	Cl,4
PutPi10:Xchg	Di,Ax
	Lodsw
	Xchg	Di,Ax			;Di = y*fieldWidth+x
	Xor	[Bp+Di],Al		;field[di] = al
	Loop	PutPi10
	Popa				;if Cx <> 0 then Blocked = true
	Mov	Al,10			;Used: Speed & Score
DoRet:	Ret

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Draw all the tiles in the field (which includes the borders)
;Show 4-digit 'score' with leading zeros centered above playfield
ShowField:
	Pusha
	Mov	Es,Bp
	Mov	Ax,[Bp+Score-field]
	Mov	Si,((fieldX+12/2)+1)*8
	Mov	Bx,10
	Mov	Cl,4
ShFi10: Cwd
	Div	Bx

	Pusha
	Xchg	Dx,Ax
	Add	Al,'0'
	Cwd
	Mov	Ds,Dx
	Lds	Bx,Ds:[43h*4]		;get font table location
	Shl	Ax,3			;* font height
	Add	Bx,Ax
	Mov	Cl,8			;for J:= 0, 8-1 do
dc10:	Mov	Ah,Ds:[Bx]		;Get byte from BIOS's font table
	Imul	Di,Dx,320
	Add	Di,Si			;Di = Y*320+X
	Mov	Ch,8			;for each bit in the Byte...
dc20:	Shl	Ah,1			;MSB is on the left side
	Db	0D6h			;Setalc
	And	Al,7			;if Byte & $80 then white else black
	Stosb				;plot dot; es:[di++]:= al
	Dec	Ch			;next I
	Jnz	dc20
	Inc	Bx			;update char row
	Inc	Dx			;next Y
	Loop	dc10
	Popa

	Sub	Si,8			;update char position
	Loop	ShFi10
	Push	Cs
	Pop	Ds

	Mov	Si,Offset field+(fieldHeight-1)*fieldWidth+010Bh
	Mov	Di,((fieldHeight-1+fieldY)*320+fieldX)*8-320
ShFi30: Mov	Dx,010Ch
	Sub	Si,Dx			;move to start of next scan line
ShFi40: Lodsb
	Mov	Cl,8
	Cmp	Al,Es:[Di+327]		;is already displayed?
	Je	ShFi80			;yes. jump over
	Pusha				;drawTile
	Mov	Dl,40h
	Mov	Ah,74h
ShFi50: Mov	Bx,Cx			;DrawSquare(Di, Al, Cx)
	Push	Di
ShFi60:	Add	Di,Dx
	Pusha
	Rep	Stosb
	Popa
	Dec	Bx
	Jne	ShFi60
	Pop	Di
	Dec	Cx
	Add	Ah,Ah			;74h -> -24 -> -48 -> -96
	Jnc	ShFi70
	Adc	Di,Dx			;face color position
ShFi70: Add	Al,Ah
	Jc	ShFi50
	Popa
ShFi80: Add	Di,Cx
	Dec	Dl
	Jnz	ShFi40
	Sub	Di,(320+10+2)*8
	Jnc	ShFi30
	Push	Cs
	Pop	Es

;Delay Cx 1/18ths of a second
;	Hlt
	Int	TIMEINT 		;Cx:Dx = ticks
	Mov	Bl,Dl
Del10:	Int	TIMEINT
	Cmp	Bl,Dl
	Je	Del10			;loop until time change
	Popa
TestSpc:Cmp	Al,startCh		;drop piece or start another game
	Ret

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
GetKey: Mov	Ah,00h			;Keyboard - Get keystroke
	Int	KEYINT
	Dec	Ah			;if ESC quit program?
	Jne	TestSpc			;jump if not
	Mov	Al,03h			;Set text mode 3
	Int	10h
	Int	19h			;Terminate program

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;    0	       1	  2	     3		 4	      5 	 6
;  [ ][ ]     [+][ ]  [ ][+][ ]  [ ][+]     [ ][ ][+][ ]  [ ][+][ ]  [ ][+][ ]
;  [ ][ ]  [ ][ ]	    [ ]     [ ][ ]		  [ ]		[ ]
;   blue    purple     violet	   pink 	red	   orange     yellow
;
;All pieces (except the blue block) rotate about the tile marked [+],
; which is the first entry for each piece in the tables below.
;Relative tile coordinates:
; 4*3bits = tblX_Y[piece]*256 + (low byte is always 50h)
; 3bits group (Ypos = high bit, Xpos = 2 low bits, +bias 2)
;		x3332221,11000xxx
;		    lo_b=01010000
tblX_Y	Db	00011101b	;0 - (0,1),(1,2),(1,1),(0,2)
	Db	00111101b	;1 - (0,3),(1,2),(1,1),(0,2)
	Db	00111110b	;2 - (0,3),(1,3),(0,1),(0,2)
	Db	01101110b	;3 - (1,2),(1,3),(0,1),(0,2)
	Db	00110000b	;4 - (0,3),(0,0),(0,1),(0,2)
	Db	00010111b	;5 - (0,1),(0,3),(1,1),(0,2)
	Db	00111100b	;6 - (0,3),(1,2),(0,1),(0,2)

Seed	Dw	12345		;initial seed for random number generator

;Each tile has 3 colors: face, highlighted edge, and shaded edge
pieceC	Db	?		;dark color of piece
;A piece is an array of 4 tiles, each with an X and Y coordinate
pieceXY Dw	4 Dup (?)	; (in character cells relative to Field)
newXY	Dw	4 Dup (?)	;coordinates of tiles in falling piece
				;tenative new piece position
field	Equ	0A000h			;playfield, includes the borders
Score	Equ	field-120		;display accumulated points score=0
emptyLn Equ	field-fieldWidth	;empty line, includes the borders

Buffer	Db	512 Dup(?)		;address of read buffer

	Org	Tet_Ofs+01FEh
BootID	Dw	0AA55h			;Put boot sector id

End	EntPt
