	page	240, 132
;ENTRY.ASM	25-Jul-2003		Boreal		loren_blaney@idcomm.com
;Hugi Compo 22: Falling Tetromino Game (not to be confused with Tetris (tm))
;
;Assemble:
; tasm /m
; tlink /t

fieldHeight	equ	25-1		;play field dimensions including border
fieldWidth	equ	10+2		; (in character cells)
fieldX	equ	(40-FieldWidth)/2	;position to display Field on screen
fieldY	equ	(25-FieldHeight)/2 + 1	; (in character cells)

empty	equ	0			;No tile = black
border	equ	52			;Border tile color = light cyan

;Keyboard commands:
leftCh	equ	'j'			;move piece left
rotCh	equ	'k'			;rotate (counterclockwise)
rightCh	equ	'l'			;move right
dropCh	equ	' '			;drop piece (free fall to get points)
startCh	equ	' '			;start another game
quitCh	equ	1Bh			;Esc = quit game

	.model	tiny
	.code
	.486
	org	100h
start:
main10:	mov	ax, 0013h		;set 320x200x256 graphic mode
	int	10h			; and erase screen

;Set up empty field with borders (and also initialize Score to 0)
	mov	di, offset field0	;point above field (trick to init Score)
	mov	bx, 23+2		;2 extra lines that are not displayed
	mov	al, border		; (trick to init Score)
main15:	stosb				;es:[di++]:= al
	mov	cx, fieldWidth-2
	mov	al, empty
	rep stosb			;es:[di++]:= al; cx--
	mov	al, border
	stosb				;es:[di++]:= al
	dec	bx			;loop for height many tiles
	jne	main15

	mov	cl, 12			;insert bottom border tiles
	rep stosb			;es:[di++]:= al; cx--
	call	showScreen		;show empty play field and score (0000)

;-------------- Game playing loop ---------------
;Randomly select a piece to fall down the Field
;P:= (predictable) random number 0..6
main20:	mov	ax, 9421		;seed:= seed*9421 + 1
	cwd				;dx:= 0
	imul	ax, 12345
main22:	inc	ax
	mov	word ptr main22-2, ax	;self-modifying code
	mov	cx, 7			;randomNum:= remainder(seed/7)
	div	cx

	mov	di, dx			;save index into ShapeTbl
	shl	dx, 1			;set tile's face color
	add	dl, 32			;PieceC:= P*2+32;  dl = piece face color
;Each tile has 3 colors: face, highlighted edge, and shaded edge

;Center the Piece at the top of Field
;Convert 1's & 0' in ShapeTbl into coordinates (relative to Field) in pXY
;(dh=0)
	mov	bl, [di+shapeTbl]
	mov	di, offset pXY
	mov	ax, -2			;offset relative to pivot point
main24:	mov	cl, 4			;(ch=0)
main25:	shl	bl, 1
	jnc	main26
	 stosw				;es:[di++]:= ax
main26:	inc	ax
	loop	main25

	mov	al, 10			;next row down
	dec	dh			;loop 2x
	jp	main24

	mov	bx, 6			;	bx = tenative offset to pivot pt
	mov	di, offset pXY		;	di -> tenative rotation array
	call	doMove			;does piece overlap already played
	je	main28			; pieces in field? jump if not

;Game over -- wait for start character
main27:	call	getKey			;wait for start key
	cmp	al, startCh
	jne	main27
	jmp	main10			;loop until quitCh
main28:
	mov	al, 10			;speedOfFall:= 10 - score/256
	sub	al, score+1
	cbw
	mov	speed, ax

;Make piece fall while handling keyboard commands
	xor	si, si			;Drop:= false	      si = drop flag
main30:	test	si, si			;if Drop (& not Blocked) then
	je	main31
	 inc	word ptr score		; Score:= Score + 1
	 call	showScore		; (showScreen would erase falling piece)
main31:
	mov	bp, speed		;Counter:= Speed      bp = speed Counter

main40:	mov	ah, 1			;if KeyHit then
	int	16h
	je	main50			;(jump if not)

	mov	bx, offXY		;set tenative offset and rotation to
	mov	di, offset pieceXY	; current offset and rotation

	call	getKey			;read in pending keystroke
	cmp	al, dropCh 		;free fall?
	jne	main41			;(jump if not)
	 inc	si			;Drop:= true
main41:
	cmp	al, leftCh		;move left?
	jne	main42			;(jump if not)
	 dec	bx
main42:
	cmp	al, rightCh		;move right?
	jne	main44			;(jump if not)
	 inc	bx
main44:
	cmp	al, rotCh		;rotate?
	jne	main48			;(jump if not)
	cmp	dl, 32			;if PieceC # 32 (blue block) then
	je	main48			;(jump if blue block)

	push	dx
	mov	cx, fieldWidth
	mov	di, 6			;for N:= 0, 4-1 do
main46:	mov	ax, [di+pieceXY]	;unpack X & Y components
	add	ax, 26
	cwd				;Y(N):= pieceXY(N)/12; X(N):= Rem
	idiv	cx			;ax=Y; dx=X
;	sub	ax, 2
	dec	ax
	dec	ax
	xchg	ax, dx			;get X; save PX(N):= Y in dx
;	sub	ax, 2
	dec	ax
	dec	ax
	neg	ax			;PY(N):= -X
	imul	ax, fieldWidth		;pack
	add	ax, dx			;pXY(N):= PY(N)*12 + PX(N)
	mov	[di+pXY], ax
	dec	di
	dec	di
	jns	main46
	pop	dx
	mov	di, offset pXY
main48:
	call	doMove	
main50:
	call	waitTick		;Delay(1)

	test	si, si			;loop until Drop
	jne	main52
	 dec	bp			; or Counter = 0
	 jne	main40
main52:
	mov	bx, offXY		;move piece down
	add	bx, fieldWidth
	mov	di, offset pieceXY
	call	doMove
	je	main30			;loop if not blocked

;Copy Piece into Field
	mov	bx, 6			;for N:= 0, 4-1 do
main62:	mov	di, [bx+pieceXY]	; Field(PieceXY(N)):= PieceC
	add	di, offXY
	mov	[di+field], dl		;piece color
	dec	bx
	dec	bx
	jns	main62

;If a horizontal row is full then remove it, and move everything above it down
	mov	bp, 20			;Points:= 20; (pb = points)
	xor	bx, bx			;from the top row to the bottom row...
main70:					;for J:= 0, FieldHeight-2 do
	imul	di, bx, fieldWidth	;for I:= 1, FieldWidth-2 do
	add	di, offset field+1	; if Field(I, J) = Empty then forget it
	mov	cx, fieldWidth-2
	xor	ax, ax
	repne	scasb			;cmp es:[di++], empty; cx--
	je	main76			;jump if a position is empty--forget row

;Move all tiles above row J down one row
	mov	dx, bx			;for J1:= J downto 1 do
main72:	imul	di, dx, fieldWidth
	add	di, offset field+1	;(+1 skips left border)
	mov	si, di
	sub	si, fieldWidth		;point to row above
					;  for I:= 1, FieldWidth-2 do
	mov	cx, FieldWidth-2	;    Field(I, J1):= Field(I, J1-1)
	rep movsb			;es:[di++]:= ds:[si++]; cx--
	dec	dx
	jne	main72
					;Score:= Score + Points
	add	word ptr score, bp	;20 + 40 + 80 + 160 => 20, 60, 140, 300
	shl	bp, 1			;Points:= Points << 1
	call	showScreen		;show the result

	mov	cx, speed		;Delay(Speed)
main74:	call	waitTick
	loop	main74
main76:
	inc	bx			;next row down
	cmp	bx, fieldHeight-2
	jna	main70
	jmp	main20

;-------------------------------------------------------------------------------
;If tenative move is legal (not blocked) then show the move on the screen
; Inputs:
;  dl = face color
;  bx = tenative piece offset
;  di -> tenative rotation array
; Outputs: pieceXY, offXY, Z flag clear (ne) if blocked

doMove:	pusha

	mov	bp, 6			;for N:= 0 to 4-1 by 2 do...
dm10:	mov	si, bx
	add	si, [bp+di]		;add posn. in rotation array to offset
	js	dm90			;jump if negative (above top of well)
	cmp	[si+field], empty	;see if location is occupied
	jne	dm90			;jump if so -- blocked
	dec	bp			;loop for 4 tiles
	dec	bp
	jns	dm10

;If not blocked then remove piece from screen by redrawing Field
	call	showScreen

;Get piece's new offset and rotation and draw it there
	mov	offXY, bx		;OffXY:= OXY
	mov	bp, 6			;for N:= 0 to 4-1 by 2 do...
dm40:	mov	ax, [bp+di]		; PieceXY(N):= PXY(N)
	mov	[bp+pieceXY], ax
	add	ax, bx			; + OffXY

	push	bx			;draw piece
	xchg	bx, ax
	mov	al, dl			;color
	call	drawTile		; DrawTile(PieceXY(N)+OffXY, PieceC)
	pop	bx

	dec	bp
	dec	bp
	jns	dm40

	xor	ax, ax			;set Z flag
dm90:
	popa
	ret

;-------------------------------------------------------------------------------
;Draw all the tiles in the field (which includes the borders) and showScore

showScreen:
	pusha

	mov	bx, fieldWidth*fieldHeight-1
df10:	mov	al, [bx+field]
	call	drawTile		;DrawTile(I, Field(I))
	dec	bx
	jns	df10

	popa
					;fall into showScore
;-------------------------------------------------------------------------------
;Show 4-digit Score with leading zeros centered above playfield

showScore:
	pusha

	mov	ax, word ptr score
	mov	bx, 10			;set up divisor
	mov	cx, 4			;for 4 digits...
ss10:	cwd				;dx:= 0
	idiv	bx			;ax:= dx:ax / 10;  dx:= remainder
	push	dx
	loop	ss10			;cx--
;(bh=0)
	mov	ah, 02h			;set cursor position
	mov	dl, (fieldY-1)*100h + (fieldX+fieldWidth/2)-2	;(dh=0)
	int	10h
;(ch=0)
	mov	cl, 4			;for 4 digit characters...
ss20:	pop	ax
	add	al, 30h			;convert to ASCII
	int	29h			;display character
	loop	ss20			;cx--

	popa
	ret

;-------------------------------------------------------------------------------
;Draw a tile
; Inputs:
;  al = tile face color (or 0 for no tile = black background)
;  bx = coordinate (in character cells) relative to Field

drawTile:
	pusha

;Convert bx from an index into field, into the screen coordinate of the tile
;ax:= bx/12; dx:= rem
;(ax+fieldY)*8 *320
; + (dx+fieldX)*8

	push	ax			;save color
	xchg	ax, bx			;get coordinate into ax
	mov	bx, fieldWidth		;di/12
	cwd
	idiv	bx
	imul	ax, 320
	add	ax, dx
	imul	ax, 8
	xchg	di, ax
	pop	ax			;get color

	test	al, al			;if C # Empty then
	je	dt05
	 add	al, 3*24		; do shadow first
dt05:	mov	bx, 8			;length of side of square (pixels)

;Draw a filled square
; Inputs:
;  al = color
;  bx = length of side (in pixels)
;  di = coordinate of upper-left corner (in pixels) relative to Field

dt10:	pusha
	push	es			;provide access to graphic screen
	push	0A000h+(fieldY*8*320+fieldX*8)/16
	pop	es

	mov	dx, bx
dt20:	mov	cx, bx
	rep stosb			;es:[di++]:= al; cx--
	add	di, 320			;move to start of next scan line
	sub	di, bx
	dec	dx
	jne	dt20

	pop	es
	popa


	dec	bx
	sub	al, 24			;do highlight second
	cmp	al, 32+2*24		;loop back for highlight
	jge	dt10
	sub	al, 24			;do center last
	add	di, 1+320		;move coordinate down and right 1 pixel

	cmp	al, 32			;loop back for center
	jge	dt10

	popa
gk10:	ret

;-------------------------------------------------------------------------------
;Get a keystroke and return it in al

getKey:	mov	ah, 0
	int	16h
	dec	ah			;scan code for quitCh = Esc = 01
	jne	gk10			;jump if not
	mov	al, 03h			;restore standard text mode
	int	10h
	int	20h			;return to DOS (or Windows)

;-------------------------------------------------------------------------------
;Delay 1/18th of a second

waitTick:
	pusha				;save ah, bx, cx, dx
	mov	ah, 0			;get tick count
	int	1Ah
	mov	bx, dx			;save it in bx
wt20:	int	1Ah			;wait for tick count to change
	cmp	bx, dx
	je	wt20
	popa
	ret

;-------------------------------------------------------------------------------
;   _ _        _ _      _ _ _      _ _        _ _ _ _       _ _ _      _ _ _
;  |_|+|     _|+|_|    |_|+|_|    |_|+|_     |_|_|+|_|     |_|+|_|    |_|+|_|
;  |_|_|    |_|_|          |_|      |_|_|                  |_|          |_|
;   blue    purple     violet      pink         red        orange     yellow
;    0        1          2          3            4           5          6
;   _ _ _ _    _ _ _ _
;  |_|_|+|_|  |7|6|5|4|
;  |_|_|_|_|  |3|2|1|0|
;
;All pieces (except the blue block) rotate about the tile marked [+]
;	bit:	76543210
shapeTbl db	01100110b		;0
	db	00110110b		;1
	db	01110001b		;2
	db	01100011b		;3
	db	11110000b		;4
	db	01110100b		;5
	db	01110010b		;6

speed	dw	?		;speed of play (1/18th of seconds)

;Extra 2 rows of field at top automatically initialize score when field is
; cleared, and eliminate need for clearing top row in crunchRow
field0	db	fieldWidth*2 dup (?)
score	equ	field0+1	;display accumulated points
field	db	fieldWidth*fieldHeight dup (?)	;playfield, includes the borders

;A piece is an array of 4 tiles, each with a coordinate relative to Field
pieceXY	dw	4 dup (?)	;coordinate of tiles in rotated piece
pXY	dw	4 dup (?)	;tenative new piece rotation

offXY	dw	?		;translational offset of piece within field

	end	start
