GetPiece:	pusha

		mov	ax,9421
		cwd
Seed:		imul	ax,ax,12345
		inc	ax
		mov	w ds:[o Seed+2],ax
		mov	bx,7
		div	bx
		xchg	ax,dx

		inc	ax		;Tile codes: 1-7 !!!

		mov	di,o CurrTile
		stosw
		add	ax,ax
		add	ax,o Tetros-2	;Because of empty block
		xchg	ax,si
		lodsw				
		xchg	ax,bx

GetCoord:	mov	ax,bx
		sar	ax,14
		shl	bx,2
		stosb
		jnz	s GetCoord
		jc	s GetCoord

		mov	ax,6		;kezdpoz: 6,0 (fell)
		stosw

		call	MakeAbs
		call	CheckColl	;c=1 if collision
		popa
		ret

;--------------------------------------------------------

Tetros		DW	0000110100011100b ;x0,y0,x1,y1,x2,...
		DW	0000110100010100b
		DW	0000010001011100b
		DW	0000000101011100b
		DW	0000110010000100b
		DW	0000010011011100b
		DW	0000010000011100b

;------------------------------------------------------

MakeAbs:	pusha
		mov	si,o TileX0r
		mov	di,o TileX0
		mov	cx,4
MakeAbsNext:	lodsw
		add	al,TileX
		add	ah,TileY
		stosw
		loop	MakeAbsNext
		popa
		ret

;-------------------------------------------------------

CheckColl:	pusha
		mov	si,o TileX0
		mov	cx,4
CheckCycle:	lodsw
		shl	al,4
		shr	ax,4
		add	ax,o Tube
		xchg	ax,bx
		salc
		xlatb
		or	al,al
		jnz	s Collision
		loop	CheckCycle
		call	ShowScreen
		stc	
Collision:	cmc
		popa
		ret

;--------------------------------------------------------

MovePiece:	pusha

		mov	bp,w ds:[o Speed]
		
MoveAgain:	mov	ah,1
		int	16h
		jz	s CheckDown

		call	SaveDatas
CheckKey:	call	GetKey		;AL=ASCII code
		mov	ah,1
		and	al,7
		mov	bx,o KeyTable
		xlatb
		call	ax
		call	MakeAbs
		call	CheckColl
		jnc	s CheckDown
		call	RestoreDatas

CheckDown:	call	WaitForOneTick
		sub	bp,1
		jg	s MoveAgain
		jnz	s Dropped
		mov	bp,Speed

Dropped:	call	SaveDatas
		inc	b ds:[TileY]
		call	MakeAbs
		call	CheckColl
		jc	s No_More_Down
		or	bp,bp
		jns	s NotDropped
		inc	w ds:[Score]
NotDropped:	call	ShowScreen
		jmp	s MoveAgain

No_More_Down:	call	RestoreDatas
		call	RealizeTiles
		call	ShowScreen
		popa
		ret

;--------------------------------------------------------

SaveDatas:	pusha
		mov	si,o TileX0r
		mov	di,2000h
		mov	cx,18
		rep	movsb
		popa
		ret

;--------------------------------------------------------

RestoreDatas:	pusha
		mov	si,2000h
		mov	di,o TileX0r
		mov	cx,18
		rep	movsb
		popa
		ret

;--------------------------------------------------------

RealizeTiles:	pusha
		mov	si,o TileX0
		mov	cx,4
PutIntoTube:	lodsw
		shl	al,4
		shr	ax,4
		add	ax,o Tube
		xchg	ax,di
		mov	ax,CurrTile
		stosb
		loop	PutIntoTube
		popa
		ret

;--------------------------------------------------------

CrunchRow:	pusha
		mov	dx,20		;Score Counter

CheckTube:	mov	di,o Tube+1	
CheckNextLine:	call	CheckLine	;Z=1 if line is not full
		jz	s NotFull

CopyLine:	mov	si,-16
		add	si,di
		mov	cx,10
		rep	movsb
		sub	di,26
		cmp	di,o Tube
		ja	s CopyLine
		add	w ds:[Score],dx
		add	dx,dx
		stc			;C=1, don't show moved
		call	ShowScreen	;tiles
		mov	cx,SpeedOriginal
CrunchPause:	call	WaitForOneTick
		loop	CrunchPause
		jmp	s CheckTube

NotFull:	add	di,16
		cmp	b ds:[di],11
		jb	s CheckNextLine
		popa
		ret

;--------------------------------------------------------

CheckLine:	pusha
		xor	ax,ax
		mov	cx,10
		repnz	scasb
		popa
		ret