
comment /*
         * This is my entry for HC22.  However, in a few recent changes,
         *  it now does not pass the tester.  Unfortunatly, I did not save
         *  the recent "good" entry's, and I just don't have the time to
         *  find were it is broke.
         * I thought if I at least saved on byte off the example, I could
         *  have an entry in the World League table, but oh well.
         *
         * I am all for a simpler, less time consumer task for HC23.
         *
         * If I have more spare time, I could even do a better job
         *  of hosting it.
         *
         * Thanks to Boreal for the excelent work.
         *
         * Cheers to all, Sniper (Ben)
         *
         */



.model  tiny
.code
.486
.rmode
           org 100h

mainloop:  mov  al,13h   ; set 320x200x256 graphic mode
           int  10h      ; and erase screen

           xor  ax,ax
           mov  score,ax
           mov  speed,ax

           ; place empty well in buffer
           mov  di,offset field
           mov  cx,23
L1:        push cx
           mov  al,52
           stosb
           mov  cl,10
           mov  al,0
           rep
           stosb
           mov  al,52
           stosb
           pop  cx
           loop L1
           mov  cl,12
           rep
           stosb

           call showScore
           call drawField

; =-=-=-=-=-=-=-=- Game playing loop -=-=-=-=-=-=-=-=
gameloop:  ; Randomly select a piece to fall down the Field
           cwd
           imul ax,seed,9421
           inc  ax
           mov  seed,ax
           div  word seven
           xchg dx,ax       ; ax now = random number 0..6

           shl  al,1
           mov  di,ax
           shl  di,1
          
           add  al,32
           mov  pieceC,al
          
           xor  bp,bp         ; game over flag

           ; Center the Piece at the top of the Field
           mov  bx,3 
sp10:      mov  al,[bx+di+tblX]
           add  al,6
           mov  [bx+pieceX],al
           mov  al,[bx+di+tblY]
           mov  [bx+pieceY],al

; Will piece overlap already played pieces?
; if Field(PieceX(N), PieceY(N)) # Empty then GameOver:= true
           movsx dx,byte [bx+pieceY]
           imul si,dx,12
           mov  al,[bx+pieceX]
           cbw
           add  ax,offset field
           add  si,ax
           lodsb
           or   al,al
           jz   short sp30
           inc  bp
sp30:      dec  bx
           jns  short sp10

           or   bp,bp             ;if GameOver then quit
           jnz  main80
          
           mov  al,pieceC    ;display piece in starting position
           call drawPiece

           mov  byte drop,0     ;Drop:= false
 
main27:    movzx bp,byte [score+1] ;Speed:= 10 - Score/256
           neg  bp
           add  bp,10
           mov  speed,bp



mp10:      mov  ah,1
           int  16h
           je   notspace   ; 7 bytes

           mov  bx,3
mp20:      mov  al,[bx+pieceY]
           mov  [bx+pY],al
           dec  bx
           jns  short mp20
          
           call getKey
           cmp  al,'j'          ;move left?
           jne  short notleft
           mov  bx,3
mp25:      mov  al,[bx+pieceX]
           dec  ax
           mov  [bx+pX],al
           dec  bx
           jns  short mp25
           call doMove
           jmp  short notspace

notleft:   cmp  al,'l'          ; move right?
           jne  short notright
           mov  bx,3
mp35:      mov  al,[bx+pieceX]
           inc  ax
           mov  [bx+pX],al
           dec  bx
           jns  short mp35
           call doMove
           jmp  short notspace

notright:  cmp  al,'k'          ; rotate?
           jne  short notrotate
           mov  al,pieceC       ; don't rotate a blue block
           cmp  al,32
           je   short notspace
          
           mov  bx,3
           xor  si,si
mp45:      mov  al,[bx+pieceX]
           sub  al,[si+pieceX]
           neg  al
           add  al,[si+pieceY]
           mov  [bx+pY],al
           mov  al,[bx+pieceY]
           sub  al,[si+pieceY]
           add  al,[si+pieceX]
           mov  [bx+pX],al
           dec  bx
           jns  short mp45
           call doMove
           jmp  short notspace

notrotate: cmp  al,20h          ; free fall
           jne  short notspace
           mov  byte drop,-1
           xor  bp,bp
notspace:  mov  si,1
           call delay
          
           cmp  byte drop,0     ;loop until Drop
           jne  short mp75
           dec  bp
           jg   mp10          ; 28 bytes

           ; Move piece down
mp75:      mov  bx,3
mp80:      mov  al,[bx+pieceX]
           mov  [bx+pX], al
           mov  al,[bx+pieceY]
           inc  ax
           mov  [bx+pY],al
           dec  bx
           jns  short mp80
           call doMove
          
           cmp  byte drop,0
           je   short mp90
           cmp  word blocked,0
           jne  short mp90
           inc  word score
           call showScore


mp90:      cmp  word blocked,0
           je   main27

           ; Copy Piece into Field
           mov  bx,3
main34:    movsx cx,byte [bx+pieceX]
           movsx dx,byte [bx+pieceY]
           imul di,dx,12
           add  di,cx
           add  di,offset field
           mov  al,pieceC
           stosb
           dec  bx
           jns  short main34
          
           call crunchRow
           jmp  gameloop



main80:    call getKey      ;wait for start key
           cmp  al,20h
           jne  short main80

           ; ah = 0???

           jmp  mainloop  ;loop until ESC


; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; If tenative move is legal (not blocked) then actually do it
doMove     proc near uses all
           xor  bp,bp
           mov  bx,3
dm10:      mov  al,[bx+pY]
           test al,al
           js   short dm15
           cbw
           imul si,ax,12
           mov  al,[bx+pX]
           cbw
           add  si,ax
           add  si,offset field
           lodsb
           test al,al
           je   short dm20
dm15:      mov  bp,-1
           jmp  short dm90
dm20:      dec  bx
           jns  short dm10

           ; If not blocked then remove piece from screen
           xor  al,al
           call drawPiece

           ; get piece's new position
           mov  bx,3
dm40:      mov  al,[bx+pX]
           mov  [bx+pieceX],al
           mov  al,[bx+pY]
           mov  [bx+pieceY],al
           dec  bx
           jns  short dm40

           ; and draw piece at new position
           mov  al,pieceC
           call drawPiece

dm90:      mov  blocked,bp
           ret
doMove     endp



fieldHeight equ 24        ;play field dimensions including border
fieldWidth  equ 12        ; (in character cells)
fieldX      equ 14        ;position to display Field on screen
fieldY      equ 1         ; (in character cells)

empty       equ 0         ;No tile = black
border      equ 52        ;Border tile color = light cyan

;Keyboard commands:
leftCh      equ 'j'     ;move piece left
rotCh       equ 'k'     ;rotate (counterclockwise)
rightCh     equ 'l'     ;move right
dropCh      equ ' '     ;drop piece (free fall to get points)
startCh     equ ' '     ;start another game
quitCh      equ 1Bh     ;quit game



; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;If a horizontal row is full then remove it, and move everything above it down
crunchRow  proc near uses all

           mov  bp,20      ; Points
           mov  bx,1
cr00:      imul si,bx,12
           add  si,(field+1)
           mov  cx,10
cr05:      lodsb
           test al,al
           je   short cr80
           loop cr05

           ; Move all tiles above row J down one row
           mov  dx,bx
cr10:      imul di,dx,12
           add  di,(field+1)  ;(+1 skips left border)
           mov  si,di
           sub  si,12
           mov  cx,10
           rep
           movsb
           dec  dx
           jne  short cr10

           ; Clear top row
           xor  al,al
           mov  cx,10
           mov  di,(field+1)
           rep
           stosb
          
           call drawField   ;show the result
          
           add  score,bp
           shl  bp,1
           call showScore
          
           mov  si,speed   ;Delay(Speed)
           call delay
cr80:      inc  bx
           cmp  bl,22
           jna  short cr00

           ret
crunchRow  endp

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Draw all the tiles in the field (which includes the borders)
; Register usage:
;  cx = X coordinate (in character cells) relative to 14, 1
;  dx = Y coordinate
drawField  proc near uses all
           mov  dx,23
df10:      mov  cx,11
df20:      imul si,dx,12
           add  si,cx
           add  si,offset field
           lodsb
           call drawTile
           dec  cx
           jns  short df20
           dec  dx
           jns  short df10
           ret
drawField  endp

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Draw a piece
; Inputs: al = tile face color (pieceC or empty)
drawPiece  proc near
           mov  bx,3
dp10:      movsx cx,byte [bx+pieceX]
           movsx dx,byte [bx+pieceY]
           call drawTile
           dec  bx
           jns  short dp10
           ret
drawPiece  endp

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Draw a tile
; Inputs:
;  al = tile face color
;  cx = X coordinate (in character cells) relative to 14, 1
;  dx = Y coordinate
drawTile   proc near uses all  ; save all registers

           ; Get coordinates (in pixels) relative to upper-left corner of screen
           add  cx,14
           shl  cx,3
           add  dx,1
           shl  dx,3
          
           mov  bx,8
           test al,al
           jne  short dt10
           call drawSquare
           jmp  short dt30

dt10:      add  al,72
           call drawSquare
         
           add  al,-24
           dec  bx
           call drawSquare
          
           add  al,-48
           dec  bx
           inc  cx
           inc  dx
           call drawSquare
dt30:      ret
drawTile   endp

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;Draw a filled square
; Inputs:
;  al = color
;  bx = length of side (in pixels)
;  cx = X coordinate of upper-left corner (in pixels)
;  dx = Y coord
drawSquare proc near uses all es
           push 0A000h
           pop  es
           imul di,dx,320
           add  di,cx
           mov  dx,bx
ds10:      mov  cx,bx
           rep
           stosb
           add  di,320
           sub  di,bx
           dec  dx
           jnz  short ds10
           ret
drawSquare endp

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Show 4-digit 'score' with leading zeros centered above playfield
showScore  proc near uses all ; save regs
           mov  ax,score
           mov  bx,10      ; set up divisor
           mov  cx,4       ; for 4 digits...
ss10:      cwd             ; dx = 0
           idiv bx         ; ax = dx:ax / 10;  dx:= remainder
           add  dx,0730h   ; Screen(di) = Rem(0) + '0' + White<<8
           push dx
           loop ss10
        
           mov  ah,02h     ; set cursor position
           mov  dx,18
           int  10h
        
           mov  cl,4
ss20:      pop  ax
           mov  ah,0Eh
           mov  bl,07h
           int  10h
           loop ss20
           ret
showScore  endp

; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Get a keystroke and return it in al
getKey     proc near
           mov  ah,0
           int  16h
           cmp  al,1Bh       ; quit program?
           jne  short gk10   ; jump if not
           mov  ax,0003h     ; restore standard text mode
           int  10h
           .exit             ; return to DOS
gk10:      ret
getKey     endp


; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; Delay si 1/18ths of a second
delay      proc near uses all ; save bx at least
           mov  ah,0    ; get tick count
           int  1Ah
del10:     mov  bl,dl   ; save LSB in bl
del20:     int  1Ah     ; wait for tick count to change
           cmp  bl,dl
           je   short del20
           dec  si
           jnz  short del10
           ret
delay      endp


; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;   _ _        _ _      _ _ _      _ _        _ _ _ _       _ _ _      _ _ _
;  |_|_|     _|+|_|    |_|+|_|    |_|+|_     |_|_|+|_|     |_|+|_|    |_|+|_|
;  |_|_|    |_|_|          |_|      |_|_|                  |_|          |_|
;   blue    purple     violet      pink         red        orange     yellow
;    0        1          2          3            4           5          6
;
;All pieces (except the blue block) rotate about the tile marked [+],
; which is the first entry for each piece in the tables below.
;Relative tile coordinates:
tblX	db	0, -1, -1,  0		;0
      db  0,  1, -1,  0   ;1
      db  0, -1,  1,  1   ;2
      db  0, -1,  0,  1   ;3
      db  0, -2, -1,  1   ;4
      db  0, -1,  1, -1   ;5
      db  0, -1,  1,  0   ;6

tblY	db	0,  0,  1,  1		;0
      db  0,  0,  1,  1   ;1
      db  0,  0,  0,  1   ;2
      db  0,  0,  1,  1   ;3
      db  0,  0,  0,  0   ;4
      db  0,  0,  0,  1   ;5
      db  0,  0,  0,  1   ;6


seed       dw  12345  ; initial seed for random number generator
seven      dw  07

field      dup 288,?  ; the playing field
score      dup 2,?    ; display accumulated points
speed      dup 2,?    ; speed of play (1/18th of seconds)

drop       dup 1,?    ; flag: piece is dropping
blocked    dup 2,?    ; flag: piece cannot move in current direction

;A piece is an array of 4 tiles, each with an X and Y coordinate
pieceX     dup 4,?    ; coordinates of tiles in falling piece
pieceY     dup 4,?    ; (in character cells relative to Field)

;Each tile has 3 colors: face, highlighted edge, and shaded edge
pieceC     dup 1,?    ; face color of piece
pX         dup 4,?    ; tenative new piece position
pY         dup 4,?

.end
