; Uses Hannes's 5 bytes move table with X/Y exchange  ;
org 256--------------------------------------25Sep04-;
;       T H E     K N I G H T ' S     T O U R         ;
;-----------------------------------------------------;
; Author/Country : Espineter / Spain                  ;
;           Name : Antonio Jose Villena Godoy         ;
;          Email : espineter@yahoo.com                ;
;        Compile : nasm entry.asm -o entry.com        ;
;           Size : 45 (Offtime entry for HC #23)      ;
;-----------------------------------------------------;
  db   36,18,33,-31,14,-18          ;table/push cs----;
  pop  di        ;di=dx=cs----------------------------;
a mov  bl,5      ;number of posible moves-------------;
  aam  16        ;traslate nibble to byte format------;
  stosw          ;register coordinates----------------;
  aad  16        ;restore nibble----------------------;
  sub  ch,cl     ;cl=-2,80h/2=40h=64 moves------------;
  jns  b         ;if 64 moves found print str & exit--;
  movsb          ;put '$' to end of string------------;
  xchg ax,bp     ;ah=9 (print stdout)/ah=0 exit-------;
  int  21h       ;print string to out/exit program----;
b pusha          ;save registers before tentative-----;
  add  al,[bx+si];update X and Y coordinates----------;
  test al,88h    ;check bounds 0<=X&Y<=7--------------;
  btc  [si-16],ax;test if the cell is empty-----------;
  jnz  c         ;if excess bounds don't try move-----;
  jnc  a         ;if cell is empty try move-----------;
c btc  [si-16],ax;clear the cell----------------------;
  popa           ;restore registers-------------------;
  dec  bx        ;try the next move-------------------;
  jnz  b         ;if pending move, goto b-------------;
  jmp  c         ;else return to last valid move------;
