// Test Suite for The Knight's Tour ver 1.5
// Coded by G3 (tgm80@mail.ru)
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <time.h>
#include <string.h>

void show_board(int board[8][8], char *filename);

int main(int argc, char *argv[])
{
	unsigned int i,j;
	FILE *in;
	int board[8][8];
	int x[65];
	int y[65];
	int filesize;
	unsigned long n=0, l;
	char comname[256];
	clock_t starttick=0, endtick=0;

	if(argc != 4)
	{
		puts("Usage: test.exe entry.com route.dat time.dat");
		return 1;
	}

	if((in = fopen(argv[2],"rb")) == NULL)
	{
		printf("Can't open file %s\n",argv[1]);
		return 1;
	}

	fseek(in, 0, SEEK_END);
	filesize = ftell(in);
	fseek(in, 0, SEEK_SET);

	for(i=0; i<64; i++)
	{
		x[i] = fgetc(in);
		y[i] = fgetc(in);
	}
	fclose(in);

	for(i=0; i<8; i++)
		for(j=0; j<8; j++)
			board[i][j] = 0;

	for(i=0; i<filesize/2; i++)
	{
		if(x[i]>7 || y[i]>7)
		{
			show_board(board, argv[3]);
			printf("Error in %d turn. Jump out of board. ",i+1);
			printf("Can't move to (%d, %d).\n",x[i],y[i]);
			return 1;
		}
		if(i)
		{
			if(x[i]==x[i-1] || y[i]==y[i-1] || abs(x[i]-x[i-1])+abs(y[i]-y[i-1])!=3)
			{
				show_board(board, argv[3]);
				printf("Error in %d turn. Incorrect move for Knight. ",i+1);
				printf("From (%d, %d) to (%d, %d).\n",x[i-1],y[i-1],x[i],y[i]);
				return 1;
			}
		}
		if(board[y[i]][x[i]])
		{
			show_board(board, argv[3]);
			printf("Error in %d turn. Move to occupied cell. ",i+1);
			printf("From (%d, %d) to (%d, %d).\n",x[i-1],y[i-1],x[i],y[i]);
			return 1;
		}
		board[y[i]][x[i]] = i+1;
	}

	show_board(board, argv[3]);

	if(filesize==128)
	{
		puts("Congratulations!!! You find the solution!!!");
		strcpy(comname, argv[1]);
		strcat(comname," >nul");
		while(1)
		{
			printf("\nEnter number of repetitions (0 for Exit) ");
			scanf("%ld",&n);
			if(n==0)	break;
			printf("Please wait a minute...\n");
			starttick = clock();
			for(l=n; l; l--)
				system(comname);
			endtick = clock();
			printf("Performance time: %.8f seconds.\n", ((endtick-starttick)<<16)/1193180.0/(double)n);
		}
	}
	else
		printf("Incorrect route file size: %u bytes\n",filesize);

	return 0;
}

void show_board(int board[8][8], char *filename)
{
	int i,j;
	unsigned long starttick=0, endtick=0;
	FILE *stream;

	puts("");
	puts("    0  1  2  3  4  5  6  7 ");
	puts("  +--+--+--+--+--+--+--+--+");

	for(i=0; i<8; i++)
	{
		printf("%d ",i);
		for(j=0; j<8; j++)
		{
			if(board[i][j])
				printf("|%2d", board[i][j]);
			else
				printf("|  ");
		}
		printf("|\n");
		puts("  +--+--+--+--+--+--+--+--+");
	}
	puts("");
	stream = fopen(filename, "rb");
	fread(&starttick,4,1,stream);
	fread(&endtick,4,1,stream);
	printf("Performance time: %.1f seconds.\n", ((endtick-starttick)<<16)/1193180.0);
}
