; -==============================-
; Hugi Size Coding Competition #23
;
; Task   : The Knight's Tour
; Author : Ang Chin Keong
; Country: Malaysia
; Contact: chinkeong81@yahoo.com
; Date   : 30 Sep 2004
; Compile: MASM entry.asm
; LINK   : LINK /TINY entry,,,,,
; Size   : 137 bytes
; -===[ http://www.hugi.scene.org/compo/ ]===-

.MODEL TINY
.286
.CODE
.STARTUP
		ORG 0F0H

BOARD		DB	8 DUP(?)
Box		DW	?
DHDL		DW	?

		ORG 100H
		
		MOV	DX, 0201H
		MOV	DI, OFFSET XDir - 1
		MOV	SI, 0

GO		PROC NEAR
		PUSHA
		MOV	CL, 8
NextDirection:	
		CLC
		MOV	AX, DX	; DX = Prev location, AX = proposed
		MOV	BX, CX	; CX = Movement
		ADD	AL, [DI+BX] ; AX = proposed location
		ADD	AH, [DI+BX+8]
		
		; IF SI == 64
		CMP	SI, 64 
		JNE	@F
			STC
			JMP	Exit
@@:		; ENDIF SI == 64
	
		; IF	AL < 8 && AH < 8
		CMP	AL,8
		JAE	@F		
		CMP	AH,8
		JAE	@F		
 
			PUSHA			
			MOV	BL, AH		; Board Y
			MOV	DH, [Board + BX]
			MOV	DL, 1
			MOV	CL, AL
			SHL	DL, CL			
			MOV	BOX, BX
			MOV	DHDL,DX
			TEST	DH, DL
			POPA
			JNZ	BoxFilled
			
			PUSHA
			;Set BOX
			MOV	BX, BOX
			MOV	DX, DHDL
			OR	DH, DL
			MOV	[Board + BX], DH
			
			MOV	DX, DHDL	
			PUSH	BX
			PUSH	DX
					
			MOV	DX, AX
			INC	SI
			CALL	GO
				
			POP	DX
			POP	BX
				
			JNC	ThisRouteFail
				
			MOV	DX, AX			
			MOV	AH, 2
			INT	21H
			XCHG	DH, DL
			MOV	AH, 2
			INT	21H
			POPA
			STC
			JMP	Exit
ThisRouteFail:			
			MOV	[Board + BX], DH
			POPA
BoxFilled:			
@@:		; END IF	AL < 8 && AH < 8	
		LOOP	NextDirection
Exit:
		POPA
		RET		
GO		ENDP

xDir		DB	 2,  2,  1,  1, -1,-1, -2,-2
yDir 		DB	 1, -1,  2, -2, 2, -2, 1, -1

END

; -------------------------------------------------------------
;                      Code Reference
; --------------------------------------------------------------
; Title     : The Knight's Tour
; Algorithm : Using Recursive Function call
; Author    : Ang Chin Keong
; Compiler  : VB.NET
;
;    Dim Board(8, 8) As Integer
;    Dim dx() As Integer = {-2, -2, -1, -1, 1, 1, 2, 2}
;    Dim dy() As Integer = {-1, 1, -2, 2, -2, 2, -1, 1}
;
;    Sub Main()
;        Go(2, 1, 1)
;    End Sub
;
;    Function Go(ByVal y As Integer, ByVal x As Integer, ByVal Count As Integer) As Boolean
;        Dim i As Integer
;        For i = 0 To 7
;            If (x + dx(i) >= 0 And x + dx(i) < 8 And y + dy(i) >= 0 And y + dy(i) < 8) Then
;                If (Board(y + dy(i), x + dx(i)) = 0) Then
;                    Board(y + dy(i), x + dx(i)) = Count
;                    If Count = 64 Then
;                        Return True
;                    ElseIf Go(y + dy(i), x + dx(i), Count + 1) = True Then
;                        Return True
;                    Else
;                        Board(y + dy(i), x + dx(i)) = 0
;                    End If
;                End If
;            End If
;        Next
;        Return False
;    End Function