;Spider and Albe's contribution to
;Hugi competition n. 23
;
;This code is based on an algorithm written by Bonz.
;
;Assemble it with:
;nasm -o entry.com entry.asm
;

	ORG	0x100
	BITS	16
	
	section	.text
	
main:

;This is the "delta" table, it contains the moves for the knight.
;We've arranged it to fit into the code.

	db	0x0e		;push cs

	db	0x1f		;pop ds

	db	0xdf		;fucomip st6
	db	0xee

	db	0x21		;and dx,si
	db	0xf2

	db	0xe1		;loope $+2
	db	0

;Here we go with the "real" code...

	mov	di,0x8800	;the address for the board; we also need BH=0x88 for position checking later
	push	di
	rep	stosb		;fill the board with zeros; assume AL=0 here
	pop	bx		;and get board address in BX

	mov	cl, 0x40	;64 is tour's length...

;-----------------------------------------------------------------------

;This is a recursive routine, we'll call it 64 times; when we've reached
;the end of recursion (that's when CX=0), we've found a tour.

search:
	jcxz	.carry_return	;if CX=0, we reached the recursion foot
	
	test	bl,bh		;if (BL & 0x88)!=0, we are out of the board
	jnz	.return

	dec	byte [bx]	;flag an occupied cell with 0xFF; but if it was already taken, this sets PF=0 and we quit the routine
	jnp	.increment
	
	mov	di,si		;DS=SI=0x100, the address of "delta" table

.for:
	pusha

	add	bl,byte [di]	;try a direction...

	dec	cx
	
	call	search

	popa

	jc	.success	;if CF=1, it's the end of recursion, and we've found the tour

	scasb
	jne	.for

.increment:
	inc	byte [bx]	;reset the original cell value

.return:
	ret

.success:
	xchg	bx,ax
	aam	16		;AL=BL%16; AH=BL/16
	xchg	dx,ax		;DL=first digit

	mov	ah,2

	int	0x21
	mov	dl,dh		;DL=second digit
 	int	0x21

.carry_return:	
	stc			;set CF, to notify that we found the tour
	ret
