;
; Hugi Compo #23 - The Knight's Tour
;
; compile with nasm:
;	nasmw entry.asm -o entry.com
;
; written by Anton Khorev (tony29@yandex.ru)
;

; consts
POS_MASK	equ 77h 	; valid position mask
DIR_MASK	equ 7h		; valid direction mask
MOVES		equ 8*8 	; number of moves

; bss
Board		equ 0F0h	; assume there are 16 zero bytes

; code
org 100h
; { init
	mov cl,MOVES		; assume ch == 0
	mov dx,0924h		; 09h == dos fn to print a string; 24h == string terminator and starting location
	push dx 		; save string terminator to stack
	; direction is in si ; assume si == 100h
; } init

; { main loop
Main:
	lodsw				; change direction two steps clockwise: si += 2;
	; { direction select loop
	Dir:
		dec si			; change direction one step counter-clockwise
		and si,byte DIR_MASK	; keep direction in 0..7 range
		mov ax,dx		; put position to ax
		add al,[Move+si]	; make a move
		test al,~POS_MASK	; test if it's inside the board
		jnz Dir 		;	if not, try next direction
		bts [Board-900h/8],ax	; test if cell is occupied / mark it as occupied ; 900h/8 is because ah==9
		jc Dir			;	if it is, try next direction
	; } direction select loop
	mov dl,al			; put new position to dl
	aam 16				; unpack position: ah = y; al = x
	push ax 			; save position to stack forming $-terminated string
	loop Main			; continue if there are moves left
; } main loop

; { print out the result
	xchg ax,sp			; load pointer to string into ax
	xchg ax,dx			; dx = ptr to string; ah = 09h (print string fn)
	int 21h 			; print string
; } print out the result

	int 20h 			; exit

; data:     dy dx   dy dx   etc
Move	db -10h+2, -20h+1, -20h-1, -10h-2, +10h-2, +20h-1, +20h+1, +10h+2,
