; Hugi Compo #23
; Knight Tour
; by Aphex - august-september 2004

; History:
;  31.08   90 bytes - first working version!
;   1.09   62 bytes - changed buffers to stack (pusha/popa)
;            	    - changed the data stream from (-16|-1) pairs to (-16-1) 
;		    - usage of inc/dec mark-up with PF for signaling busy cell
;		    - tricky main loop starting with db 82h
;		    - found SPEC_SOL trick (sometimes 7 knight moves are req-ed)
;   2.09   60 bytes - usage of AX for both old pos and new pos
;		    - BH = 24h
;   6.09   58 bytes - usage of DL for old pos, DH = BH
;		    - string of moves has 1 byte of code (first one)
;  13.09   57 bytes - though starting at (0,0), first pos is (1,2) or (2,1)
;		    - SPEC_SOL removed temporarily
;  14.09   54 bytes - changed inc/dec/jnp for xor/cmp/jnz
;		    - start again from (0,0)
;		    - four bytes of moves string are now written in code
;
; Compile: tasm /m entry
; Link: tlink /t/x entry

DEBUG		equ 	0		; debug initialization

p286
model tiny
codeseg
startupcode

start: 

	IF	DEBUG
	xor	ax, ax
	xor	bx, bx
	mov	cx, 0FFh
	mov	dx, cs
	mov	di, sp
	mov 	si, 100h
	mov	bp, 91Eh
	ENDIF
	
					; set memory space	
	mov	bh, 24h
	mov 	di, bx		
	rep 	stosb
	                        	; bx -> chess table
					; di -> output buf+2

	mov 	cl, 63			; 64 moves 
loopca:

	mov 	dx, bx			; dl = old pos, dh = bh

	mov 	si, offset moves
	mov	al, ?
	org	$-1
rollback:
	popa				; undo
moves:
	or	al, 0FDh	        ; 0Ch/-18d, FDh/-33d
	cmp	ax, 10FFh               ; 3Dh/31d, FFh/-31d, 10h/-14d

	xor	[bx], bh		; 30h/18d, 3Fh/33d

loopc:
	lodsb				; ACh/8Eh - always dummy
					; after add will fail on test al, 8?
	sub	al, 1Eh			; 2Ch/14d, 1Eh/0
	jz 	rollback		

	add 	al, dl			; calculate new position
	test 	al, 88h			; out of table
	jnz 	loopc

	mov	bl, al
	cmp	[bx], ch
	jnz	loopc

	pusha				; save status for undo
	aam 	10h         	        ; break nibbles
	stosw				; output
	loop 	loopca			; loop

	mov	[di], bh
	mov	dl, -3			; because dh = bh

	xchg	bp, ax
	int	21h	               	; display results


	int	20h			; back to DOS - 2 bytes :-(
	
end start
