;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
; 8.Sep.2004 - 54 bytes Entry for the Hugi Size Coding Compo #23
; The Knight's Tour
;
; Compile with nasm v0.98.38:
;   nasm -fbin -O4 -oentry.com entry.asm
;
; Version history:
;   56 - 28.Aug.2004 by ATV	email: askovuori@hotmail.com
;   54 -  8.Sep.2004 by ATV
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
bits 16
segment .text

STARTX		equ 0			;range 0..7
STARTY		equ 0			;range 0..7

org 0100h	;assume: ax=0,bh=0,cx=00FFh,si=0100h,bp=09xx

Start:
	lea	di,[si+bp]
	rep	stosw			;clear board
	mov	dx,di			;place for solution
	mov	cl,64			;need 64 moves
%if (STARTX | STARTY) <> 0
	mov	al,STARTY*16 + STARTX
%endif

check_place:
	bts	[si+bp],ax		;was it free?
	jc	prev_move
	push	ax
	aam	10h
%ifdef ascii
	aad	8
	xchg	ax,bx
	mov	al,65
	sub	al,cl
	mov	[bx+si-80h],al
%else
	stosw				;save place
%endif
	pop	ax
	loop	new_place
%ifdef ascii
	mov	cl,64
	shr	si,1
show_more:
	lodsb
	aam	0Ah
	or	ax,3030h		;to ascii
	xchg	al,ah
	stosw
	mov	al,20h
	stosb
	test	si,7			;is end of row?
	jnz	same_row
	mov	ax,0A0Dh
	stosw
same_row:
	loop	show_more
%endif
	mov	ax,0924h		;DOS - Write string
	stosb
	int	21h			;note: stack has 63*pusha
%ifdef delta1
delta	db 31,18,14,-14,-18,-31,-33
%else
delta	db 14,31,18,-14,-18,-31,-33
%endif
	int	20h			;exit, can't use ret

new_place:
	mov	bl,8
delta_loop:
	pusha
	add	al,[si+bx+delta-Start-2];+delta
	test	al,88h			;is over board?
	jz	check_place
prev_move:
	popa
	dec	bx			;last delta?
	jnz	delta_loop
	btc	[si+bp],ax		;board[y][x] = 0
	jmp	prev_move
