; Knight's tour, by Bonz
; 60  First version, 25/8/2004
; 59  Use the shorter TEST AL, 88h
; 58  Do not initialize CL to 64
; 57  Remove recursion, print with function 9
; 55  Move data area to 24xxH
; 54  Use SALC trick to save a jump in the test code

	org	100h
start:
	mov	bh, 24h			; point BX to data area (24h = $)
	mov	di, bx			; zero it out
	rep	stosw			; do it
	mov	dx, di			; save pointer for DOS function 9
					; DL = 0feh, any signed value will do

init_search:
	pusha				; save registers
	mov	si, delta		; point to knight movement table

	add	byte [bx], dl		; mark checker as used
	salc				; if double visit, set AL = FFh
	or	al, bl			; if single visit, set AL = BL
	test	al, 88h			; check for bad move
	jnz	backtrack		; if invalid x or y, try another move

	aam	16			; split X and Y of saved position
	stosw				; move them into the output string

	add	cl, bh			; add 24h until back to 0 (64 iterations)
	jnz	again
	mov	byte [di], bh		; end the string with a $
	xchg	bp, ax
	int	21h			; print
	int	20h			; and exit

again:
	lodsb				; get next movement
	sub	bl, al		; get next location
	jno	init_search		; recurse unless out of board

backtrack:
	popa				; get back old knight position
	sub	byte [bx], dl		; reset checker as unused
	jmp	short again

delta:
	db	33			; first delta = -33
	db	-2			; -31
	db	-13			; -18	
	db	-4			; -14
	db	-28			; 14
	db	-4			; 18
	db	-13			; 31
	db	-2			; 33
	db	33 - 128		; 128 overflows BL and exits the loop
