; Hugi Compo #23 - Knight's Tour
;
; Entry by Flyke ( ville@heaven.dk )
; 
; An implementation of Warnsdorff's rule
;
; http://w1.859.telia.com/~u85905224/knight/eWarnsd.htm
;
; Last changed 08.09.2004
; 
; masm 6.14
; ml /c entry.asm
; link /tiny entry.obj,entry.com, , , ,


boardoffset EQU 10000d

.model tiny
.code
.186

	org 100h

start:

	mov di, boardoffset
	rep stosb				; cx is 00ffh on startup.. initializes board
	
	
mainloop:	
	mov cl, 8
	
	mov bx, ax				; ax always hold the index when reaching this instruction
						; first time this is executed ax=0 ( start position )
						; then ax = index from end of program
	
	mov byte ptr [boardoffset+bx], cl	; mark location visited by setting location != 0
	
	
	mov dx, 0810h				; dh = 08d, dl=16d
	div dl
	xchg ah, al
	stosw					; using the memory from 10000d + 0ffh to store the moves
	
	
moveloop:
	push bx
	call move
	jnz trynext
		
	push cx
	mov cl, 8
	mov dl, 0
innerloop:
	push bx
	call move
	jnz nocount
	inc dx					; increments # of valid moves from next location
	
nocount:
	pop bx
	loop innerloop
	
	pop cx
	
	cmp dh, dl				; do we have a new "lowest possible moves" ?
	jle trynext
	mov dh, dl
	xchg ax, bx				; the next position is saved in ax
	
trynext:
	pop bx
	loop moveloop
	
	
	cmp dh, 8				; if we don't find a new "best move" we're done
	jne mainloop
	
	mov ax, 0924h
	stosb
	mov dx, boardoffset+0ffh
	int 21h
	
exit:
	ret

; move
; input :
; cx=offset of move
; bx = index of from position
; output :
; if ZF = 0 the move is either not valid or the new position is already occupied
; bx = new position

move:
	mov si, cx
	add bl, byte ptr [moves+si-1]
	test bl, 10001000b
	jnz endmove
	cmp byte ptr [boardoffset+bx],ch
endmove:
	ret


; the moves
moves db -14,33,-31,31,-33,14,-18,18


; the data below is left for illustrative purposes

; 0- 7   : 00000xxx
; 8-15   : 00001xxx
;16-23   : 00010xxx
;24-31   : 00011xxx
;32-39   : 00100xxx
;40-47   : 00101xxx
;48-55   : 00110xxx
;56-63   : 00111xxx
;64-71   : 01000xxx
;72-79   : 01001xxx
;80-87   : 01010xxx
;88-95   : 01011xxx
;96-103  : 01100xxx
;104-111 : 01101xxx
;112-119 : 01110xxx
;120-127 : 01111xxx

;  0  1  2  3  4  5  6  7
; 16 17 18 19 20 21 22 23
; 32 33 34 35 36 37 38 39
; 48 49 50 51 52 53 54 55
; 64 65 66 67 68 69 70 71
; 80 81 82 83 84 85 86 87
; 96 97 98 99 100 101 102 103
;112 113 114 115 116 117 118 119

;moves	db 2,1,-2,-1,-2,1,-1,-2,-1,2,1,-2,1,2,2,-1
; 2,1   = +2+16 (+18)
; -2,-1 = -2-16 (-18)
; -2,1  = -2+16 (+14)
; -1,-2 = -1-32 (-33)
; -1,2  = -1+32 (+31)
; 1,-2  = +1-32 (-31)
; 1,2   = +1+32 (+33)
; 2,-1  = +2-16 (-14)

end start
