;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; HC#23 entry by gbm <gbm@ii.pw.edu.pl>, version 1, 59 bytes
;
; compile:
;	nasm -o entry.com entry.asm
;____________________________________________________________________

;EAX = xxxx****, AL/AH = 00 if 1st/2nd FCB drive letter valid, FF if not
;EBX = xxxx0000
;ECX = xxxx00FF
;EDX = xxxxxxxx, DX = CS = DS = ES = SS = xxxx, 0080 <= DX <=9000.
;ESI = xxxx0100
;EDI = xxxxFFFE
;EBP = xxxx09xx
;ESP = xxxxFFFE
;EIP = xxxx0100

	section	.text
	
	org	100h
	mov	bh, 88h	; table start
	mov	di, bx	; 2nd byte gives DF = -32-1
	push	cs	; 0E = 16-2
	pop	ds	; 1F = 32-1
	and si, bp	; 21 EE
	db	12h, 0e1h	;adc	ah, cl
	db	0f2h	; repne
	stosb	; zero 255 bytes
	mov	cl, 64	; nsteps
	
move:
	mov	si, 103h	; delta
	add	bl, al
	xor	[bx], bh	; test and set
	jz	move8	; bad, field in use
	test	bl, bh
	jz	move5	; ok
	; bad, out of range
move8:	
	xor	[bx], bh	; reset
	popa
;	cmp	al, 0f2h ;1+32
;	je	move8
move5:
	lodsb
	cmp	al, 0aah
	je	move8
	pusha
	loop	move
	
move65:	
	popa
	; print
	xchg	ax, bx
	aam	16
	push	ax
	mov	dl, ah
	mov	ah, 2
	int	21h
	pop	dx
	int	21h
	add	cl, cl
	jns	move65
	ret
