comment $

entry for Hugi compo 23 - The Knight's Tour
by Hannes Uppman / 2004



uppdate 1; removed more possible moves, added comments



this program requires no extended ascii chars to be on command line (uses
bit 7 in each byte to set taken/not-taken states)

tour starts at square 0,0. note that this square never gets marked as taken.
this doesnt matter much because; from 0,0 one can only move in 2 directions,
one of these are already taken (first move), which means, if 0,0 is to be
used it will have to be the end of the tour. this wont be the case, first
solution is a valid tour.

the program also makes use of the fun fact that it is possible to compleate a
full tour without using 3 of a "real knight's" possible moves.

tour produced is

    0  1  2  3  4  5  6  7
  +--+--+--+--+--+--+--+--+
0 |64|61|58|55|52|49|46|43|
  +--+--+--+--+--+--+--+--+
1 |57|54|63|60|45|42|51|48|
  +--+--+--+--+--+--+--+--+
2 |62|59|56|53|50|47|44|41|
  +--+--+--+--+--+--+--+--+
3 |27|22| 7|32|37|40|17|12|
  +--+--+--+--+--+--+--+--+
4 | 6|31|26|21|16|11|36|39|
  +--+--+--+--+--+--+--+--+
5 |23|28| 3| 8|33|38|13|18|
  +--+--+--+--+--+--+--+--+
6 | 2| 5|30|25|20|15|10|35|
  +--+--+--+--+--+--+--+--+
7 |29|24| 1| 4| 9|34|19|14|
  +--+--+--+--+--+--+--+--+

$


.model tiny
.286
.code
org 100h

by equ <byte ptr>


hugi23:	mov	bp,5
	sub	al,4
	jz	@@4

@@1:	pusha

	add	bl,by [si+bp+@@6-hugi23-1]				
	test	bl,088h
	jnz	@@3

	xor	by [si+bx-80h],cl	;visited? - invert state
	jns	@@2

	call	si

@@2:	not	by [si+bx-80h]		;reset
@@3:	popa

	dec	bp
	ja	@@1			;if zf=0 and cf=0
	jnc	@@5

@@4:	mov	ax,bx			;so easy poluting bx :-(
	aam	10h
	xchg	ax,dx
	mov	ah,6
	int	21h
	mov	dl,dh
	int	21h
	stc
@@5:	ret

@@6:	db	1+32			;moves
			;db	-1+32
	db	2+16
	db	-2+16
			;db	2-16
			;db	-2-16
	db	1-32
	db	-1-32

end hugi23