; Hugi Compo 23 "Knight's Tour" entry by Jomppa
;
; Use NASM with '-O3' option to compile (too lazy to stick 'short' to jmp's =)
; Compiled size 58 bytes

BITS 16
ORG 0x100

; Assumes: AL = 00, BL = 00, CX = 00FF
start:
	MOV		BH, 0x2
	MOV		DI, BX
	REP STOSB
	MOV		DX, DI

; Move Knight
; BL = current position (bits 0..2 = X, bits 4..6 = Y)
; BX points to "Chess board" position X, Y
; AL = move X (bits 0..3) and Y (bits 4..7), signed
; CL = move number
; DI points to end of move list
move:
	PUSHA

	ADD		AL, BL
	TEST		AL, 0x88
	JNZ		.end2

	MOV		BL, AL
	DEC	BYTE	[BX]
	JPO		.end

; Store move to the list
	AAM		16
	STOSW

	MOV		SI, mlist
.l:	LODSB
	JMP		move
.boo:	CMP		AL, 0xF2
	JNZ		.l

.end:	INC	BYTE	[BX]
.end2:	XCHG		AX, DI
	CMP		AL, 0x7F
	POPA
	JNZ		.boo

; Put '$' to end of the move list and print it
; DX points to beginning of the list
; DI points to beginning of it...
end:	MOV		AX, 0x924
	STOSB
	INT		0x21
	INT		0x20		; Stack is borked, can't RET :(

; List of moves; X = bits 0..3, Y = bits 4..7 (both are signed)
; NOTE: If X is negative then Y must be one smaller than it really is
mlist:	DB	0x12, 0x21, 0x1F, 0x0E, 0xEE, 0xDF, 0xE1, 0xF2
