; Hugi size coding compo entry
; author: Boris Podybaylo aka wrestler 
; country: Ukraine
; version 1.1 (124bytes)
; compilation: 
; tasm /m entry
; tlink /t entry
.586
cseg segment dword public use16 
assume cs:cseg, ds:cseg, es:cseg, ss:cseg
org 100h
start:
        xor ax,ax
        mov dx,1
next_step:
        xor bx,bx
next_iter:
	cmp bl,16
	jz discard_step
        add al,steps[bx]
        add ah,steps[bx+1]
	test ax,1111100011111000b
        jz bounds_ok
next:
        sub al,steps[bx]
        sub ah,steps[bx+1]
        add bl,2
        jmp next_iter                
bounds_ok:
 	mov cx,dx
 	lea di,default
 	repne scasw
        jz next                      
;here we'll be if bounds ok and board[x][y] free
	mov di,dx
	mov byte ptr way[di],bl        
	shl di,1
	mov word ptr default[di],ax
	inc dx
	cmp dx,64    
	jz prn_result   
	jmp next_step   
discard_step:
	dec dx                       
	mov di,dx
	shl di,1
	mov ax,word ptr default[di-2]
	shr di,1
	mov bl,byte ptr way[di]      
	add bl,2                      
	jmp next_iter                 
prn_result:
	mov byte ptr way,'$'
	mov word ptr default,0
	mov ah,09h
	lea dx,default
	int 21h                            
	 ret
steps db  -2,-1,-2,1,-1,-2,-1,2,1,-2,1,2,2,-1,2,1
default equ $
way equ default+128
board equ way+64
	db 0,0
cseg ends
end start                  
