; 323 bytes Entry for the Hugi Size Coding Compo #24
; A Turtle Drawing Machine
;
; Compile with fasm v1.56+
;
; Version history:
;   340 - 14.Aug.2005 by ATV, Finland   email: askovuori[at]hotmail.com
;   335 - 20.Sep.2005 by ATV
;   327 - 26.Sep.2005 by ATV
;   323 - 02.Oct.2005 by ATV

use16
org 100h				;assume: cld,ax=0,ds=es=cs

main:
	mov	ch,0FBh 		;fill restore buffer with 0
	mov	di,keyBuf+1		;and keyBuf too
	;xor     ax,ax
	rep	stosb
	xor	bp,bp			;pen_x
	db	0BAh			;mov dx,1F0Eh
bigLoop:
	push	cs
	pop	ds
	pusha				;ax<200
	mov	al,3			;enter textmode
	int	10h

	;get drawing commands
	mov	ah,0Ah			;get file name from console
	mov	dx,keyBuf
	int	21h

	inc	dx
	inc	dx
	mov	bx,dx			;bx=0244h
	add	bl,[bx-1]		;max. BBh chars buffer
	mov	ax,3D00h		;open file
	mov	[bx],al 		;Z-terminate string

	int	21h
	jc	restore_regs		;if error, exit program

	mov	[fileHandle],ax

	mov	ax,0013h		;enter gfx mode 13h
	int	10h

	push	0A000h			;restore saved screendump
	pop	es
	mov	si,screenBuf
	xor	di,di
	mov	ch,0FAh
	rep	movsb
	popa
	xchg	ax,si			;pen_y
execute:
	mov	bx,readByte
	call	bx
	xchg	di,ax			;entries in cmdRoutineTable is 1 byte
	mov	ah,01h			;all jmps are in 01??h
	js	fileEnd

	mov	al,[bx+di+cmdRoutineTable-readByte]
	mov	dl,[bx+di+moveTable-readByte-1]
	mov	[bx+moveLoop-readByte],dl
	call	ax			;call command service routine
	jmp	execute

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveCoord:
	call	readWord
	xchg	bp,ax			;pen_x
	call	readFile
	xchg	si,ax			;pen_y
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fileEnd:
	;mov     ah,3Eh                  ;close file
	call	useFile

	push	es			;save screendump
	pop	ds
	push	cs
	pop	es
	xchg	ax,si
	xor	si,si
	mov	di,screenBuf
	mov	ch,0FAh
	rep	movsb
	jmp	bigLoop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
cmdpause = $-1
	;cbw
	int	16h
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
penOn:
	cbw
penOff: 				;dh=0 pen is on
	xchg	ax,dx			;dh=1 pen is off
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
readWord:
	inc	cx
readFile:
	mov	ah,0
useFile:
	pusha
	xor	ah,3Fh
	mov	bx,0
fileHandle	= $-2
	mov	dx,sp

	add	dx,0Eh
	int	21h
	dec	ax			;if EOF then set SF
restore_regs:
	popa
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; this function is highly recursive and requires a lot of stack, worst
; case senario is that the levels of recursion equals the number of
; pixels available; a little less then 64k. Hence one can only afford
; one byte to be pushed on the stack per level of recusrion. A special
; "custom stack" is used for this.
fill:
	call	getVideoAddress 	;get di=y*320+x

	call	bx			;readByte al=fcolor_use
	mov	ah,[es:di]		;ah=fcolor_target

	mov	bx,fillBuf
filler:
	inc	bx
	pusha
	call	clip			;on screen?
	pop	ax
	push	di			;save di=y*320+x over popa
	popa
	js	fillBack

	cmp	ah,[es:di]		;dont plot if color on pixel isnt
	jnz	fillBack		;target color
	stosb
; fill with: x=0 , y=-1 => x=+1 , y=0 => x=0 , y=+1 => x=-1 , y=0
	mov	word [bx],((next_move-2) and 255) + 4D00h
add2 = $-1
	dec	si
	add	byte [bx],2
	jmp	filler
moveTable	db 4Eh,46h		;dec si , inc si
		db 4Dh;,45h              ;dec bp , inc bp
next_move:
	inc	bp
	inc	bp
	inc	si
	inc	si
	jmp	add2
	inc	bp			;back to were we started
fillBack:
	mov	[bx],cl 		;all jmps are in 01??h
	dec	bx
	jmp	word [bx]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
readByte:
	xor	cx,cx
	call	readWord
cmdnop = $-2				;01C3-hidden mov bl,ff
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
cmdRoutineTable = $-1
	;db  cmdnop and 255              ;C3h
	db  moveY and 255
	db  moveY and 255
	db  moveX and 255
	db  moveX and 255
	db  moveCoord and 255
	db  penOn and 255
	db  penOff and 255
	db  changeColor and 255
	db  cmdpause and 255

changeColor:
	call	bx			;readByte
	mov	[pen_color],al		;set pen_color
	ret

	db  midpointCircle and 255
	db  fill and 255

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveX:
	mov	bl,(readWord and 255)
moveY:
	call	bx			;readByte
	xchg	ax,cx
	inc	cx
	db	3Ch			;dummy cmp,al
moveLoop:
	inc	bp			;self modify code: inc/dec bp/si
	call	plot
	loop	moveLoop
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; traditional midpoint line circle algorithm
midpointCircle:
	xor	di,di
	call	bx			;Y = radius
	sub	cx,ax			;d = 1-radius
; use symmetry in order to print a circle
; +y,+x => +y,-x => -y,+x => -y,-x
; +x,+y => +x,-y => -x,+y => -x,-y
circle_loop:
	pusha
	add	bp,di			;pen_x+X
	add	si,ax			;pen_y+Y
	mov	dh,00h			;set pen on
	call	plot
	popa
	neg	ax			;Y
	js	circle_loop
	neg	di			;X
	js	circle_loop

	xchg	ax,di
	neg	bx
	js	circle_loop

	cmp	ax,di			;Y,X
	jle	lastRet;cmdnop

	test	cx,cx
	js	circle_x
	dec	ax
	sub	cx,ax
	sub	cx,ax
	jg	circle_loop
circle_x:
	inc	di
	add	cx,di
	add	cx,di
	inc	cx
	jmp	circle_loop		;EBh,D1h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; plots pixel at pen_x, pen_y
; if pen_x, pen_y isnt whithin the screen, then they are clipped
; a pixel is plotted only if no clipping has occured
plot:
	call	clip			;is pen_on and on screen?
	jne	lastRet 		;dont plot
	mov	al,0
pen_color	= $-1
	stosb

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; returns clipped pen_x in bp, and clipped pen_y in si,
; SF is set if clipping has occured, ZF is set if pixel can be drawn
clip:
	xor	dl,dl
	mov	ax,319
	call	testbound
	mov	ax,199

; variable to test in si, maxlimit in ax, negative dl if clipping is made
testbound:
	xchg	si,bp			;first test x in bp then y in si
	cmp	si,ax
	jbe	getVideoAddress
	mov	dl,80h
	xchg	si,ax
	jns	getVideoAddress
	xor	si,si
getVideoAddress:
	imul	di,si,320		;di = y*320+x
	add	di,bp
	or	dl,dh
lastRet:
fillBuf:
	ret				;(cmdnop and 255)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
keyBuf		= $-1			;=C3h used as keyboard buffer size
screenBuf	= keyBuf+256
