comment $

example for Hugi compo 24 - The Tortoise and the Hare
by Hannes Uppman
642 bytes modification by wrestler(boris_p@mail.ru)

$ 


.model tiny
.486
.code
org 100h

LOCALS

by equ <byte ptr>
wo equ <word ptr>
do equ <dword ptr>
off equ <offset>

hugi24example:

main PROC
        mov     si,off buf      ;fill restore buffer with 0;               
        mov     by [si],0                                                 
        lea     di,[si+1]                                                 
        call    copy                                                     
bigLoop:
        mov     ax,03h            ;enter textmode                           
        int     10h                                                       

        mov     ah,0Ah          ;get file name from console
        mov     dx,off keyBuf
        int     21h
	inc     dx
        mov     bx,dx             
        movzx   di,by [bx]
        mov     by [bx+di+1],0
        inc     dx
        mov     ax,3D00h        ;open file
        int     21h
        jnc     @@1            ;if error, exit program
        int     20h
@@1:
        mov     [fileHandle],ax
        mov     al,13h          ;enter gfx mode 13h                       
        int     10h                                                       

        push    0A000h          ;restore saved screendump                 
        pop     es                                                        
        mov     si,off buf                                                
        xor     di,di                                                     
        call    copy                                                      
execute:
        call    readByte                                                  
        jcxz    @@2                                                       
        shl     al,1           ;entries in cmdRoutineTable is 2 bytes    
	xchg    ax,bx
        call    wo [bx+cmdRoutineTable]
	jmp execute
@@2:                                                                       
        mov     ah,3Eh          ;close file                               
        mov     bx,[fileHandle]                                           
        int     21h                                                       

        push    0A000h          ;save screendump                          
        pop     ds                                                        
        push    cs                                                        
        pop     es                                                        
        xor     si,si                                                     
        mov     di,off buf                                                
        call    copy                                                      
        push    cs                                                        
        pop     ds                                                        
        jmp     bigLoop                                                   
ENDP
copy PROC 
        xor     bx,bx
@@1:    push    wo [si+bx]
        pop     wo es:[di+bx]
        inc     bx
        cmp     bx,320*200
        jne     @@1
        ret
ENDP
readByte PROC
        mov     bx,[fileHandle]
        mov     cx,1
        mov     ah,3Fh
        mov     dx,off buf
        int     21h
        xchg    ax,cx
        mov     al,by [buf]
        ret      
ENDP
plot PROC
        pusha
        call    clip
        mov     [pen.x],cx
        mov     [pen.y],ax
        test    dl,dl
        jnz     @@1             ;dont plot
        cmp     [pen.on],0
        je      @@1             ;dont plot
        call    getVideoAddress
        mov     al,[pen.color]
        stosb
@@1:    popa
        ret
ENDP
clip PROC
        xor     dl,dl
        mov     ax,[pen.x]
        mov     bp,319
        call    bound
        xchg    ax,cx
        mov     ax,[pen.y]
        mov     bp,199
        call    bound
        ret
ENDP
bound PROC      
        cmp     ax,0
        jge     @@1
        xor     ax,ax
        inc     dl
@@1:    cmp     ax,bp
        jle     @@2
        mov     ax,bp
        inc     dl
@@2:    ret
ENDP
getVideoAddress PROC
        imul    di,[pen.y],320
        add     di,[pen.x]
        ret
endp
nop proc
 ret
endp
moveUp PROC
        call    plot
        call    readByte
        xchg    ax,cx ;ax
        jcxz    @@2
@@1:    dec     [pen.y]
        call    plot
        loop    @@1
@@2:    ret
ENDP
moveDown PROC
        call    plot
        call    readByte
        xchg    ax,cx    ;ax
        jcxz    @@2
@@1:    inc     [pen.y]
        call    plot
        loop    @@1
@@2:    ret
ENDP
moveLeft PROC
        call    plot
        call    readByte
        push    ax;ax
        call    readByte
        pop     cx
        mov     ch,al;al
        jcxz    @@2
@@1:    dec     [pen.x]
        call    plot
        loop    @@1
@@2:    ret
ENDP
moveRight PROC
        call    plot
        call    readByte
        push    ax ;ax
        call    readByte
        pop     cx
        mov     ch,al ;al
        jcxz    @@2
@@1:    inc     [pen.x]
        call    plot
        loop    @@1
@@2:    ret 
ENDP
moveCoord PROC
        call    readByte
        mov     by [pen.x],al
        call    readByte
        mov     by [pen.x+1],al
        call    readByte
        mov     by [pen.y],al
        call    readByte
        mov     by [pen.y+1],al
        ret                   
ENDP

penOn PROC
        mov [pen.on],-1
	ret
ENDP
penOff PROC
        inc  [pen.on]
        ret
ENDP
changeColor PROC
        call    readByte
        mov     [pen.color],al ;al
        ret
ENDP
pause proc
	xor ax,ax
	int 16h
	ret
endp
midpointCircle PROC
XX       equ <bx>
YY       equ <ax>
radius  equ <ax>
deltaE  equ <bp>
deltaSE equ <cx>
D       equ <dx>

        mov     [pen.on],-1     ;pen on/off state
        call    readByte        ;YY = radius
        xor     XX,XX
        mov     D,1
        sub     D,radius
        mov     deltaE,3
        mov     deltaSE,5
        sub     deltaSE,radius
        sub     deltaSE,radius  ;D = 1-radius, deltaE = 3
                                ;deltaSE = 5 - 2*radius
        call    circlePlot
@@1:    cmp     YY,XX
        jbe     @@3
        test    D,D
        jns     southEast
east:
        add     D,deltaE
        add     deltaE,2
        add     deltaSE,2
        jmp     @@2
southEast:
        add     D,deltaSE
        add     deltaE,2
        add     deltaSE,4
        dec     YY
        
@@2:    inc     XX
        call    circlePlot
        jmp     @@1
@@3:    inc     [pen.on]
        ret
ENDP
circlePlot PROC
        pusha
        call    circlePlot2     ;x,y
        neg     YY
        call    circlePlot2     ;x,-y
        neg     XX
        call    circlePlot2     ;-x,-y
        neg     YY
        call    circlePlot2     ;-x,y
        xchg    YY,XX
        call    circlePlot2     ;y,-x
        neg     YY
        call    circlePlot2     ;y,x
        neg     XX
        call    circlePlot2     ;-y,x
        neg     YY
        call    circlePlot2     ;-y,-x
        popa
        ret
ENDP
circlePlot2 PROC
        pusha
        xchg    [pen.x],XX
        add     [pen.x],XX
        xchg    [pen.y],YY
        add     [pen.y],YY
        call    plot
        mov     [pen.x],XX
        mov     [pen.y],YY
        popa
        ret
ENDP
fill PROC   
        call    readByte
        mov     [fcolor.use],al

        call    getVideoAddress
        mov     al,by es:[di]
        mov     [fcolor.target],al

        mov     bx,off buf
        mov     by [bx],off @@1 - off fill  ;call    filler
        jmp     filler
@@1:    ret
ENDP
filler PROC 
        inc     bx

        call    clip            ;on screen?
        test    dl,dl
        jnz     @@2
        
        call    getVideoAddress
        mov     al,by es:[di]
        cmp     al,[fcolor.target]
        jnz     @@2             ;dont plot if color on pixel isnt
                                ;target color
        cmpxchg [fcolor.use],al
        jz      @@2             ;dont plot if target color and the
        stosb                   ;color in use (the color of the pixel
                                ;to be plotted) is equal
fillWest:
        dec     [pen.x]
        mov     by [bx],off fillEast - off fill     ;call    filler
        jmp     filler
fillEast:                                               
        add     [pen.x],2
        mov     by [bx],off fillNorth - off fill    ;call    filler
        jmp     filler
fillNorth:
        dec     [pen.x]
        dec     [pen.y]
        mov     by [bx],off fillSouth - off fill    ;call    filler
        jmp     filler
fillSouth:
        add     [pen.y],2
        mov     by [bx],off @@1 - off fill          ;call    filler
        jmp     filler        
@@1:
        dec     [pen.y]         ;back to were we started       
@@2:    dec     bx              ;ret
        movsx   ax,by [bx]
        add     ax,off fill
        jmp     ax
ENDP
cmdRoutineTable:
    dw off nop
    dw off moveUp
    dw off moveDown
    dw off moveLeft
    dw off moveRight
    dw off moveCoord
    dw off penOn      ; mov [pen.on],1
    dw off penOff     ; mov [pen.on],-1
    dw off changeColor
    dw off pause
    dw ?
    dw ?
    dw ?	 
    dw  ?
    dw  ?
    dw  ?
    dw off midpointCircle
    dw off fill

_pen STRUC
        x       dw 0
        y       dw 0
        on      db 0
        color   db 0
_pen ENDS
pen             _pen <>

keyBuf          db 20,0,20 dup(?)
 
_fillColor STRUC
        target  db ?
        use     db ?
_fillColor ENDS
fcolor          _fillColor ?

fileHandle      dw ?
buf:
end hugi24example