; Sudoku Puzzle Solver for Hugi Compo 25
; Usage: entry <1.puz
; Compile with fasm v1.56+
; Version history:
;   121 - 9.Jan.2006 by ATV, Finland   email: askovuori[at]hotmail.com

	use16
	org	100h		;this is a COM program so skip its PSP

;Load Puzzle from stdin

main:	mov	cl,81		;for I:= 80, 0 do...
main10: mov	ah,08h		;read digit from stdin
	int	21h
	;cmp     al,'9'
	;ja      main10
	cmp	al,'.'		;convert '.' to 0
	jb	main10		;skip space characters, cr's and lf's
	dec	si
	mov	[si],al 	;store digit into puzzle array
	loop	main10		;loop until puzzle array is filled

;-----------------------------------------------------------------------------
;Solve the puzzle using backtracking (recursive tree search)

solve:
	mov	dl,'0'		;try all 9 digits...; for Digit:= 1, 9 do...
	cmp	[bx+si],dl	;is cell empty?; if Puzzle(I) = 0 then...
	ja	solve10 	;Solve(I+1)
	db	0B0h		;dummy: mov al,

undo:
	popa			;restore index (I) and Digit
	mov	[bx+si],cl	;undo trial entry; Puzzle(I):= 0

okay_used:
	inc	dx		;next digit
	cmp	dl,'9'		;loop for digits 1..9
	ja	undo

;Check if a row or column already contains the digit:

okay:	mov	ax,bx		;get index (I) into puzzle array
	mov	cl,9
	aam	9		;al:= rem(I/9)
	cbw
	lea	di,[bx+si]
	sub	di,ax		;di:= I/9*9+si
okay10: mov	bp,ax		;index at top of column
	cmp	[di],dl 	;check cell for digit
	je	okay_used
	cmp	[bp+si],dl	;check cell for digit
	je	okay_used
	inc	di		;next cell across
	add	al,09h		;next cell down
	loop	okay10		;loop for 9 cells

;Check if a 3x3 region already contains the digit:
;Find coordinates (X0,Y0) of upper-left cell in the 3x3 region


okay30: pusha

	aam	3		;ah:= X0/3
	mov	al,100h-81-81
	aad	3		;al:= X0/3*3+si
	xchg	ax,bx
	aam	27		;ah:= I/27
	mov	al,bl
	aad	27		;al:= I/27*27+X0/3*3+si

	xchg	di,ax		;di:= index of upper-left cell in region
	xchg	ax,dx
	mov	cl,3
	repne	scasb		;if Puzzle(di..+2) = Digit then return false
	popa
	je	okay_used
	add	ax,7009h	;next row down
	jnc	okay30		;loop for 3 rows

	mov	[bx+si],dl	;make trial entry with digit; Puzzle(I):= Digit
	pusha			;save index (I) and Digit
;        jmp     solve10         ;pursue solution from here (recurse)

solve10:
	inc	bx
	cmp	[bx+si],bh	;if I = 81 then
	jge	solve		; show solution
	dec	bx
;-----------------------------------------------------------------------------
;Output the solution

show:
	mov	cl,9
show10:
	mov	dl,[bx+si]	; ChOut(0, Puz(I)+^0);
	mov	ah,02h		; send it to stdout
	int	21h
	mov	dl,' '		; output separating space character
	loop	show20		; (jump if rem(I/9) <> 0)
	mov	cl,9
	mov	dl,0Dh		; output new line; CrLf(0)
	int	21h
	mov	dl,0Ah
show20:
	int	21h
	dec	bx		;for I:= 80, 0 do...
	jns	show10		;loop for all cells in the puzzle
	int	20h		;exit program
