	page	240, 132
;ENTRY.ASM	31-Jan-2006	Boreal		loren_blaney@idcomm.com
;Sudoku Puzzle Solver for Hugi Compo 25
;Usage: entry <1.puz [>1.sol]
;Assemble with:
; tasm /m entry
; tlink /t entry

	.model tiny
	.code
	.486
	org	100h		;this is a COM program so skip its PSP
start:
;	mov	ax, 0		;for Turbo Debugger
;	mov	di, -2
;	mov	bp, 0913h

;Load Puzzle from stdin
;(ax=0, di=-2 bp=09xx)
	xchg	ax, di		;di:= 0; ax:= -2
	cwd			;dl:= FFh (request input from console)
	mov	ax, 0647h	;function 6 = direct console I/O
start10 equ	$-2		;47h = inc di; 06h = push es (stack doesnt matter)
	int	21h		;get character from stdin
	mov	[di+bp], al	;store it into array at bp and indexed by di
	jne	start10		;loop until no more input characters

	mov	dl, '$'		;set up to terminate string for output
;(di=19*9)

;Solve the puzzle using backtracking (recursive tree search)
solve:	pusha			;save index (di) and digit (dl)

	mov	[bp+di], dl	;make trial entry with digit (or store $)
	mov	dx, '.0'	;for digit:= 1, 9 do...

solve05:dec	di		;scan for next empty cell
	js	show		;jump if done
	cmp	byte ptr [bp+di], dh	;is cell at di empty (='.')?
	jne	solve05		;loop if not

	db	3Ch		;skip a byte (cmp al, imm)
solve10:popa			;restore di and dl at previous empty cell
	mov	byte ptr [bp+di], dh	;undo trial entry by storing '.'
solve12:inc	dx		;next digit
	cmp	dl, '9'		;loop for digits 1..9
	ja	solve10		;if digit > '9' then loop (backtrack)

;Check if digit in dl is a legal entry at location in di

	mov	si, 9*19-1	;loop for all locations (cells and spaces, etc.)
ok10:	cmp	[bp+si], dl	;does cell's contents = pending entry?
	jne	ok50		;skip if not

	mov	ax, di		;split index into row & column and save it in bx
	aam	19		;ah:=al/19; al:=remainder
	xchg	bx, ax		;bl=column; bh=row

	mov	ax, si		;split the test location into its row & column
	aam	19		;is the test location...
	cmp	ah, bh		; in the same row as index location?
	je	solve12		; jump if so--reject
	cmp	al, bl		; in the same column as index location?
	je	solve12		; jump if so--reject

;Deal with 3x3 boxes
	imul	bx, 11		;multiply index's row & column by "magic number"
	imul	ax, 11		;do same with test row & column
	xor	ax, bx		;compare resulting bits
	and	ax, 60C0h	;apply "magic mask"
	je	solve12		;reject if digit is already used in the 3x3 box
ok50:
	dec	si		;next location
	jns	ok10		;loop for all locations

	jmp	solve		;continue solving puzzle from this index point

;Output the solution
;(bp=09xx)
show:	xchg	ax, bp		;ah:=09h = output string function
	mov	dx, ax		;dx:= string address
	int	21h

	int	20h		;exit program

;Magic number and magic mask:
;Row	*11d	&60h
;
;0	00h	00h
;1	0B	00
;2	16	00
;
;3	21	20
;4	2C	20
;5	37	20
;
;6	42	40
;7	4D	40
;8	58	40

	end	start
