;===============================================;
;           ****  Hugi Compo 25  ****           ;
;            Sudoku Solver - 69 bytes           ;
;-----------------------------------------------;
;              TFx / Spinning Kids              ;
;          tfx (at) bitmaster (dot) it          ;
;===============================================;
; Compile:                                      
;       tasm -m2 entry.asm
;       tlink -t entry

	model tiny
	codeseg
	startupcode
	.486
InOut:
	mov	ah, 6		;ah = 6 -> input/output
	mov	di, bp		;bp = buffer
	push	cx
Char:	
	stosb			;save - avoid 0 position so we can multiply by negative number later
	pop	dx		;dx = ff/00
	push	dx
	or	dl, [di]	;digit to output
	jz	Exit
	int	21h		;input/output digit
	loop	Char		;no more chars?
Solve:
	mov	[bp+si], al	;digit is ok		
	mov	ax, 2e39h
Empty:
	dec	si		;find empty cell
	js	InOut		;if not found output solution 
	cmp	[bp+si], ah	;is empty?
	jne	Empty		;if empty check it else continue
ChkDgt:
	mov	di, dx
Next:
	dec	di		;find digit
	pusha
	js	Solve		;if no more digits set and recurse
	cmp	[bp+di], al	;else search
	jne	NOk
	xchg	ax, di		;get digit position
Split:
	aam	19		;split row and column
	imul	ax, -11		;find 3x3 group
	db	31h		;xor bx,ax - compare cell positions
Exit:	db	0c3h		;ret - called after output
	xchg	ax, si		;get empty cell position
	js	Split		;split empty cell position
	xchg	ax, bx		;get compared cell positions
	test	ax, 0e0c0h	;same 3x3 group?
	jle	NOk
	mul	ah 		;same column or same row?	
NOk:
	popa
	jnz	Next		;next position
	mov	[bp+si], ah	;empty cell	
	dec	ax		;next digit	
	cmp	al, 30h  	;no more digits?	
	je	NOk
	jmp	ChkDgt
	end