; Hugi Compo #26 - Golden Ratio
; Entry by Beeblebrox - 88 bytes
; tasm /m9 entry.asm
; tlink /t/x entry.obj
; Most of code is just slightly modified Pi calculator by INT-E

; How spigot algorithm works:
; Phi-0.5=1.11803...
;                 | k=0| k=1| k=2| k=3| k=4| k=5| k=6
;                 |    |1/10|3/20|5/30|7/40|9/50|11/60
;-----------------|----|----|----|----|----|----|-----
;a[k] (Init)      |   1|   1|   1|   1|   1|   1|   1
;*10              |  10|  10|  10|  10|  10|  10|  10
;Carry            |  +1|  +0|  +0|  +0|  +0|  +0|  +?
;             1 <-| =11| =10| =10| =10| =10| =10| =10
;a[k] (Rem.)      |   1|   0|  10|  10|  10|  10|  10
;*10              |  10|   0| 100| 100| 100| 100| 100
;Carry            |  +1| +15| +15| +14| +18| +11|  +?
;             1 <-| =11| =15|=115|=114|=118|=111|=100
;a[k] (Rem.)      |   1|   5|  15|  24|  38|  11|  40
;*10              |  10|  50| 150| 240| 380| 110| 400
;Carry            |  +8| +30| +50| +70| +27| +66|  +?
;             1 <-| =18| =80|=200|=310|=407|=176|=400
;a[k] (Rem.)      |   8|   0|   0|  10|   7|  26|  40
;*10              |  80|   0|   0| 100|  70| 260| 400
;Carry            |  +0|  +3| +20| +21| +54| +66|  +?
;             8 <-| =80|  =3| =20|=121|=124|=326|=400
;a[k] (Rem.)      |   0|   3|   0|   1|   4|  26|  40
;*10              |   0|  30|   0|  10|  40| 260| 400
;Carry            |  +3|  +0|  +0| +14| +54| +66|  +?
;             0 <-| =03| =30|  =0| =24| =94|=326|=400
;a[k] (Rem.)      |   3|   0|   0|  24|  14|  26|  40

.model tiny
.486
.code
        org     100h
start:
        db      36h,0Dh,0Ah,24h ;4; ss: or  ax,240Ah
        mov     di,bp           ;2;
        mov     ch,14h          ;2; init array: dw 14FFh dup(240Ah)
        rep     stosw           ;2;
phi10:  mov     ch,10h          ;2; array size is 1000h words
        mov     di,cx           ;2; array starts from address 1000h
phi20:  imul    bp,cx,10        ;3; den = 10 * k
        div     bp              ;2; Carry = Sum / den
        xchg    ax,dx           ;1;
        stosw                   ;1; a[k] = Sum % den
        xchg    ax,dx           ;1;
        imul    bp,cx,2         ;3;
        dec     bp              ;1; num = 2 * k - 1
        mul     bp              ;2; Carry *= num
        push    dx              ;1;
        xchg    ax,bp           ;1;
        mov     ax,10           ;3;
        mul     word ptr [di]   ;2; Sum = 10 * a[k-1] + Carry
        add     ax,bp           ;2;
        pop     bp              ;1;
        adc     dx,bp           ;2;
        loop    phi20           ;2;
        div     word ptr [si+2] ;2; div by 240Ah
        add     al,'0'          ;2; digit to be printed now
        mov     [bx+si+offset number-offset start],al ;
	xchg	ax,dx		;1; put remainder in ax and digit in dx
        stosw                   ;1; a[0]=remainder
        inc     bx              ;1;
        jns     phi10           ;2;
        mov     dx,offset temp  ;3;
        mov     ax,0936h        ;3;
        mov     byte ptr number,al      ;3;
        mov     di,offset number+2400-1 ;3;
        movsd                   ;2;
	int	21h             ;2;
        retn                    ;1;
temp    db      '1.'            ;2;
number:
	end	start
