; Entry for Hugi Compo 26 - Golden Ratio by Digimind <digimind@aha.ru>
; Version 0.4    61 magic bytes    8 Jun 2006
; Compiled with "tasm /m9"


;#include <stdio.h>
;#include <io.h>
;#include <fcntl.h>
;int main()
;{
;    _setmode(_fileno(stdout), _O_BINARY);    // prevent translation of <lf> sequences to <cr><lf>
;    int f[3437];
;    for(int i = 0; i < 3437; i++) f[i] = 100, f[0] = 3050;
;
;    for(int n = 2402, d = 0; d != 0x37; d += 0x37) {
;        d++;
;        do {
;            putchar(d ^= 0x0230);
;            d = 0x026a;
;            for(int k = 3436; k >= 0; k--) {
;                d = d * (2 * k + 1) + f[k] * 10;
;                int b = k ? k * 10 : 1000;
;                f[k] = d % b;
;                d /= b;
;            }
;        } while(--n > 0);
;    }
;    return 0;
;}


model tiny                            ; using standard assumptions:
.586                                  ;
codeseg                               ; ax = 0, cx = 0ffh, si = 100h, sp = 0fffeh
startupcode                           ;


fill:   push 100                      ; create local array of words and initialize them with 100
        inc si                        ; leave almost 200 bytes of stack space for interrupts
        jns fill                      ; (seems like interrupts don't need more than 30 bytes anyway)
                                      ; note: using bp instead of si would leave much more
                                      ; stack space, but this will cost 1 byte

    mov word ptr [si], 3050           ; set first element of array to produce ".6"

    mov bx, 2402                      ; initialize symbol count without <cr><lf>

crlf:   inc ax                        ; produce '1' on the first pass

print:      xor ax, 0230h             ; convert digit to symbol and use DOS Fn 02h: Display Char
                                      ; get a rounding as a free bonus :)
            mov dl, al
            int 21h

            moV al, 6ah               ; fine-tune so last 2 digits differ by 3 just like <cr><lf>

            mov bp, 3437 * 2 - 1      ; initialize numerator
            mov di, 3437 * 10         ; initialize denominator

calc:           imul bp
                dec bp                ; convert numerator to array index

                mov cl, 10

addsub:             add ax, [si + bp] ; add low words of 32-bit values
                    adc dl, ch        ; add high words of 32-bit values
                    dec di            ; update denominator
                    loop addsub       ; add / decrement 10 times instead of multiplying by 10

                jnz divide            ; if denominator reaches 0 ...
                mov di, 1000          ; ... set it to 1000

divide:         div di
                mov [si + bp], dx     ; store remainder in array

                dec bp                ; update numerator / array index
                jns calc

            dec bx                    ; update symbol count
            jg print                  ; loop 2402 times

        add al, 37h                   ; adjust last 2 digits to produce <cr><lf>
        jp crlf                       ; loop 2 more times for <cr><lf>
    int 20h                           ; exit
end
