;----------------------------------------------------------
; TAD's entry into the Hugi size compo #26 ('phi')
;
;
;                       67 bytes
;
;
; credits:
;       many thanks to claw for the decimal hint!
;       I spent many late nights trying to do various other
;       methods including a 'rabbit sequence' algo which
;       output 1-digit per loop and was only 53 bytes long
;       sadly, it tooks more and more time per digit and
;       more memory :(
;
;       also I tried and re-tried many other binary-based
;       division algos - most worked out too slow or simply
;       too big to be useful including square-root algos.
;
;       Currently my browser favourites is filled with
;       phi, fibonacci, rabbits and other 'useful' pages
;
;       respect to Digimind and fabled for their compact
;       solutions! good to see chut making the news
;       and still entering compos
;
;       Greets to boreal (nice compo, great work!)
;                 sniper (tnx for the 5 extra days!! ;)
;
;       I wished I had more time to do a proper entry :(
;       many thanks to claw again to motivating me to
;       take part and for -boreal and all the organisers
;       for
;               putting the fun bits back into the bytes
;
;                                       TAD 2006
;
;       To Ruud for the spirit of the compo !
;
;----------------------------------------------------------

        .model tiny
        .code
        org 256
        .286
start:
;       ax = ----       si = ----
;       bx = 0000       di = fffe
;       cx = --ff       bp = ----
;       dx = ----       sp = fffe       df=1
;
; Clear memory and sneaky register setup + CF :)

        lahf                            ; ah = 2 (print function)
        mov     ch,12h                  ; cx = 12ff (digit loop counter)
moose:
        push    bx                      ; push 0000 (clear memory)
        scasw                           ; di+2
        cmp     sp, cx                  ; yes, safe pushy and it sets
        jnc     short moose             ; cf=1 for free :)

        mov     si, 8000h + 2400-1      ; uses 8000h as loop-counter

;        Calculate 2 BIG, BIG fibonacci numbers
;
;       ax = 0200       si = 895F
;       bx = 0000       di = ECFE
;       cx = 12FF       bp = ----
;       dx = ----       sp = 12FE       cf=1

fibs:
        xchg    si,di                   ; swap number pointers si <--> di
        call    adder                   ; add num1, num2 for next fibonacci
        jz      short fibs              ; continue until top digit <> 0 :)
;
;       BCD division thru repeated subtraction
;
;       ax = 0200       si = ECFE
;       bx = 0000       di = 895F
;       cx = 12FF       bp = ----
;       dx = ----       sp = 12FE
;
        mov     dh, '.'                 ; 2nd digit = '.'
digit:
        mov     dl, '0'-1               ; digit = '0' - 1
divide:
        inc     dx                      ; digit + 1
        pusha
subloop:
        mov     al, [di]                ; get digit
        sbb     al, [si]                ;
        aas                             ; fix decimal digit
        stosb                           ; store digit
        inc     si
        loop    subloop
        popa
        jnc     short divide            ; repeat subtraction until carry

;
;       Call the 'print_adder' routine to output(dx) or just (dl) chars
;       and correct number by undoing last subtraction.
;       the di register is decremented to multiply remainder by 10 (decimal)
;
damn6:
        call    print_adder             ; print chars(dx) + undo last sub
        dec     di                      ; multiple remainder by 10
        js      short digit             ; address also used as loop counter

        mov     dl, '6'                 ; damn that rounding rule!
        jo      short damn6             ; neat use of the 8000 --> 7FFFh
                                        ; boundary for last digit #:P)

        mov     dx,0A0Dh                ; print (0Dh) + (0Ah)
;
;       ax = ----       si = FIB1
;       bx = ----       di = FIB2
;       cx = 12FF       bp = ----
;       dx = YYXX       sp = ----       YYXX is 1 or 2 chars :)
;
;       perform long BCD addition on two 1-digit-per-byte numbers

print_adder:
        int     21h                     ; print char(dl)
        shr     dx, 8                   ; lose it, get next char(dl) if any
        jnz     short print_adder
adder:
        pusha
black:
        lodsb                           ; get digit
        adc     al,[di]                 ; add with carry
        aaa                             ; fix decimal digit
        stosb                           ; store it
        loop    black
        popa                            ; returns ZF=0 if last digit :)
        ret

        end     start