\ANSI2ASM.XPL	24-Sep-2008	Boreal		loren.blaney@idcomm.com
\Converts an ANSI image into assembly code
\This is used to make the "Image" data array for TESTER.ASM.
\Usage: ANSI2ASM filename.ans
\Outputs; IMAGE.ASM
\ANSI.SYS must be installed


include C:\CXPL\CODESI;		\include code definitions for intrinsic routines

def	Nul=$00, Bel=$07, BS=$08, Tab=$09, LF=$0A, FF=$0C,	\control chars
	CR=$0D, EOF=$1A, Esc=$1B, Sp=$20, Ctrl=$40;



proc	OpenInFile;		\Open file on command line for input
int	CpuReg, Hand;
char	CmdTail($80);
begin
CpuReg:= GetReg;
Blit(CpuReg(11), $81, CpuReg(12), CmdTail, $7F);       \get copy of command line
Hand:= FOpen(CmdTail, 0);	\open named file for input
FSet(Hand, ^I);
OpenI(3);
end;	\OpenInFile



proc	OpenOutFile(FN);	\Open file name for output
char	FN;	\file name string
int	H;	\handle
begin
H:= FOpen(FN, 1);
FSet(H, ^o);			\small buffer allows multiple files and it is
OpenO(3);			\ closed automatically when the program exits
end;	\OpenOutFile



proc	Hex1Out(Dev, N);	\Output a hex digit
int	Dev, N;
char	HexDigit;
begin
HexDigit:= "0123456789ABCDEF ";
ChOut(Dev, HexDigit(N & $0F));
end;	\Hex1Out



proc	Hex2Out(Dev, N);	\Output two hex digits (a byte)
int	Dev, N;
begin
Hex1Out(Dev, N>>4);
Hex1Out(Dev, N);
end;	\Hex2Out



proc	ShowFile;
int	C;
begin
Clear;
loop	begin
	C:= ChIn(3);
	if C = $1A then quit;
	ChOut(0, C);
	end;
end;	\ShowFile



proc	GrabImage;
int	I;
begin
for I:= 0, 4000-1 do
	begin
	if (I&$0F) = 0 then
		begin
		CrLf(3);
		Text(3, "	db	");
		end;
	ChOut(3, ^0);
	Hex2Out(3, Peek($B800, I));
	ChOut(3, ^h);
	if (I&$0F) # $0F then ChOut(3, ^,);
	end;
CrLf(3);
end;	\GrabImage



begin	\Main
OpenInFile;
OpenOutFile("IMAGE.ASM");
ShowFile;
GrabImage;
end;	\Main
