;EXAMPLE.ASM	22-Sep-2008	Boreal		loren.blaney@idcomm.com
; Example of how one might display an ANSI image.
;
; The halloween .ANS image was loaded into TheDraw and saved as an .ASM file
; using "crunch" output. This was combined with Uncrunch.asm to produce this
; file.
;
; Assemble with:
;  tasm example
;  tlink /t example

 cseg	segment
	assume	cs:cseg, ds:cseg, ss:cseg, es:cseg

	org	100h
start:	mov	ax, 0003h	;clear screen (necessary)
	int	10h

	MOV     SI,offset IMAGEDATA
	MOV     AX,0B800h
	MOV     ES,AX
	MOV     DI,1*2 + 1*160-162	; = 0
	MOV     CX,IMAGEDATA_LENGTH
	CALL    UNCRUNCH

	mov	ah, 0		;wait for keystroke
	int	16h
	mov	ax, 0003h	;clean up
	int	10h
	ret


; TheDraw Assembler Crunched Screen Image.  Date: 09/22/08

IMAGEDATA_WIDTH EQU 80
IMAGEDATA_DEPTH EQU 100
IMAGEDATA_LENGTH EQU 1204
IMAGEDATA LABEL BYTE
        DB      15,16,25,7,6,'',25,15,14,'',26,9,'',24,25,6,6,''
        DB      '',25,14,14,'',26,13,'',24,25,6,6,'',25,5,''
        DB      '',25,4,14,26,9,'',26,3,'',25,23,7,'',8,''
        DB      24,25,5,6,' ',25,2,'',25,2,'',25,3,14,''
        DB      ' ',25,19,7,'',23,'  ',8,'',16,''
        DB      '',24,25,5,6,' ',25,5,'',25,4,14,'',26,7,''
        DB      '',25,17,7,'',23,' ',8,'',16,'',23,'',16,26
        DB      4,'',24,6,'',25,4,'',25,6,'',25,21,15
        DB      '',25,7,23,' ',7,16,'',8,23,'',16,'',23,'',16
        DB      '',23,'',16,'',23,'',16,26,8,'',24,6,'  '
        DB      ' ',25,10,'',25,16,15,'',26,5,'',25,4,23,' '
        DB      8,'',16,'',23,'',16,26,13,'',24,'  ',6,''
        DB      ' ۰',25,28,15,'',25,3,8,23,'ް',16,''
        DB      '',23,'',16,26,15,'',24,' ',6,'',25,2,'۰'
        DB      25,11,15,'',25,11,'',26,3,'',25,2,8,23,''
        DB      16,'',23,'',0,'Rest in  Peace',8,16,'',24,6,''
        DB      25,4,'',25,11,15,'',26,4,'',25,3,'',26,3
        DB      '  ',26,4,'  ',8,'',23,'',16,26,18,'',24,25
        DB      5,6,' ۱',25,11,15,'',25,2,'',26,23,' ',8,''
        DB      '',26,18,'',24,25,5,6,' ۲',25,9,8,26,5,'',25
        DB      2,15,'',26,21,'',23,'',7,16,'',8,'',7,'',8
        DB      '',7,' ',8,'',26,7,'',24,25,5,6,' ',25,6,8
        DB      '',14,'Happy',8,'',25,2,15,26,18,'',23,'',7
        DB      16,'',23,' ',8,'',7,16,'',8,23,'',7,16,''
        DB      8,'',26,6,'',24,25,5,6,'۲۰',25,5,8,'',14,'H'
        DB      'alloween!',8,'',25,2,15,'',26,4,'',23,'',16,26,11
        DB      '',23,'',7,16,'',8,23,'',7,16,'',8,23,''
        DB      '',7,16,'',8,'',26,6,'',24,25,4,6,' ۲',25
        DB      5,8,'۱۲۲۲۲',25,4,15,'',23,'۲',16,26,8
        DB      '',23,'',7,16,'',8,23,'',7,16,' ',8,'',26
        DB      8,'',24,25,4,6,'۱ ۲',25,5,8,'۲۱۲۲',25
        DB      3,' ',7,'',15,23,'߱',16,26,8,'',23,'',7,16
        DB      ' ',8,26,14,'',24,25,4,6,' ۱۱',25,5,8,''
        DB      '۱',25,3,'۲',7,'',15,23,'',16,26,6
        DB      '',23,'',7,16,'',8,'',26,15,'',24,25,3,6,''
        DB      '  ',25,5,8,'',25,3,'',7,''
        DB      15,23,'',16,26,8,'',23,'۲',7,16,' ',8,26,3,''
        DB      26,10,'',24,25,2,6,' ',25,4,8,' ',26,4,''
        DB      ' ',25,3,' ',26,3,' ',15,'',26,7,'',23,''
        DB      ' ',7,16,'',23,'  ',8,'',7,16,' ',8,26,5,''
        DB      '',24,'  ',6,'   ',25,3,8,'     '
        DB      '',25,3,'  ',25,5,15,26,4,'',7,'',26,3,'',8
        DB      23,26,4,'',7,16,'',8,23,'',7,16,'  ',8,''
        DB      24,6,'ܰ',0,22,'sc',6,16,'',26,3,'ܰ',25,13,26
        DB      22,'',8,22,'',6,16,26,5,'',23,26,15,'',15,22,''
        DB      24,6,16,26,'O',24,24,24,24,24,24,24,24,24,24,24,24,24
        DB      24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24
        DB      24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24
        DB      24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24
        DB      24,24,24,24,24,24,24,24,24,24,24,24


;THEDRAW IMAGE UNCRUNCHING ROUTINE
;-----------------------------------------------------------------------------
;Compatible with MASM (Microsoft) and TASM v1.0 (Borland).  Minor format
;changes may be required for other assemblers.
;-----------------------------------------------------------------------------
;
;This is the routine for displaying crunched TheDraw image files.  The
;crunched data format is a simple custom protocol for reproducing any image.
;The control codes below decimal 32 are reserved for this function.
;Characters 32 and above are written directly to the destination address.
;
;The following shows the format of a control code sequence.  Please note that
;not all functions use the optional bytes <x> or <y>.
;
;Data Structure:  <current byte>[<x>[<y>]]
;
;   0..15 = New Foreground Color
;  16..23 = New Background Color
;      24 = Go down to next line, return to same horizontal position as when
;           routine was started (akin to a c/r).
;      25 = Displays <x> number of spaces.
;      26 = Displays <x> number of <y>.  Also used to display ANY characters
;           below #32.  This function is the only way to do this although it
;           uses three bytes.  Otherwise the code would be interpreted as
;           another command.
;      27 = Toggles on/off the foreground attribute blink flag.
;  28..31 = reserved
;
;----------------------------------------------------------------------------
;
;To use the routine, call the uncrunch procedure with the DS:SI register pair
;pointing to the TheDraw output listing, the ES:DI register pair pointing to
;the destination display address, and the length of the crunched image data
;in the CX register.  All modified registers are restored upon exiting.
;
;Assume an output file of a 40 character by 10 line block.  The label
;'IMAGEDATA' has been added for referencing purposes. ie:
;
;
;     ;TheDraw Assembler Crunched Screen Image
;     IMAGEDATA_WIDTH EQU 40
;     IMAGEDATA_DEPTH EQU 10
;     IMAGEDATA_LENGTH EQU 467
;     IMAGEDATA LABEL BYTE
;                DB      ...list of image bytes here...
;
;
;The following assembly language code could then be used to display the
;40x10 block on the screen with:
;
;                MOV     SI,offset IMAGEDATA
;                MOV     AX,0B800h
;                MOV     ES,AX
;                MOV     DI,34*2 + 5*160-162
;                MOV     CX,IMAGEDATA_LENGTH
;                CALL    UNCRUNCH
;
;The data segment (DS register) is assumed to point at the segment ImageData
;resides in.   The ES:DI register pair points at position (34,5) on the color
;graphics adapter screen, calculated as an offset from the start of the screen.
;Monochrome card users, replace the 0B800h with 0B000h.
;
;The original horizontal starting offset is remembered by the uncrunch routine.
;The offset is restored upon moving down to the next line.  This permits a
;block to be displayed correctly anywhere on the screen.  ie:
;
;               horizontal starting offset
;              V
;  +-------------------------------------------------+
;  |                                                 |
;  |                                                 | <- Assume this
;  |                                                 |    is the video
;  |           Ŀ               |    display.
;  |           ۳               |
;  |           ۳               |
;  |            ImageData block ۳               |
;  |           ۳               |
;  |           ۳               |
;  |           ۳               |
;  |                          |
;  |                                                 |
;  |                                                 |
;  |                                                 |
;  +-------------------------------------------------+
;
;
;To display the block in the lower-right corner, change the DI assignment to:
;
;                MOV     DI,40*2 + 15*160-162
;
;The block is 40 characters wide by 10 lines deep.  To display on a 80 by 25
;screen, we must display the block at coordinates (40,15).  To display in
;the upper-left screen corner use:
;
;                MOV     SI,offset IMAGEDATA
;                MOV     AX,0B800H
;                MOV     ES,AX
;                MOV     DI,1*2 + 1*160-162       ;coordinates 1,1
;                MOV     CX,IMAGEDATA_LENGTH
;                CALL    UNCRUNCH
;
;Notice in both cases only the offset address changed.  Note the latter case
;is also used for displaying a full screen image (which in general are
;always displayed at coordinate 1,1).
;
;----------------------------------------------------------------------------
;
;That's it!  The routine was designed for easy use and understanding; however,
;for some people the best way is to experiment.  Create a program using the
;above examples, perhaps with a 40x10 block (or any size).  Good luck!
;

UNCRUNCH PROC NEAR
;
;Parameters Required:
;  DS:SI  Crunched image source pointer.
;  ES:DI  Display address pointer.
;  CX     Length of crunched image source data.
;
       PUSH    SI                      ;Save registers.
       PUSH    DI
       PUSH    AX
       PUSH    BX
       PUSH    CX
       PUSH    DX
       JCXZ    Done

       MOV     DX,DI                   ;Save X coordinate for later.
       XOR     AX,AX                   ;Set Current attributes.
       CLD

LOOPA: LODSB                           ;Get next character.
       CMP     AL,32                   ;If a control character, jump.
       JC      ForeGround
       STOSW                           ;Save letter on screen.
Next:  LOOP    LOOPA
       JMP     Short Done

ForeGround:
       CMP     AL,16                   ;If less than 16, then change the
       JNC     BackGround              ;foreground color.  Otherwise jump.
       AND     AH,0F0H                 ;Strip off old foreground.
       OR      AH,AL
       JMP     Next

BackGround:
       CMP     AL,24                   ;If less than 24, then change the
       JZ      NextLine                ;background color.  If exactly 24,
       JNC     FlashBitToggle          ;then jump down to next line.
       SUB     AL,16                   ;Otherwise jump to multiple output
       ADD     AL,AL                   ;routines.
       ADD     AL,AL
       ADD     AL,AL
       ADD     AL,AL
       AND     AH,8FH                  ;Strip off old background.
       OR      AH,AL
       JMP     Next

NextLine:
       ADD     DX,160                  ;If equal to 24,
       MOV     DI,DX                   ;then jump down to
       JMP     Next                    ;the next line.

FlashBitToggle:
       CMP     AL,27                   ;Does user want to toggle the blink
       JC      MultiOutput             ;attribute?
       JNZ     Next
       XOR     AH,128                  ;Done.
       JMP     Next

MultiOutput:
       CMP     AL,25                   ;Set Z flag if multi-space output.
       MOV     BX,CX                   ;Save main counter.
       LODSB                           ;Get count of number of times
       MOV     CL,AL                   ;to display character.
       MOV     AL,32
       JZ      StartOutput             ;Jump here if displaying spaces.
       LODSB                           ;Otherwise get character to use.
       DEC     BX                      ;Adjust main counter.

StartOutput:
       XOR     CH,CH
       INC     CX
       REP STOSW
       MOV     CX,BX
       DEC     CX                      ;Adjust main counter.
       LOOPNZ  LOOPA                   ;Loop if anything else to do...

Done:  POP     DX                      ;Restore registers.
       POP     CX
       POP     BX
       POP     AX
       POP     DI
       POP     SI
       RET

UNCRUNCH ENDP

cseg	ends
	end	start
