	page	240, 132
;TESTER.ASM	24-Sep-2008	Boreal		loren.blaney@idcomm.com
;ENTRY.COM tester for Hugi Compo 27
;This borrows code written by Ruud, TAD & possibly others that was used in
; Compos 10 and 13. Thanks guys!
;
; Assemble with:
;  tasm tester
;  tlink /t tester
;

	.386
cseg	segment para public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

	org	100h
start:
;Shrink our memory to 128K to provide space for ENTRY.COM child program
	mov	ah, 4Ah
	mov	bx, 2000h
	int	21h
	mov	[wCs1], ax		;completely undocumented trick: ax = es
	mov	[wCs2], ax		; unless error code is returned instead
	mov	[wCs3], ax

;Hook in our keyboard interrupt (16h) handler
	mov	ax, 3516h		;copy interrupt vector into es:bx
	int	21h
	mov	wOld16, bx		;save it in Old16
	mov	wOld16+2, es

	mov	ax, 2516h		;set interrupt vector 16h to ds:dx
	mov	dx, offset Int16Hook
	int	21h

;Execute ENTRY.COM
	mov	ax, 4B00h		;load and execute program
	mov	bx, offset bEpb		;es:bx = parameter block
	push	ds
	pop	es
	mov	dx, offset EntryCom	;ds:dx = file name (ENTRY.COM)
	int	21h
	jnc	err00
	or	ErrFlag, 10h		;ENTRY.COM not found
err00:
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	push	cs			;another undocumented "feature" of DOS:
	pop	ds			; ds is not necessarily preserved

;Unhook keyboard interrupt (16h) handler (restore vector)
	push	ds
	lds	dx, dword ptr cs:wOld16	;get original interrupt vector
	mov	ax, 2516h		;restore it
	int	21h
	pop	ds

;Display error messages
	mov	ah, 02h			;position cursor to bottom left (0,24)
	xor	bx, bx			;page 0
	mov	dx, 24*256+0		;(80-12)/2 = 34
	int	10h

	mov	dx, offset msgNo	;assume no errors will be detected
	cmp	ErrFlag, 0		;return error code to DOS
	je	err30
	 mov	dx, offset msgErr	;we have errors to report
err30:	mov	ah, 09h			;display message
	int	21h

	mov	ah, 09h
	test	ErrFlag, 02h
	je	err34
	 mov	dx, offset msg1		;Screen error
	 int	21h
err34:
	test	ErrFlag, 10h
	je	err40
	 mov	dx, offset msg4		;ENTRY.COM not found
	 int	21h
err40:
	mov	ax, ErrFlag
	mov	ah, 4Ch			;return to DOS
	int	21h

;-------------------------------------------------------------------------------
;New keyboard interrupt handler
;
Int16Hook:
	pushf				;preserve flags
	cmp	ah, 0			;only intercept function 0 (read key)
	jne	Old16
	 sti				;re-enable interrupts
	 cld				;tester expects this
	 call	Check			;check for errors
Old16:
	popf
	db	0EAh			;jmp far ptr
wOld16	dw	?, ?			;original int 16h vector

;-------------------------------------------------------------------------------
;Check if Image compares with B800h. Display error message if not.
;
Check:	pusha

	mov	ax, offset Image	;es:= segment address of Image
	shr	ax, 4
	mov	dx, cs
	add	ax, dx
	mov	es, ax

	push	0B800h
	pop	ds
	xor	di, di
	xor	si, si

;Do a word-for-word compare
	mov	cx, 80*25
ck15:	repe cmpsw			;cmp ds:[si++], es:[di++]; cx--
	je	ck90			;jump if no mismatch is found

;We have a mismatch, but is it visible?
;If both chars are solid blocks then their background attributes don't matter
	mov	ax, [si-2]		;get last char along with its attribute
	cmp	al, 0DBh		;if both chars are blocks
	jne	ck20
	cmp	al, es:[di-2]
	jne	ck20
	mov	al, es:[di-1]		;compare attributes
	and	ax, 0F0Fh		;ingnoring background colors
	cmp	al, ah
	je	ck15			;jump if no visible difference
ck20:

;If both chars are blank chars then their foreground attributes don't matter
	mov	ax, [si-2]		;get last char along with its attribute
	cmp	al, 20h
	je	ck30
	cmp	al, 0
	je	ck30
	cmp	al, 0FFh
	jne	ck36
ck30:
	cmp	byte ptr es:[di-2], 20h
	je	ck33
	cmp	byte ptr es:[di-2], 0
	je	ck33
	cmp	byte ptr es:[di-2], 0FFh
	jne	ck36
ck33:
	mov	al, es:[di-1]		;compare attributes
	and	ax, 0F0F0h		;ingnoring foreground colors
	cmp	al, ah
	je	ck15			;jump if no visible difference
ck36:

;If one char is a solid block and the other is a blank then they may look the
; same if their swapped foreground and background attributes are the same
	mov	ax, [si-2]		;get last char along with its attribute
	cmp	al, 0DBh		;if it's a block...
	jne	ck50
	cmp	byte ptr es:[di-2], 20h
	je	ck40
	cmp	byte ptr es:[di-2], 0
	je	ck40
	cmp	byte ptr es:[di-2], 0FFh
	jne	ck50
ck40:
	mov	al, es:[di-1]		;get blank's attributes
	shr	al, 4			;move blank's bkgnd colors into low bits
	and	ah, 0Fh			;ingnore block's bkgnd colors
	cmp	al, ah
	je	ck15			;jump if no visible difference
ck50:
	mov	ax, [si-2]		;get last char along with its attribute
	cmp	al, 20h			;if it's a blank...
	je	ck60
	cmp	al, 0
	je	ck60
	cmp	al, 0FFh
	jne	ck70
ck60:
	cmp	byte ptr es:[di-2], 0DBh
	jne	ck70
	mov	al, es:[di-1]		;get block's attributes
	shr	ah, 4			;move blank's bkgnd colors into low bits
	and	al, 0Fh			;ingnore block's bkgnd colors
	cmp	al, ah
	je	ck15			;jump if no visible difference
ck70:

	push	cs
	pop	ds

;Display error screen
	or	ErrFlag, 02h		;flag 'Screen error'

	mov	ah, 02h			;position cursor to bottom center (34,23)
	xor	bx, bx			;page 0
	mov	dx, 23*256+34		;(80-12)/2 = 34
	int	10h

	mov	ah, 09h			;display error message
	mov	dx, offset ScnErr
	int	21h

;Flip Image and ENTRY.COM's screen displays until a key is struck
err10:	mov	cx, 9			;delay about 1/2 second
wait00:	push	es			;wait for next system timer interrupt
	push	0
	pop	es
	mov	al, es:[46Ch]		;read system timer byte
wait10:	cmp	al, es:[46Ch]		;wait for it to change
	je	short wait10
	pop	es
	loop	wait00

; ds:si = B800:0
; es:di = ImageSeg:0
	xor	si, si
	xor	di, di
	push	ds
	push	0B800h
	pop	ds
	mov	cx, 80*25
swap10:	mov	ax, [si]		;swap hardware screen and Image
	mov	dx, es:[di]

	mov	[si], dx
	stosw				;es:[di++] := ax
	add	si, 2
	loop	swap10
	pop	ds

	mov	ah, 01h			;loop until key press
	int	16h
	je	err10

	mov	ah, 4Ch			;terminate ENTRY.COM
	int	21h			;(return to tester if error detected)

ck90:
	push	cs			;(return to caller if no error detected)
	pop	ds
	popa
	ret


ScnErr	db	'Screen error$'

ErrFlag	dw	0			;flag bits for each type of error

msgNo:	db	'No '
msgErr:	db	'Errors Detected', 0Dh, 0Ah, '$'
msg1	db	'Screen error', 0Dh, 0Ah, '$'
msg4	db	'ENTRY.COM not found', 0Dh, 0Ah, '$'

EntryCom db	'ENTRY.COM', 0

bEpb	dw	0			;segment pointer to environment block
	dw	80h			;offset of command line tail
wCs1	dw	?			;segment of command line tail
	dw	5Ch			;offset of 1st FCB copied into new PSP
wCs2	dw	?			;segment of 1st FCB
	dw	6Ch			;offset of 2nd FCB copied into new PSP
wCs3	dw	?			;segment of 2nd FCB
	dw	$-bEpb

	align	16
Image	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,0DCh,00Eh,0DCh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh
	db	0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DCh,00Eh,0DCh,00Eh,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h
	db	0B0h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DCh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh
	db	0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DCh,00Eh
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h
	db	0B0h,006h,0B2h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0B2h,006h,0B2h,006h,0B0h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh
	db	0DBh,00Eh,0DBh,00Eh,0DFh,00Eh,0DFh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DCh,007h,0DCh,007h,0DCh,007h,0DCh,008h,0DCh,008h,0DCh,008h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h,0B1h,006h
	db	020h,006h,0B2h,006h,020h,006h,020h,006h,020h,006h,0B1h,006h,0B1h,006h,0B2h,006h
	db	020h,006h,020h,006h,020h,006h,0B1h,006h,0B0h,006h,020h,006h,020h,006h,020h,006h
	db	020h,006h,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DFh,00Eh,0DCh,00Eh,0DCh,00Eh,0DFh,00Eh
	db	020h,00Eh,0DCh,00Eh,0DBh,00Eh,0DBh,00Eh,0DCh,00Eh,0DBh,00Eh,0DBh,00Eh,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,0DCh,007h,0DCh,007h,020h,078h,020h,078h,0B0h,078h
	db	0B1h,078h,0B1h,078h,0DBh,008h,0DCh,008h,0DCh,008h,0DCh,008h,0DFh,008h,0DFh,008h
	db	0DBh,008h,0DCh,008h,0DCh,008h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B2h,006h,0B1h,006h
	db	0B0h,006h,0B1h,006h,0B1h,006h,020h,006h,0B0h,006h,0B1h,006h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DFh,00Eh,0DFh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh
	db	0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DFh,00Eh,0DFh,00Eh,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DCh,007h,020h,078h,0B0h,078h,0B1h,078h,0B1h,078h,0B1h,078h,0B2h,078h,0B2h,078h
	db	0DBh,008h,0B2h,078h,0DBh,078h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DCh,008h,0DCh,008h,0DFh,008h,0DFh,008h,0DBh,008h,0DCh,008h,020h,007h,020h,007h
	db	0B0h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h,0B2h,006h
	db	0B1h,006h,0B1h,006h,0B1h,006h,0B2h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,0B0h,006h,0B0h,006h,0B1h,006h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0DCh,00Fh,0DCh,00Fh,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,078h
	db	0DBh,007h,0B0h,078h,0B1h,078h,0B2h,078h,0DBh,008h,0B1h,078h,0DBh,008h,0B2h,078h
	db	0DBh,008h,0DBh,078h,0DBh,078h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DCh,008h,0DFh,008h,0DBh,008h,020h,007h
	db	0B0h,006h,0B1h,006h,020h,006h,020h,006h,0B1h,006h,0B0h,006h,0B1h,006h,0B2h,006h
	db	0B2h,006h,0B0h,006h,020h,006h,0B1h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0B0h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DCh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DCh,00Fh,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,078h
	db	0B0h,078h,0B1h,078h,0B2h,078h,0DBh,008h,0DBh,008h,0B2h,078h,0DBh,078h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,008h,020h,008h,0B0h,006h,0B0h,006h,0B1h,006h,020h,006h,0B0h,006h,0B1h,006h
	db	0DBh,006h,0B0h,006h,0B0h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,0DEh,00Fh,0DBh,00Fh,0DFh,00Fh,0DFh,00Fh,0DBh,00Fh,0DBh,00Fh,0DFh,00Fh
	db	0DFh,00Fh,0DBh,00Fh,0DBh,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,0DEh,078h
	db	0B0h,078h,0B1h,078h,0DBh,008h,0DBh,008h,0DBh,078h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,008h,0B0h,006h,0B1h,006h,020h,006h,020h,006h,020h,006h,0B0h,006h,0B1h,006h
	db	0DBh,006h,0B0h,006h,0B0h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DFh,00Fh,0DCh,00Fh,0DCh,00Fh,0DBh,00Fh,0DCh,00Fh,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,0DBh,00Fh,0DCh,00Fh,0DCh,00Fh,0DBh,00Fh,0DBh,00Fh,0DCh,00Fh,0DCh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,0DEh,078h
	db	0DBh,008h,0B1h,078h,0DBh,078h,0FEh,070h,052h,070h,065h,070h,073h,070h,074h,070h
	db	020h,070h,069h,070h,06Eh,070h,020h,070h,020h,070h,050h,070h,065h,070h,061h,070h
	db	063h,070h,065h,070h,0FEh,070h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	0B0h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B2h,006h,0B1h,006h
	db	0B2h,006h,0B1h,006h,0B0h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DFh,00Fh,0DCh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DCh,00Fh
	db	0DCh,00Fh,0DCh,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,0DCh,00Fh,0DCh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DCh,00Fh,020h,00Fh,020h,00Fh,0DFh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,020h,00Fh,020h,00Fh,0DBh,008h
	db	0DBh,008h,0B2h,078h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B2h,006h,020h,006h
	db	0B2h,006h,0DBh,006h,0B1h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DFh,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,0DFh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DCh,00Fh,0DCh,00Fh,020h,00Fh
	db	0DFh,008h,0DFh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h,020h,006h
	db	0B2h,006h,0DBh,006h,0B2h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0DCh,008h,0DCh,008h
	db	0DCh,008h,0DCh,008h,0DCh,008h,0DCh,008h,020h,008h,020h,008h,020h,008h,0DFh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh,0B1h,07Fh
	db	0DBh,007h,0DCh,007h,0DCh,007h,0DCh,007h,0DFh,008h,0DBh,008h,0DFh,008h,0DCh,007h
	db	0DFh,008h,0DFh,008h,0DCh,007h,020h,007h,0DFh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h,0B2h,006h
	db	0DBh,006h,020h,006h,0B2h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,0DCh,008h,0DBh,008h,0DBh,008h,048h,00Eh,061h,00Eh
	db	070h,00Eh,070h,00Eh,079h,00Eh,0DBh,008h,0DBh,008h,0DBh,008h,0DCh,008h,020h,008h
	db	020h,008h,020h,008h,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh,0B1h,07Fh,0B0h,07Fh
	db	0DBh,007h,0DBh,007h,020h,078h,0B0h,078h,0B1h,078h,0DCh,007h,0DCh,007h,0DCh,007h
	db	0B0h,078h,0B0h,078h,0B1h,078h,0DCh,007h,0DFh,007h,0DCh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0DBh,006h,0B2h,006h
	db	0DBh,006h,0B0h,006h,0B2h,006h,0B2h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DBh,008h,0DBh,008h,048h,00Eh,061h,00Eh,06Ch,00Eh,06Ch,00Eh
	db	06Fh,00Eh,077h,00Eh,065h,00Eh,065h,00Eh,06Eh,00Eh,021h,00Eh,0DBh,008h,0DBh,008h
	db	020h,008h,020h,008h,020h,008h,0DFh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,07Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh,0B1h,07Fh
	db	0B0h,07Fh,0DBh,007h,0B0h,078h,0DBh,007h,0B0h,078h,0B0h,078h,0B0h,078h,0B1h,078h
	db	0B0h,078h,0B0h,078h,0B1h,078h,0DFh,007h,0DFh,007h,0DCh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B2h,006h,0B2h,006h,020h,006h
	db	0B0h,006h,0B1h,006h,0DBh,006h,0B2h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DBh,008h,0DBh,008h,0B1h,008h,0DBh,008h,0DBh,008h,0B2h,008h
	db	0B2h,008h,0DBh,008h,0B2h,008h,0DBh,008h,0DBh,008h,0B2h,008h,0DBh,008h,0B2h,008h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0DFh,00Fh,0DFh,00Fh,0B1h,07Fh
	db	0B1h,07Fh,0DBh,07Fh,0B2h,07Fh,0DBh,07Fh,0DBh,07Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh,0B1h,07Fh
	db	0B0h,07Fh,0DBh,007h,0DBh,007h,0B0h,078h,0B0h,078h,0B0h,078h,0DFh,007h,0DFh,007h
	db	020h,007h,0DCh,008h,0DCh,008h,0DCh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0DBh,006h,0B1h,006h,0B0h,006h
	db	020h,006h,0B1h,006h,0DBh,006h,0B2h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DBh,008h,0B2h,008h,0B0h,008h,0B2h,008h,0B2h,008h,0B1h,008h
	db	0B2h,008h,0DBh,008h,0B1h,008h,0B2h,008h,0DBh,008h,0B2h,008h,0DBh,008h,0B2h,008h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0DCh,008h,0DBh,008h,0DBh,008h,020h,008h
	db	0DBh,007h,0DBh,007h,0DBh,007h,0DFh,07Fh,0B1h,07Fh,0DBh,07Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh
	db	0B1h,07Fh,0B0h,07Fh,0DBh,007h,0DBh,007h,0DFh,007h,020h,007h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B2h,006h,020h,006h,0DBh,006h
	db	0B1h,006h,0B1h,006h,0DBh,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0B2h,008h,0B1h,008h,0B0h,008h,0B1h,008h,0B2h,008h,0B1h,008h
	db	0B1h,008h,0B2h,008h,0B0h,008h,0B2h,008h,0B2h,008h,0B1h,008h,0DBh,008h,0B1h,008h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0B2h,008h,0DBh,008h,0B2h,008h,0B1h,008h
	db	0DCh,008h,0DFh,007h,0DBh,007h,0DBh,007h,0B1h,07Fh,0DBh,07Fh,0DBh,07Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh,0B1h,07Fh
	db	0DBh,007h,0DFh,007h,0DCh,008h,0DCh,008h,0DCh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0B2h,006h,0DBh,006h,020h,006h,0B1h,006h
	db	020h,006h,0B0h,006h,0B2h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0B2h,008h,0B0h,008h,0B0h,008h,0B0h,008h,0B1h,008h,0B0h,008h
	db	0B1h,008h,0B1h,008h,0B0h,008h,0B1h,008h,0B1h,008h,0B1h,008h,0B2h,008h,0B1h,008h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0B1h,008h,0B2h,008h,0B1h,008h,0B0h,008h
	db	0B2h,008h,0B2h,008h,0DCh,008h,0DFh,007h,0B1h,07Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,07Fh,0B2h,07Fh
	db	0B1h,07Fh,0B0h,07Fh,0DCh,007h,0DCh,007h,0DCh,007h,020h,007h,0DFh,008h,0DFh,008h
	db	0DFh,008h,0DFh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,008h,020h,008h,020h,008h,0B2h,006h,0DBh,006h,020h,006h,0B2h,006h,0B0h,006h
	db	0B0h,006h,0B0h,006h,0B2h,006h,0B0h,006h,0B0h,006h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0B1h,008h,0B0h,008h,020h,008h,0B0h,008h,0B0h,008h,0B0h,008h
	db	0B0h,008h,0B0h,008h,020h,008h,0B0h,008h,0B1h,008h,0B0h,008h,0B1h,008h,0B0h,008h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0B0h,008h,0B1h,008h,0B0h,008h,020h,008h
	db	0B1h,008h,0B1h,008h,0B1h,008h,0B1h,008h,020h,008h,0DFh,00Fh,0DFh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B1h,07Fh
	db	0B0h,07Fh,020h,07Fh,0DBh,007h,0DBh,007h,020h,078h,020h,078h,0B0h,078h,0B0h,078h
	db	0B0h,078h,0B1h,078h,0DCh,007h,020h,007h,0DFh,008h,0DFh,008h,0DFh,008h,0DFh,008h
	db	0DFh,008h,0DFh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,008h,020h,008h,0B2h,006h,0B2h,006h,020h,006h,020h,006h,0B1h,006h,0B0h,006h
	db	0B0h,006h,020h,006h,0B2h,006h,0B1h,006h,0B0h,006h,0B0h,006h,020h,006h,020h,006h
	db	020h,006h,020h,006h,0B0h,008h,020h,008h,020h,008h,0B0h,008h,0B0h,008h,0B0h,008h
	db	020h,008h,0B0h,008h,020h,008h,0B0h,008h,0B0h,008h,020h,008h,0B0h,008h,0B0h,008h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0B0h,008h,0B0h,008h,020h,008h,020h,008h
	db	0B1h,008h,0B0h,008h,0B0h,008h,0B0h,008h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DFh,00Fh,0DFh,00Fh,0DFh,00Fh,0DFh,00Fh,0DFh,00Fh,0DFh,007h
	db	0DBh,007h,0DBh,007h,0DBh,007h,0DBh,007h,0B0h,078h,0B0h,078h,0B0h,078h,0B0h,078h
	db	0B0h,078h,0DBh,007h,0B0h,078h,0B0h,078h,0B1h,078h,0B1h,078h,0DBh,007h,0DBh,007h
	db	0DBh,007h,0DCh,007h,0DCh,007h,0DCh,007h,020h,007h,020h,007h,0DFh,008h,020h,007h
	db	0DCh,006h,0B0h,006h,0B1h,006h,073h,060h,063h,060h,0B0h,006h,0B1h,006h,0B2h,006h
	db	0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0B0h,006h,0B0h,006h,0B0h,006h,0DCh,006h
	db	0DCh,006h,0DCh,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h
	db	0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h
	db	0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DFh,068h
	db	0DFh,068h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,076h
	db	0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h
	db	0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DFh,06Fh
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h

cseg	ends
	end	start
