	page	240, 132
;TESTER2.ASM	28-Sep-2008	Boreal		loren.blaney@idcomm.com
;ENTRY.COM tester for Hugi Compo 27
;This borrows code written by Ruud, TAD & possibly others that was used in
; Compos 10 and 13. Thanks guys!
;
; Assemble with:
;  tasm tester
;  tlink /t tester
;
;REVISIONS:
; 28-Sep-08: Allow DC/DF and DD/DE to be swapped if their background and
; foreground colors are swapped. Test for blinking characters. Force WinXP
; into full-screen mode.

	.386
cseg	segment para public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

	org	100h
start:
;Make WinXP initialize the hardware blink bit (so characters flash like in DOS)
	mov	ax, 0013h		;force Windows into full-screen mode
	int	10h			;(Vista chokes on this)

	mov	ax, 0003h		;restore normal text mode with blink
	int	10h			; bit initialized to flash chars

;Shrink our memory to 128K to provide space for ENTRY.COM child program
	mov	ah, 4Ah
	mov	bx, 2000h
	int	21h
	mov	[wCs1], ax		;completely undocumented trick: ax = es
	mov	[wCs2], ax		; unless error code is returned instead
	mov	[wCs3], ax

;Hook in our keyboard interrupt (16h) handler
	mov	ax, 3516h		;copy interrupt vector into es:bx
	int	21h
	mov	wOld16, bx		;save it in Old16
	mov	wOld16+2, es

	mov	ax, 2516h		;set interrupt vector 16h to ds:dx
	mov	dx, offset Int16Hook
	int	21h

;Execute ENTRY.COM
	mov	ax, 4B00h		;load and execute program
	mov	bx, offset bEpb		;es:bx = parameter block
	push	ds
	pop	es
	mov	dx, offset EntryCom	;ds:dx = file name (ENTRY.COM)
	int	21h
	jnc	err00
	 or	ErrFlag, 10h		;ENTRY.COM not found
err00:
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	push	cs			;another undocumented "feature" of DOS:
	pop	ds			; ds is not necessarily preserved

;Unhook keyboard interrupt (16h) handler (restore vector)
	push	ds
	lds	dx, dword ptr cs:wOld16	;get original interrupt vector
	mov	ax, 2516h		;restore it
	int	21h
	pop	ds

;Display error messages
	mov	ax, 0003h		;make sure normal text mode is restored
	int	10h			; with blink bit initialized to flash

	mov	dx, offset msgNo	;assume no errors will be detected
	cmp	ErrFlag, 0		;return error code to DOS
	je	err30
	 mov	dx, offset msgErr	;we have errors to report
err30:	mov	ah, 09h			;display message
	int	21h

	mov	ah, 09h
	test	ErrFlag, 02h
	je	err34
	 mov	dx, offset msg1		;Screen error
	 int	21h
err34:
	test	ErrFlag, 10h
	je	err40
	 mov	dx, offset msg4		;ENTRY.COM not found
	 int	21h
err40:
	mov	ax, ErrFlag
	mov	ah, 4Ch			;return to DOS
	int	21h

;-------------------------------------------------------------------------------
;New keyboard interrupt handler
;
Int16Hook:
	pushf				;preserve flags
	cmp	ah, 0			;only intercept function 0 (read key)
	jne	Old16
	 sti				;re-enable interrupts
	 cld				;tester expects this
	 call	Check			;check for errors
Old16:
	popf
	db	0EAh			;jmp far ptr
wOld16	dw	?, ?			;original int 16h vector

;-------------------------------------------------------------------------------
;Check if Image compares with B800h. Display error message if not.
;
Check:	pusha

	mov	dx, 3DAh	;reset index/data flip-flop
	in	al, dx
	mov	dx, 3C0h	;select mode control register
	mov	al, 10h+20h	;(palette address source = display memory)
	out	dx, al
	inc	dx		;read mode control register
	in	al, dx
	and	al, 08h		;get blink/intense bit
	mov	cs:blink, al	;save it for test below

	mov	ax, offset Image ;es:[di] = required Image data
	shr	ax, 4		; >>
	mov	dx, cs
	add	ax, dx
	mov	es, ax

	push	0B800h		;ds:[si] = entry's display
	pop	ds
	xor	di, di
	xor	si, si

;Do a word-for-word compare
	mov	cx, 80*25
ck10:	repe cmpsw		;cmp ds:[si++], es:[di++]; cx--
	je	ck90		;jump if no mismatch is found

;We have a mismatch, but is it okay?

;Check for blinking characters
	mov	al, [si-1]	;get entry's colors
	test	al, 80h		;is the blink/intensity bit set?
	je	ck20		;skip if not
	cmp	byte ptr cs:blink, 0 ;is blinking disabled?
	je	ck20		;skip if so

;if chi=block then trying to make a block character
	mov	ax, es:[di-2]	;get Image's char and backgnd & foregnd colors
	cmp	al, 0DBh	;is Image's character a block?
	jne	ck15		;skip if not

;if che=blank & (bge&7)=fgi then okay
	cmp	byte ptr [si-2], 20h	;is entry a blank?
	je	ck12
	cmp	byte ptr [si-2], 00h
	je	ck12
	cmp	byte ptr [si-2], 0FFh
	jne	ck14		;skip if not
ck12:
	mov	al, [si-1]	;get entry's background colors
	shr	al, 4		; >>
	and	ax, 0F07h	;are they the same as Image's foreground colors?
	cmp	al, ah
	je	ck10		;loop if so
ck14:
;else if (bge&7)=fge=fgi then okay -- che = any character
	mov	al, [si-1]	;get entry's colors
	mov	ah, es:[di-1]	;get Image's colors (for safety)
	mov	dl, al
	and	ax, 0F0Fh	;is entry's foreground = Image's foreground?
	cmp	al, ah
	jne	err10		;error if not
	shr	dl, 4		;is entry's background = its foreground?
	and	dl, 07h
	cmp	al, dl
	je	ck10		;loop if so
	jmp	err10		;error if not
ck15:
;if chi=space then trying to make a space
	cmp	al, 20h		;is Image char a space?
	jne	err10		;error if not

;if che=blank & (bge&7)=bgi then okay -- any blank; foreground doesn't matter
	cmp	al, [si-2]	;is entry a blank?
	je	ck17
	cmp	byte ptr [si-2], 00h
	je	ck17
	cmp	byte ptr [si-2], 0FFh
	jne	ck18		;skip if not
ck17:
	mov	al, [si-1]	;get entry's colors
	and	ax, 0F070h	;ignore foreground colors
	cmp	al, ah		;are background colors the same?
	je	ck10		;loop if so
ck18:
;else if (bge&7)=fge=bgi then okay -- che = any character
	mov	al, [si-1]	;get entry's colors
	mov	ah, es:[di-1]	;get Image's colors (for safety)
	mov	dl, al
	and	ax, 0F070h	;is entry's background = Image's background?
	cmp	al, ah
	jne	err10		;error if not
	shl	dl, 4		;is entry's background = its foreground?
	cmp	al, dl
	je	ck10		;loop if so
	jmp	err10		;error if not
ck20:
;if chi=block then trying to make a block character
	mov	ax, es:[di-2]	;get Image's char and backgnd & foregnd colors
	cmp	al, 0DBh	;is Image's character a block?
	jne	ck30		;skip if not

;if che=block & fge=fgi then okay -- background doesn't matter
	cmp	al, [si-2]	;is entry a block?
	jne	ck21		;skip if not
	mov	al, [si-1]	;get entry's colors
	and	ax, 0F0Fh	;ignore background colors
	cmp	al, ah		;are foreground colors the same?
	je	ck10		;loop if so
ck21:
;else if che=blank & bge=fgi then okay	-- swap blank and background/foreground
	cmp	byte ptr [si-2], 20h	;is entry a blank?
	je	ck22
	cmp	byte ptr [si-2], 00h
	je	ck22
	cmp	byte ptr [si-2], 0FFh
	jne	ck25		;skip if not
ck22:
	mov	al, [si-1]	;get entry's background colors
	mov	ah, es:[di-1]	;get Image's colors
	shr	al, 4		; >>
	and	ah, 0Fh		;are they the same as Image's foreground colors?
	cmp	al, ah
	je	ck10		;loop if so
ck25:
;else if bge=fge=fgi then okay -- che = any character
	mov	al, [si-1]	;get entry's colors
	mov	ah, es:[di-1]	;get Image's colors
	mov	dl, al
	and	ax, 0F0Fh	;is entry's foreground = Image's foreground?
	cmp	al, ah
	jne	err10		;error if not
	shr	dl, 4		;is entry's background = its foreground?
	cmp	al, dl
	je	ck10		;loop if so
	jmp	err10		;error if not
ck30:
;if chi=space then trying to make a space
	cmp	al, 20h		;is Image char a space?
	jne	ck40		;skip if not

;if che=blank & bge=bgi then okay -- any blank; foreground doesn't matter
	cmp	al, [si-2]	;is entry a blank?
	je	ck32
	cmp	byte ptr [si-2], 00h
	je	ck32
	cmp	byte ptr [si-2], 0FFh
	jne	ck35		;skip if not
ck32:
	mov	al, [si-1]	;get entry's colors
	mov	ah, es:[di-1]	;get Image's colors
	and	ax, 0F0F0h	;ignore foreground colors
	cmp	al, ah		;are background colors the same?
	je	ck10		;loop if so
ck35:
;else if che=block & fge=bgi then okay	-- swap block and background/foreground
	cmp	byte ptr [si-2], 0DBh	;is entry a block?
	jne	ck37

	mov	al, [si-1]	;get entry's foreground colors
	mov	ah, es:[di-1]	;get Image's colors
	and	al, 0Fh
	shr	ah, 4		;are they the same as Image's background colors?
	cmp	al, ah
	je	ck10		;loop if so
ck37:
;else if bge=fge=bgi then okay -- che = any character
	mov	al, [si-1]	;get entry's colors
	mov	ah, es:[di-1]	;get Image's colors
	mov	dl, al
	and	ax, 0F0F0h	;is entry's background = Image's background?
	cmp	al, ah
	jne	err10		;error if not
	shl	dl, 4		;is entry's background = its foreground?
	cmp	al, dl
	je	ck10		;loop if so
	jmp	err10		;error if not
ck40:
;if chi=leftbar then trying to make a left bar
	cmp	al, 0DDh	;is Image char a left bar?
	jne	ck50		;skip if not

;if che=rightbar & bge=fgi & fge=bgi then okay -- swap background and foreground
; else error
	cmp	byte ptr [si-2], 0DEh	;is entry a right bar?
ck45:	jne	err10		;error if not (COMMON CODE)
	mov	al, [si-1]	;get entry's colors
	ror	al, 4		;swap foreground and background
	cmp	al, ah		;do they match Image's colors?
	je	ck10		;loop if so
	jmp	err10		;error if not
ck50:
;if chi=rightbar then trying to make a right bar
	cmp	al, 0DEh	;is Image char a right bar?
	jne	ck60		;skip if not

;if che=leftbar & bge=fgi & fge=bgi then okay -- swap background and foreground
; else error
	cmp	byte ptr [si-2], 0DDh	;is entry a left bar?
	jmp	ck45		;jump to common code
ck60:
;if chi=botblk then trying to make a bottom block
	cmp	al, 0DCh	;is Image char a bottom block?
	jne	ck70		;skip if not

;if che=topblk & bge=fgi & fge=bgi then okay -- swap background and foreground
; else error
	cmp	byte ptr [si-2], 0DFh	;is entry a top block?
	jmp	ck45		;jump to common code
ck70:
;if chi=topblk then trying to make a top block
	cmp	al, 0DFh	;is Image char a top block?
	jne	ck80		;skip if not

;if che=botblk & bge=fgi & fge=bgi then okay -- swap background and foreground
; else error
	cmp	byte ptr [si-2], 0DCh	;is entry a bottom block?
	jmp	ck45		;jump to common code
ck80:

;Display error screen
err10:	push	cs
	pop	ds

	or	ErrFlag, 02h		;flag 'Screen error'

	mov	ah, 02h			;position cursor to bottom center (34,23)
	xor	bx, bx			;page 0
	mov	dx, 23*256+34		;(80-12)/2 = 34
	int	10h

	mov	ah, 09h			;display error message
	mov	dx, offset ScnErr
	int	21h

;Flip Image and ENTRY.COM's screen displays until a key is struck
err20:	mov	cx, 9			;delay about 1/2 second
wait00:	push	es			;wait for next system timer interrupt
	push	0
	pop	es
	mov	al, es:[46Ch]		;read system timer byte
wait10:	cmp	al, es:[46Ch]		;wait for it to change
	je	short wait10
	pop	es
	loop	wait00

;ds:si = B800:0000		(swapped)
;es:di = ImageSeg:0
	xor	si, si
	xor	di, di
	push	ds
	push	0B800h
	pop	ds
	mov	cx, 80*25
swap10:	mov	ax, [si]		;swap hardware screen and Image
	mov	dx, es:[di]

	mov	[si], dx
	stosw				;es:[di++] := ax
	add	si, 2
	loop	swap10
	pop	ds

	mov	ah, 01h			;loop until key press
	int	16h
	je	err20

	mov	ah, 4Ch			;terminate ENTRY.COM
	int	21h			;(return to tester if error detected)

ck90:
	push	cs			;(return to ENTRY.COM if no error)
	pop	ds
	popa
	ret


ScnErr	db	'Screen error$'

ErrFlag	dw	0			;flag bits for each type of error
blink	db	0			;bit 3 set if blinking is enabled in H/W
					; = default for DOS; Windows varies
msgNo:	db	'No '
msgErr:	db	'Errors Detected', 0Dh, 0Ah, '$'
msg1	db	'Screen Error', 0Dh, 0Ah, '$'
msg4	db	'ENTRY.COM not found', 0Dh, 0Ah, '$'

EntryCom db	'ENTRY.COM', 0

bEpb	dw	0			;segment pointer to environment block
	dw	80h			;offset of command line tail
wCs1	dw	?			;segment of command line tail
	dw	5Ch			;offset of 1st FCB copied into new PSP
wCs2	dw	?			;segment of 1st FCB
	dw	6Ch			;offset of 2nd FCB copied into new PSP
wCs3	dw	?			;segment of 2nd FCB
	dw	$-bEpb

	align	16
Image	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,0DCh,00Eh,0DCh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh
	db	0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DCh,00Eh,0DCh,00Eh,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h
	db	0B0h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DCh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh
	db	0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DCh,00Eh
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h
	db	0B0h,006h,0B2h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0B2h,006h,0B2h,006h,0B0h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh
	db	0DBh,00Eh,0DBh,00Eh,0DFh,00Eh,0DFh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DCh,007h,0DCh,007h,0DCh,007h,0DCh,008h,0DCh,008h,0DCh,008h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h,0B1h,006h
	db	020h,006h,0B2h,006h,020h,006h,020h,006h,020h,006h,0B1h,006h,0B1h,006h,0B2h,006h
	db	020h,006h,020h,006h,020h,006h,0B1h,006h,0B0h,006h,020h,006h,020h,006h,020h,006h
	db	020h,006h,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DFh,00Eh,0DCh,00Eh,0DCh,00Eh,0DFh,00Eh
	db	020h,00Eh,0DCh,00Eh,0DBh,00Eh,0DBh,00Eh,0DCh,00Eh,0DBh,00Eh,0DBh,00Eh,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,0DCh,007h,0DCh,007h,020h,078h,020h,078h,0B0h,078h
	db	0B1h,078h,0B1h,078h,0DBh,008h,0DCh,008h,0DCh,008h,0DCh,008h,0DFh,008h,0DFh,008h
	db	0DBh,008h,0DCh,008h,0DCh,008h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B2h,006h,0B1h,006h
	db	0B0h,006h,0B1h,006h,0B1h,006h,020h,006h,0B0h,006h,0B1h,006h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DFh,00Eh,0DFh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh
	db	0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DBh,00Eh,0DFh,00Eh,0DFh,00Eh,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DCh,007h,020h,078h,0B0h,078h,0B1h,078h,0B1h,078h,0B1h,078h,0B2h,078h,0B2h,078h
	db	0DBh,008h,0B2h,078h,0DBh,078h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DCh,008h,0DCh,008h,0DFh,008h,0DFh,008h,0DBh,008h,0DCh,008h,020h,007h,020h,007h
	db	0B0h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h,0B2h,006h
	db	0B1h,006h,0B1h,006h,0B1h,006h,0B2h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,0B0h,006h,0B0h,006h,0B1h,006h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0DCh,00Fh,0DCh,00Fh,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,078h
	db	0DBh,007h,0B0h,078h,0B1h,078h,0B2h,078h,0DBh,008h,0B1h,078h,0DBh,008h,0B2h,078h
	db	0DBh,008h,0DBh,078h,0DBh,078h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DCh,008h,0DFh,008h,0DBh,008h,020h,007h
	db	0B0h,006h,0B1h,006h,020h,006h,020h,006h,0B1h,006h,0B0h,006h,0B1h,006h,0B2h,006h
	db	0B2h,006h,0B0h,006h,020h,006h,0B1h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0B0h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DCh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DCh,00Fh,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,078h
	db	0B0h,078h,0B1h,078h,0B2h,078h,0DBh,008h,0DBh,008h,0B2h,078h,0DBh,078h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,008h,020h,008h,0B0h,006h,0B0h,006h,0B1h,006h,020h,006h,0B0h,006h,0B1h,006h
	db	0DBh,006h,0B0h,006h,0B0h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,0DEh,00Fh,0DBh,00Fh,0DFh,00Fh,0DFh,00Fh,0DBh,00Fh,0DBh,00Fh,0DFh,00Fh
	db	0DFh,00Fh,0DBh,00Fh,0DBh,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,0DEh,078h
	db	0B0h,078h,0B1h,078h,0DBh,008h,0DBh,008h,0DBh,078h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,008h,0B0h,006h,0B1h,006h,020h,006h,020h,006h,020h,006h,0B0h,006h,0B1h,006h
	db	0DBh,006h,0B0h,006h,0B0h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DFh,00Fh,0DCh,00Fh,0DCh,00Fh,0DBh,00Fh,0DCh,00Fh,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,0DBh,00Fh,0DCh,00Fh,0DCh,00Fh,0DBh,00Fh,0DBh,00Fh,0DCh,00Fh,0DCh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,0DEh,078h
	db	0DBh,008h,0B1h,078h,0DBh,078h,0FEh,070h,052h,070h,065h,070h,073h,070h,074h,070h
	db	020h,070h,069h,070h,06Eh,070h,020h,070h,020h,070h,050h,070h,065h,070h,061h,070h
	db	063h,070h,065h,070h,0FEh,070h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	0B0h,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B2h,006h,0B1h,006h
	db	0B2h,006h,0B1h,006h,0B0h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DFh,00Fh,0DCh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DCh,00Fh
	db	0DCh,00Fh,0DCh,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,0DCh,00Fh,0DCh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DCh,00Fh,020h,00Fh,020h,00Fh,0DFh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,020h,00Fh,020h,00Fh,0DBh,008h
	db	0DBh,008h,0B2h,078h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B2h,006h,020h,006h
	db	0B2h,006h,0DBh,006h,0B1h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DFh,00Fh,020h,00Fh,020h,00Fh,020h,00Fh,0DFh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DCh,00Fh,0DCh,00Fh,020h,00Fh
	db	0DFh,008h,0DFh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h,020h,006h
	db	0B2h,006h,0DBh,006h,0B2h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0DCh,008h,0DCh,008h
	db	0DCh,008h,0DCh,008h,0DCh,008h,0DCh,008h,020h,008h,020h,008h,020h,008h,0DFh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh,0B1h,07Fh
	db	0DBh,007h,0DCh,007h,0DCh,007h,0DCh,007h,0DFh,008h,0DBh,008h,0DFh,008h,0DCh,007h
	db	0DFh,008h,0DFh,008h,0DCh,007h,020h,007h,0DFh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B1h,006h,0B2h,006h
	db	0DBh,006h,020h,006h,0B2h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,0DCh,008h,0DBh,008h,0DBh,008h,048h,00Eh,061h,00Eh
	db	070h,00Eh,070h,00Eh,079h,00Eh,0DBh,008h,0DBh,008h,0DBh,008h,0DCh,008h,020h,008h
	db	020h,008h,020h,008h,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh,0B1h,07Fh,0B0h,07Fh
	db	0DBh,007h,0DBh,007h,020h,078h,0B0h,078h,0B1h,078h,0DCh,007h,0DCh,007h,0DCh,007h
	db	0B0h,078h,0B0h,078h,0B1h,078h,0DCh,007h,0DFh,007h,0DCh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0DBh,006h,0B2h,006h
	db	0DBh,006h,0B0h,006h,0B2h,006h,0B2h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DBh,008h,0DBh,008h,048h,00Eh,061h,00Eh,06Ch,00Eh,06Ch,00Eh
	db	06Fh,00Eh,077h,00Eh,065h,00Eh,065h,00Eh,06Eh,00Eh,021h,00Eh,0DBh,008h,0DBh,008h
	db	020h,008h,020h,008h,020h,008h,0DFh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,07Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh,0B1h,07Fh
	db	0B0h,07Fh,0DBh,007h,0B0h,078h,0DBh,007h,0B0h,078h,0B0h,078h,0B0h,078h,0B1h,078h
	db	0B0h,078h,0B0h,078h,0B1h,078h,0DFh,007h,0DFh,007h,0DCh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B2h,006h,0B2h,006h,020h,006h
	db	0B0h,006h,0B1h,006h,0DBh,006h,0B2h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DBh,008h,0DBh,008h,0B1h,008h,0DBh,008h,0DBh,008h,0B2h,008h
	db	0B2h,008h,0DBh,008h,0B2h,008h,0DBh,008h,0DBh,008h,0B2h,008h,0DBh,008h,0B2h,008h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0DFh,00Fh,0DFh,00Fh,0B1h,07Fh
	db	0B1h,07Fh,0DBh,07Fh,0B2h,07Fh,0DBh,07Fh,0DBh,07Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh,0B1h,07Fh
	db	0B0h,07Fh,0DBh,007h,0DBh,007h,0B0h,078h,0B0h,078h,0B0h,078h,0DFh,007h,0DFh,007h
	db	020h,007h,0DCh,008h,0DCh,008h,0DCh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0DBh,006h,0B1h,006h,0B0h,006h
	db	020h,006h,0B1h,006h,0DBh,006h,0B2h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DBh,008h,0B2h,008h,0B0h,008h,0B2h,008h,0B2h,008h,0B1h,008h
	db	0B2h,008h,0DBh,008h,0B1h,008h,0B2h,008h,0DBh,008h,0B2h,008h,0DBh,008h,0B2h,008h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0DCh,008h,0DBh,008h,0DBh,008h,020h,008h
	db	0DBh,007h,0DBh,007h,0DBh,007h,0DFh,07Fh,0B1h,07Fh,0DBh,07Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh
	db	0B1h,07Fh,0B0h,07Fh,0DBh,007h,0DBh,007h,0DFh,007h,020h,007h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,0B2h,006h,020h,006h,0DBh,006h
	db	0B1h,006h,0B1h,006h,0DBh,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0B2h,008h,0B1h,008h,0B0h,008h,0B1h,008h,0B2h,008h,0B1h,008h
	db	0B1h,008h,0B2h,008h,0B0h,008h,0B2h,008h,0B2h,008h,0B1h,008h,0DBh,008h,0B1h,008h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0B2h,008h,0DBh,008h,0B2h,008h,0B1h,008h
	db	0DCh,008h,0DFh,007h,0DBh,007h,0DBh,007h,0B1h,07Fh,0DBh,07Fh,0DBh,07Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B2h,07Fh,0B1h,07Fh
	db	0DBh,007h,0DFh,007h,0DCh,008h,0DCh,008h,0DCh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0B2h,006h,0DBh,006h,020h,006h,0B1h,006h
	db	020h,006h,0B0h,006h,0B2h,006h,0B1h,006h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0B2h,008h,0B0h,008h,0B0h,008h,0B0h,008h,0B1h,008h,0B0h,008h
	db	0B1h,008h,0B1h,008h,0B0h,008h,0B1h,008h,0B1h,008h,0B1h,008h,0B2h,008h,0B1h,008h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0B1h,008h,0B2h,008h,0B1h,008h,0B0h,008h
	db	0B2h,008h,0B2h,008h,0DCh,008h,0DFh,007h,0B1h,07Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,07Fh,0B2h,07Fh
	db	0B1h,07Fh,0B0h,07Fh,0DCh,007h,0DCh,007h,0DCh,007h,020h,007h,0DFh,008h,0DFh,008h
	db	0DFh,008h,0DFh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h
	db	0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,008h,020h,008h,020h,008h,0B2h,006h,0DBh,006h,020h,006h,0B2h,006h,0B0h,006h
	db	0B0h,006h,0B0h,006h,0B2h,006h,0B0h,006h,0B0h,006h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0B1h,008h,0B0h,008h,020h,008h,0B0h,008h,0B0h,008h,0B0h,008h
	db	0B0h,008h,0B0h,008h,020h,008h,0B0h,008h,0B1h,008h,0B0h,008h,0B1h,008h,0B0h,008h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0B0h,008h,0B1h,008h,0B0h,008h,020h,008h
	db	0B1h,008h,0B1h,008h,0B1h,008h,0B1h,008h,020h,008h,0DFh,00Fh,0DFh,00Fh,0DBh,00Fh
	db	0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0DBh,00Fh,0B1h,07Fh
	db	0B0h,07Fh,020h,07Fh,0DBh,007h,0DBh,007h,020h,078h,020h,078h,0B0h,078h,0B0h,078h
	db	0B0h,078h,0B1h,078h,0DCh,007h,020h,007h,0DFh,008h,0DFh,008h,0DFh,008h,0DFh,008h
	db	0DFh,008h,0DFh,008h,0DBh,008h,0DBh,008h,0DBh,008h,0DDh,008h,0DBh,008h,020h,007h
	db	020h,008h,020h,008h,0B2h,006h,0B2h,006h,020h,006h,020h,006h,0B1h,006h,0B0h,006h
	db	0B0h,006h,020h,006h,0B2h,006h,0B1h,006h,0B0h,006h,0B0h,006h,020h,006h,020h,006h
	db	020h,006h,020h,006h,0B0h,008h,020h,008h,020h,008h,0B0h,008h,0B0h,008h,0B0h,008h
	db	020h,008h,0B0h,008h,020h,008h,0B0h,008h,0B0h,008h,020h,008h,0B0h,008h,0B0h,008h
	db	020h,008h,020h,008h,020h,008h,020h,008h,0B0h,008h,0B0h,008h,020h,008h,020h,008h
	db	0B1h,008h,0B0h,008h,0B0h,008h,0B0h,008h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,0DFh,00Fh,0DFh,00Fh,0DFh,00Fh,0DFh,00Fh,0DFh,00Fh,0DFh,007h
	db	0DBh,007h,0DBh,007h,0DBh,007h,0DBh,007h,0B0h,078h,0B0h,078h,0B0h,078h,0B0h,078h
	db	0B0h,078h,0DBh,007h,0B0h,078h,0B0h,078h,0B1h,078h,0B1h,078h,0DBh,007h,0DBh,007h
	db	0DBh,007h,0DCh,007h,0DCh,007h,0DCh,007h,020h,007h,020h,007h,0DFh,008h,020h,007h
	db	0DCh,006h,0B0h,006h,0B1h,006h,073h,060h,063h,060h,0B0h,006h,0B1h,006h,0B2h,006h
	db	0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0B0h,006h,0B0h,006h,0B0h,006h,0DCh,006h
	db	0DCh,006h,0DCh,006h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h
	db	0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h
	db	0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DFh,068h
	db	0DFh,068h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,006h,0DCh,076h
	db	0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h
	db	0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DCh,076h,0DFh,06Fh
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h,0DFh,006h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h
	db	020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h,020h,007h

cseg	ends
	end	start
