; -==========================================-
; Task     : Hugi Size Coding Competition #27
; Author   : Ang Chin Keong
; Country  : Malaysia
; Contact  : chinkeong81@gmail.com
; Date     : October 2008
; Compile  : ml /AT ENTRY.ASM
; -===[ http://www.hugi.scene.org/compo/ ]===-

.MODEL TINY
.586
.CODE
.STARTUP
        ORG     100H  
        
;        Assume CX = 00FFh. Uncomment when using DOS DEBUG.EXE which has CX = file size
;        XOR     CX, CX                 ; CH count number of bits left in stream.

        MOV     AL, 03H                 ; Clear Screen
        INT     10H
        
        PUSH    0B800H                  ; Point ES to Text  Video Buffer
        POP     ES

        MOV     BP, offset CHARDICT     ; BP = Pointer to Dictionary
        MOV     SI, offset CHARCMP      ; BP = Pointer to Compressed Data
        XOR     DI, DI                  ; Video Buffer start offset   = 0

MLoop:	             
        CALL    Get4Bit                 ; Read 4 bits of compressed Data

        MOV     CL, 1                   ; Initialize Run Length to 1
        		
        CMP     DL, 01100b              ; Is not a RLE marker?
        JB      OutScr                  ; is RAW data then Print It!
           
DeCmp:                                  ; Begin RLE decompression

        MOV     CL, 00000100B           ; Init startup up value for Extended RLE calculation
DelMark:
        AND     DL, 03H                 ; Delete the marker
        CALL    Get2Bit                  
            
        CMP     DL, 01110b              ; End of data marker?
        JE      EXIT
       
        SHL     CL,1                    ; Multiple Extended RLE Length by 2
        CMP     DL, 01100b              ; Maker for Extended RLE?
        JGE     DelMark                 ; .IF DL >= 01100b 
        
        AND     CL, 0F0H                ; Extended RLE is only at bit[4..7], the rest is junk
        ADD     CL, 003H                ; CL = Extended Runlength + Min length to trigger RLE

        MOV     AH, DL                  ; Save DL which contain the DATA to be repeated
        CALL    Get4Bit                 ; Load Run Length into DL
        ADD     CL, DL                  ; CL (Total Run Length) = Run Length + Extended Run Length
        MOV     DL, AH                  ; Restore DL which contain pointer to the dictionary data
        
OutScr:            
        MOV     BX, BP                  ; Make BX point to first byte of dictionary
        ADD     BL, DL                  ; Point to the data we want
        MOV     AL, [BX]                ; Get the translated CHR from dictionary into AL
            
@@:
        STOSB                           ; Short for: MOV ES:[DI], AL; INC DI
        INC     DI                      ; Skip the Colour or Character byte
        DEC     CL                      ; Reduce the Run Length
        JNZ     @B                      ; Print Next
            
        JMP     MLOOP                   ; Next Packet
               
Exit:   

        
        MOV     DI, 1
        MOV     BP, offset COLORDICT
        ;MOV     SI, offset COLORCMP
        ;MOV     CH, 0                  ; Reset bits left
        CMP     AL, 0DFh                ; Have we done colour?
        JE      MLOOP                   ; No, we just finish decompress characters
       
PrnText:
        DEC     CX                      ; Number of sentence = 3, assume CX = 4 at this point

@Sentence:
        LODSW                           ; Load (X,Y) pointer to video buffer into DI
        MOV     DI, AX

@Char:
        MOVSB                           ; Copy one character
        INC     DI                      ; Skip the colour byte
        CMP     BYTE PTR [SI+01], 0Ah   ; Char that is out of range is a stop marker.
        JA      @Char                   ; Next Char
        
        LOOP    @Sentence               ; Next sentence
              
        XOR     AX, AX                  ; Give user enough time to admire the image 
        INT     16H
        RET                             ; Happy Halloween, Bye!
       

;
; Dictionary
;
CHARDICT        DB 32,177,220,219,176,178,223,221,222,254,115,99
COLORDICT       DB 7,6,14,8,120,15,112,127,96,104,118,111

;
; RLE Encoded Data
;
CHARCMP         DB 193,71,13,34,205,200,191,13,20,195,11,59,47,195,5,23,3,85,76,11,55,102,204
                DB 124,23,35,195,68,65,112,1,21,192,5,48,28,193,136,152,8,204,140,252,4,136
                DB 1,4,79,32,102,50,44,33,69,4,65,7,3,28,9,155,53,102,195,200,19,16,85,53,204
                DB 200,153,140,128,19,2,21,196,20,112,68,65,240,50,44,24,208,84,196,215,57,38
                DB 48,65,0,20,21,84,1,28,33,48,226,204,203,3,65,83,53,207,28,240,4,65,4,19,68
                DB 31,10,131,102,51,102,51,192,97,7,204,28,192,16,112,4,19,68,28,37,136,140
                DB 176,147,34,51,34,204,112,8,49,62,116,205,204,19,2,81,81,65,194,88,179,44
                DB 131,1,34,204,72,1,179,32,3,53,243,7,60,17,65,76,71,9,108,1,188,212,136,25
                DB 188,193,207,4,16,83,81,193,242,60,1,188,205,68,242,6,54,38,98,6,205,92,240
                DB 65,83,5,28,16,179,114,192,60,193,69,12,193,7,32,68,18,98,205,28,240,67,83
                DB 69,92,15,59,192,27,63,81,67,67,208,5,16,89,139,52,115,192,213,65,4,215,3
                DB 51,19,53,83,83,53,53,192,153,132,77,115,133,20,51,208,25,131,32,205,156,240
                DB 51,20,1,53,192,205,81,84,84,197,77,77,112,18,51,12,193,135,55,81,67,54,12
                DB 241,207,3,80,49,19,28,13,69,5,68,85,21,68,199,1,83,81,38,51,28,217,68,219
                DB 32,207,92,240,37,48,16,69,28,13,116,1,65,20,196,20,112,17,81,69,82,97,205
                DB 212,83,32,13,135,56,115,192,84,193,116,5,68,192,133,3,66,4,20,20,192,80,80
                DB 49,16,102,205,69,0,204,3,64,18,13,143,48,115,192,21,64,5,16,20,81,48,20,0
                DB 208,1,1,16,17,48,20,64,1,208,48,61,143,49,208,141,16,71,48,200,0,24,9,6,173
                DB 5,114,29,3,32,194,252,145,155,200,255,219,190
COLORCMP        DB 193,71,13,202,255,13,17,195,50,223,195,49,12,15,16,192,178,223,8,204,48,223
                DB 16,202,252,15,66,205,176,140,87,3,28,11,41,240,13,16,209,51,128,1,192,177
                DB 76,19,16,240,53,92,21,3,64,52,52,52,76,228,49,172,32,112,237,87,2,208,76
                DB 209,51,208,51,197,252,43,91,208,12,211,63,3,198,48,157,75,9,214,208,209,54
                DB 220,196,7,2,196,240,159,92,51,79,50,193,49,60,39,215,124,211,4,196,240,124
                DB 219,213,29,240,28,192,12,192,51,140,19,19,193,51,12,139,52,245,13,192,3,64
                DB 192,52,0,12,223,4,196,240,51,60,159,50,212,223,89,220,1,3,68,0,205,240,60
                DB 83,3,206,240,37,93,207,86,220,0,52,12,3,59,192,241,76,15,204,240,13,195,86
                DB 220,48,28,251,3,197,48,63,52,192,55,13,81,220,3,204,131,49,197,112,63,54
                DB 7,213,183,28,7,62,12,195,23,192,188,227,87,220,0,52,48,12,224,12,241,223
                DB 55,192,245,44,11,66,13,7,5,48,196,34,49,172,47,197,38,113,62,182,255,199
                DB 126
;
; Not compressed VideoBufPtr and Text
;                               
RIP             DW 0578H
                DB 'Rest in  Peace'
HAPPY           DW 07ACH
                DB 'Happy'
HALLOWEEN       DW 0848H
                DB 'Halloween!'

;------------------------------------------------------------------
; Extract a number of bits
; ===============
; Input Parameter:
;     SI = Source of bits stream in memory
; Workign Registers:
;     DH = Bits queue
;     CH = Bits left in queue
; Output:
;     Get4Bit DL = [0..3] = Bits extracted, [4..7] = 0000b
;     Get2Bit DL = [0..1] = Bits extracted, [2..7] = Old [0..5]
;-------------------------------------------------------------------   

Get4Bit PROC    NEAR
        MOV     DL, 00H             ; Init to zero to have no junk in DL[4..7]
        CALL    Get2Bit
Get4Bit ENDP

Get2Bit PROC    NEAR
        
        ; If no more Bits left Then fill data from incoming stream
        OR      CH, CH              ; If CH == 0 ?
        JNE     @F        
        LODSB
        MOV     DH, AL 
        MOV     CH, 8               ;  Increase the number of bits
@@:
        
        ROL     DX, 2               ;  Extract the bits into DL
        SUB     CH, 2               ;  Reduce the number of bits left
                
        RET
Get2Bit ENDP  

                    
END                 
