; Hugi Compo #27
; Halloween 
; by Aphex - september-october 2008

; History:
;	Sep. 29		-	786 bytes 
;						first working version, basic idea: two layers 
;							1st layer - crunching
;							2nd layer - "Huffmanoid" codes 
;	Oct. 1		-   731 bytes								
;						dictionary reduced from 52 to 50
;						more crunching and decoding optimizations
;			
;	Oct. 2		-   718 bytes = 93 + 579 + 1 + 45		
;						dictionary reduced from 50 to 45
;						more crunching and decoding optimizations
;
; Compile: tasm /m entry
; Link: tlink /t/x entry
;
; Assumes: SI = 100h, BX = 0
;

DEBUG		equ 	0						; debug initialization
EOD			equ		0						; end of data marker 

			.386
			cseg	segment para public use16 'code'
			assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

			org		100h
start: 
							
			IF		DEBUG					; 17 extra bytes in debug
			xor		ax, ax
			xor		bx, bx
			mov		cx, 0FFh
			mov		dx, cs
			mov		di, sp
			mov 	si, 100h
			mov		bp, 91Eh				; 9xx actually, but word aligned
			ENDIF
			
											; decoding and drawing = 93 bytes
			
											; initialization = 7 bytes
			mov		si, offset CodedData	; si -> coded image
			mov		di, 0B800h				; di -> memory buffer
			push	di	
			
											; "Huffmanoid" decoding loop = 37 bytes
dataread:
			mov		cl, 8					; bit counter
decode:
			
			and		ah, byte ptr[si]		; if bit sequence is 01											
			jz		getbit

			bsf		bp, bx					; bp = number of 0s
			bsr		bx, bx					; bx = total number of bits
											;
											; the "Huffmanoid" codes are:
											; 10, 110, 100, 1110, 1100, 1000, ...
											; meaning 1 code of length 2, 
											; 2 codes of length 3,
											; 3 codes of length 4, etc.
											; hence the following decoding
			
			mov		ax, 0					; dummy, to skip add first time
			org		$-2
sum:
			add		bp, bx					; search in the dictionary 
			dec		bx
			jnz		sum
			mov		al, [bp+offset DictData-1]
			stosb							; extract coded character
getbit:
			shr		byte ptr[si], 1			; get current bit in CF 
			setnc	ah						; AH = !CF
			rcl		bx, 1					; store bit in the current code 
			loop	decode					; loop
			inc		si						; get next byte
			IF		EOD
			cmp		byte ptr[si], EOD		; EOD? 
			ELSE			
			cmp		byte ptr[si], ch			
			ENDIF
			jne		dataread
						
											; video initialization = 8 bytes
			int		10h						; clear screen	
			
			pop		si						; si -> memory buffer	
			push	ax						; AX = 3, save it		
															
			mov		es, si
			xor		di, di					; es:di -> video buffer											
											
											; uncrunching and drawing = 34 bytes
multioutput:
			dec		ax						; after this AL will be:
											; 29 >> 4 - 1 and PF = 1
											; 24 >> 4 - 1 and PF = 0
											; 3 - 1 and PF = 0
			
			lodsb							; read count							
			xchg	cl, al					; CL = count, AL = 0

			jp		output					; skip if displaying spaces 
			lodsb							; otherwise get character
output:
			db		0F3h					; rep
outputone:    
			stosw							; draw on screen			
			
next: 
			lodsb							; get next character
			cmp		al, 32					; if not a control character, jump	
			jnc		outputone
			cmp		al, 16					; if < 16, then jump change foreground
			jc		changecolor
			shl		al, 4					; if < 24 then change background
			js		multioutput				; otherwise jump
			xchg	al, ah
changecolor:
			and		ax, 0F00Fh				; strip off old attributes
			or		ah, al					; store attribute
			cmp		al, 3					; unused color, exit
			jne		next

											; wait a key, clean up and exit = 7 bytes
done: 
			cbw								; AH = 0
			int		16h						; wait for keystroke
			pop		ax				
			int		10h						; clean up
			
loadcode:
			
			ret								; exit to DOS



CodedData:									; 579 bytes
			db		163,111,113,12,238,194,79,119,241,231
			db		125,75,12,131,11,131,46,254,124,203
			db		196,55,147,56,12,194,79,231,84,69
			db		120,238,110,220,93,28,223,246,38,30
			db		219,196,99,137,207,160,58,119,231,93
			db		93,69,224,189,231,174,130,145,237,232
			db		238,206,233,46,14,190,89,182,151,197
			db		183,56,12,206,9,163,115,34,240,92
			db		193,200,182,153,230,168,170,187,115,186
			db		247,190,196,97,179,109,22,79,178,24
			db		24,238,98,60,21,140,108,90,115,132
			db		143,238,244,190,236,189,101,51,121,91
			db		28,36,142,55,92,85,93,28,130,241
			db		178,169,57,194,208,175,120,124,201,94
			db		86,178,136,225,95,231,212,57,21,159
			db		96,252,203,142,16,168,95,239,125,89
			db		60,178,146,197,199,112,238,186,248,232
			db		174,238,170,226,17,140,127,173,191,127
			db		126,120,248,239,128,247,193,128,247,62
			db		60,4,60,120,248,231,24,245,235,125
			db		137,195,108,150,197,199,112,174,170,187
			db		139,207,93,213,189,119,170,122,111,84
			db		48,71,8,212,175,120,190,121,211,22
			db		31,195,137,199,9,161,187,55,206,9
			db		129,250,21,207,183,55,205,226,103,132
			db		239,226,49,156,48,80,48,59,158,238
			db		110,156,206,115,227,156,231,222,56,97
			db		244,43,158,111,211,155,197,51,174,6
			db		63,2,2,4,8,96,84,23,143,33
			db		4,42,152,229,169,70,246,119,206,25
			db		201,142,231,206,184,240,244,43,158,175
			db		41,51,241,141,26,252,8,56,112,224
			db		129,1,30,30,6,252,49,42,30,195
			db		9,129,130,89,158,70,158,70,146,37
			db		59,158,115,198,133,167,95,241,125,51
			db		47,107,226,27,181,154,105,106,154,56
			db		12,231,4,91,19,14,154,229,169,145
			db		228,239,174,99,220,93,24,245,43,190
			db		175,229,173,137,111,52,153,217,180,105
			db		154,248,92,189,167,10,134,179,240,211
			db		44,199,83,231,141,48,244,43,190,111
			db		94,91,139,111,204,178,217,38,51,107
			db		241,153,102,247,156,10,134,133,81,179
			db		227,233,140,187,11,71,191,226,240,77
			db		111,47,179,248,198,36,89,182,108,155
			db		197,103,179,204,220,115,130,97,225,167
			db		89,142,231,238,222,8,159,19,14,250
			db		21,159,111,122,147,100,146,56,140,229
			db		133,67,94,150,37,62,89,222,182,189
			db		225,156,48,10,150,167,122,111,36,217
			db		241,220,27,225,59,213,175,120,124,51
			db		239,45,121,179,36,62,35,239,37,121
			db		121,201,75,226,147,188,183,36,241,13
			db		225,112,158,83,21,140,112,200,211,72
			db		182,227,169,238,238,189,113,222,119,217
			db		192,223,127,15,142,47,155,240,185,36
			db		119,23,131,16,220,192,56,231,47,124
			db		231,9,199,25,206,95,248,112,143

			db		EOD						; 1 byte

DictData:									; 45 bytes
			db		219,177,176,220,178,29,255,223,8,24
			db		6,7,16,15,23,221,4,3,5,14
			db		18,0,10,12,101,11,22,97,222,47
			db		72,80,99,108,110,112,115,254,33,82
			db		105,111,116,119,121
			
			cseg	ends	
			
			end		start
