\Crunch.XPL	31-Oct-2008	Boreal		loren.blaney@idcomm.com
\This reads in Image.asm, crunches it down, and outputs ImageX.asm, which
\ is then inserted into Entry.asm.

inc	C:\CXPL\CODESI;		\intrinsic code declarations
def	SizeOfInt = 2;		\number of bytes in an integer (2 or 4)

int	Inx,			\index into ImageX (typically points to end)
	;
char	Image(4000),		\original image data
	ImageX(4000),		\crunched image data
	ImageY(4000);		\shifted image data



proc	OpenOutFile(FN);	\Open file name for output
char	FN;	\file name string
int	H;	\handle
begin
H:= FOpen(FN, 1);
FSet(H, ^o);			\small buffer allows multiple files and it is
OpenO(3);			\ closed automatically when the program exits
end;	\OpenOutFile



proc	OpenInFile(FN);		\Open file name for input
char	FN;	\file name string
int	H;	\handle
begin
H:= FOpen(FN, 0);
FSet(H, ^i);			\small buffer allows multiple files
OpenI(3);
end;	\OpenInFile



proc	Hex1Out(Dev, N);	\Output a hex digit
int	Dev, N;
char	HexDigit;
begin
HexDigit:= "0123456789ABCDEF ";
ChOut(Dev, HexDigit(N & $0F));
end;	\Hex1Out



proc	Hex2Out(Dev, N);	\Output two hex digits (a byte)
int	Dev, N;
begin
Hex1Out(Dev, N>>4);
Hex1Out(Dev, N);
end;	\Hex2Out

\===============================================================================

proc	Huffman;		\Huffman Code Generator
def	BS=$08, Tab=$09, LF=$0A, CR=$0D, EOF=$1A, Sp=$20;
def	Nil=0;		\empty node

def	\Node\		\components of a node
	Link,		\pointer to next node in linked list (must be 1st)
	Freq,		\frequency of coded character usage
	Letter,		\character to be coded
	Left,		\pointer to left branch of the tree
	Right;		\pointer to the right branch of the tree

int	TopMem,		\top of usable memory
	Ram,		\pointer to allocated heap space
	Counters($100),	\array of letter frequencies in input file
	ListHeader,	\Huffman tree (initially a linked list)
	BufPtr,		\pointer to the next character position in OutBuf
	TotalBits;	\total number of bits to encode ImageX
def	BufMax=40;	\last element of OutBuf
char	OutBuf(BufMax+1); \special character output buffer used to show tree



proc	DumpBuf(Ch);	\Dump the output buffer to the output device
\Shows the Huffman code, the character and the number of occurrences
int	Ch;
int	I;
begin
Hex2Out(0, Ch);  ChOut(0, Tab);			\output ASCII code

IntOut(0, Counters(Ch));  ChOut(0, Tab);	\frequency

IntOut(0, BufPtr);  ChOut(0, Tab);		\number of bits
TotalBits:= TotalBits + BufPtr*Counters(Ch);

loop for I:= 0, BufMax do			\Huffman code
	[if I = BufPtr then quit else ChOut(0, OutBuf(I));
	if Rem(I/4) = 3 then ChOut(0, Sp)];
CrLf(0);
BufPtr:= BufPtr+1;	\compensate for backspace in TreeOut
end;	\DumpBuf



proc	BufOut(Ch);	\Store character into output buffer
int	Ch;
begin
if Ch = BS then		\handle backspace
	[if BufPtr > 0 then BufPtr:= BufPtr-1]
else	[OutBuf(BufPtr):= Ch;
	BufPtr:= BufPtr+1];
end;	\BufOut



proc	TreeOut(Pntr);	\Output the Huffman codes in tree form
int	Pntr;
begin
if Pntr(Right) = Nil then DumpBuf(Pntr(Letter))
else	begin
	BufOut(^0);
	TreeOut(Pntr(Right));	\recurse
	BufOut(BS);
	BufOut(^1);
	TreeOut(Pntr(Left));
	end;
BufOut(BS);
end;	\TreeOut

\-------------------------------------------------------------------------------

func	Allocate(Amount);
\Allocates the number of bytes of heap space contained in Amount.
\(Unlike the Reserve intrinsic this function does not relinquish
\ the reserved heap space when it returns.)
int	Amount;
int	Temp;
begin
Temp:= Ram;
Ram:= Ram + Amount;	\reserve bytes
if Ram > TopMem then
	[CrLf(0);  Text(0,"Out of memory");  exit];
return Temp;		\the address of the allocated space
end;	\Allocate

\-------------------------------------------------------------------------------

proc	MakeTree;	\Create a Huffman coding tree
int	Small, Pntr, Node;


proc	Smallest;	\Scan the linked list for the smallest letter frequency
\Outputs: Pntr - pointer to the node preceding the node with the smallest freq
\	  Small - the value of the smallest frequency
int	N;
begin
Small:= 32767;		\initialize at biggest
N:= addr ListHeader;	\the 1st time:  N(Link) = ListHeader
while N(Link) # Nil do	\follow the linkages
	begin
	if N(0,Freq) < Small then
		begin
		Small:= N(0,Freq);
		Pntr:= N;
		end;
	N:= N(Link);
	end;
end;	\Smallest


begin	\MakeTree
while ListHeader(0) # Nil do	\while two or more items in the linked list ...
	begin
	Smallest;		\find the smallest frequency in the list
	Node:= Allocate(5*SizeOfInt);	\make a new node
	Node(Left):= Pntr(0);		\point to it
	Node(Freq):= Small;
	Pntr(0):= Pntr(0,0);	\remove the smallest node from list

	Smallest;		\do the same thing for the right branch
	Node(Right):= Pntr(0);
	\The new node's frequency is sum of two smallest frequencies
	Node(Freq):= Node(Freq) + Small;
	Pntr(0):= Pntr(0,0);
	Node(Link):= ListHeader; \insert new node at head of list
	ListHeader:= Node;
	end;
end;	\MakeTree

\-------------------------------------------------------------------------------

proc	MakeLeaves;	\Convert Counters (> 0) into a linked list
int	I, N;
begin
ListHeader:= Nil;
for I:= 0, $FF do if Counters(I) > 0 then
	begin
	N:= Allocate(5*SizeOfInt);	\make a new entry
	N(Link):= ListHeader;		\insert it into the linked list
	ListHeader:= N;
	N(Freq):= Counters(I);
	N(Letter):= I;
	N(Left):= Nil;
	N(Right):= Nil;
	end;
end;	\MakeLeaves



proc	CountChars;	\Count occurrences of each byte in ImageX
\Input: ImageX, Inx
\Output: Counters
int	I, C;
begin
for I:= 0, $FF do Counters(I):= 0;		\initialize counters
for I:= 0, Inx-1 do
	begin
	C:= ImageX(I);
	Counters(C):= Counters(C)+1;
	end;
end;	\CountChars



begin	\Huffman
Ram:= Reserve(10000);		\reserve memory for tree and lists
TopMem:= Reserve(0) - 10;	\pointer to top of usable memory

CountChars;
MakeLeaves;
MakeTree;

TotalBits:= 0;
BufPtr:= 0;			\initialize special buffer pointer
CrLf(0);
TreeOut(ListHeader);
Text(0, "
Total bits  = "); IntOut(0, TotalBits); CrLf(0);
Text(0, "Total chars = "); IntOut(0, Inx); CrLf(0);
Text(0, "Compression = ");
Format(1,1); RlOut(0, Float(TotalBits)*100./8. / Float(Inx));
Text(0, "%
");
end;	\Huffman

\===============================================================================

proc	ShowCounts;		\Show the counts of each byte in ImageX
int	I, C, A(256);
begin
for I:= 0, 256-1 do A(I):= 0;
for I:= 0, Inx-1 do
	begin
	C:= ImageX(I);
	A(C):= A(C)+1;
	end;
\Output results
CrLf(0);
for I:= 0, 256-1 do
    if A(I) then
	begin
	Hex2Out(0, I);
	Text(0, ": ");
	IntOut(0, A(I));
	ChOut(0, ^	);
	end;
CrLf(0);
end;	\ShowCounts



proc	Bin2Asm;		\Output ImageY (binary) as a .asm file
int	I;
begin
I:= 0;
repeat	if (I&$0F) = 0 then
		begin
		CrLf(3);
		Text(3, "	db	");
		end;
	ChOut(3, ^0);
	Hex2Out(3, ImageY(I));
	ChOut(3, ^h);
	if (I&$0F) # $0F then ChOut(3, ^,);
	I:= I+1;
until I >= Inx;
CrLf(3);
end;	\Bin2Asm



proc	Shift;			\Shift ImageX data into ImageY data
int	I, B;			\Shift 8 bits down into 7 bits
int	PCnt, PInx, PByte;	\put variables
int	GCnt, GInx, GByte;	\get variables

	proc	PutBit(PBit);	\Put sequential bits into ArrayY
	int	PBit;		\0 or 1
	begin
	PByte:= PByte<<1 + PBit;
	PCnt:= PCnt+1 & 7;
	if PCnt = 0 then
		begin
		ImageY(PInx):= PByte;
		PInx:= PInx+1;
		end;
	end;	\PutBit


	func	GetBit;		\Get sequential bits from ImageX
	int	GBit;		\0 or 1
	begin
	if GCnt = 0 then
		begin
		GByte:= ImageX(GInx);
		GInx:= GInx+1;
		end;
	GBit:= if GByte & $80 then 1 else 0;
	GCnt:= GCnt+1 & 7;
	GByte:= GByte << 1;
	return GBit;
	end;	\GetBit

begin	\Shift
GInx:= 0;  GCnt:= 0;		\init GetBit
PInx:= 0;  PCnt:= 0;		\init PutBit
for I:= 0, Inx*8-1 do		\for all of the bits in ImageX ...
	begin
	B:= GetBit;
	if I&7 then PutBit(B);
	end;
\if PCnt # 0 then		\\close PutBit
\	begin
\	ImageY(PInx):= PByte;
\	PInx:= PInx+1;
\	end;
Inx:= PInx;			\new size
end;	\Shift

\-------------------------------------------------------------------------------

proc	Output(Byte);		\Write sequential bytes to ImageX array
int	Byte;
begin
if Inx >= 4000 then
	begin
	Text(0, "Error: More than 4000 bytes
");
	exit;
	end;
ImageX(Inx):= Byte;
Inx:= Inx+1;
end;	\Output



proc	RLE;			\Run Length Encode
\ 01..0F spaces ($20)
\ 11..1F blocks ($DB)
\ 22..2F attribute in range 02..0F
\ 30..3F bottom blocks ($DC)
\ 40..42 characters B0..B2
\ 43..45 characters DD..DF
\ 46	 character FE
\ 47	 attribute follows, not in range 02..0F
\ 7E	 end marker
\ others are characters

int	I, A, A0, A1, C, C0, C1, Cnt;

	proc	OutAttrib(AA);		\Output attribute command
	int	AA;
	begin
	if AA # A0 then
		begin
		if AA>=$02 & AA<=$0F then Output($20+AA)	\$22..$2F
		else	[Output($47); Output(AA)];		\$47, $xx
		A0:= AA;
		end;
	end;	\OutAttrib

begin
Inx:= 0;
A0:= $07;
for I:= 0, 21*80-1 do		\index by WORDS; only 21 lines needed
	begin
	C:= Image(I*2);
	A:= Image(I*2+1);
	OutAttrib(A);

	if C = $20 then
		\Count up to 16 consecutive spaces and output the count
		\ (make sure background doesn't change)
		begin
		Cnt:= 1;
		loop	begin
			I:= I+1;
			C1:= Image(I*2);	\get next character
			A1:= Image(I*2+1);
			if C1#C ! (A1&$F0)#(A0&$F0) ! Cnt>=16 then
				begin
				Output(Cnt-1);			\$01..$0F
				I:= I-1;			\backup
				quit;
				end;
			Cnt:= Cnt+1;
			end;
		end
cond false	\only worth 12 bytes -- debug
	else if C = $B0 then
		\count up to 7 consecutive bottom blocks and output the count + $38
		\ (make sure background doesn't change)
		begin
		Cnt:= 1;
		loop	begin
			I:= I+1;
			C1:= Image(I*2);	\get next character
			A1:= Image(I*2+1);
			if C1#C ! A1#A0 ! Cnt>=\16\8 then
				begin
				Output($38+Cnt-1);		\$39..$3F
				I:= I-1;
				quit;
				end;
			Cnt:= Cnt+1;
			end;
		end
cond true
	else if C = $DB then
		\Count up to 15 consecutive blocks and output the count + $10
		\ (make sure background doesn't change)
		begin
		Cnt:= 1;
		loop	begin
			I:= I+1;
			C1:= Image(I*2);	\get next character
			A1:= Image(I*2+1);
			if C1#C ! (A1&$0F)#(A0&$0F) ! Cnt>=16 then
				begin
				Output($10+Cnt-1);		\$11..$1F
				I:= I-1;
				quit;
				end;
			Cnt:= Cnt+1;
			end;
		end
	else if C = $DC then	\worth 44 bytes
		\Count up to 15 consecutive bottom blocks and output the count + $30
		\ (make sure background doesn't change)
		begin
		Cnt:= 1;
		loop	begin
			I:= I+1;
			C1:= Image(I*2);	\get next character
			A1:= Image(I*2+1);
			if C1#C ! A1#A0 ! Cnt>=16 then
				begin
				Output($30+Cnt-1);		\$31..$3F
				I:= I-1;
				quit;
				end;
			Cnt:= Cnt+1;
			end;
		end
	else if C>=$B0 & C<=$B2 then
		Output(C-$B0+$40)				\$40..$42
	else if C>=$DD & C<=$DF then
		Output(C-$DD+$43)				\$43..$45
	else if C = $FE then
		Output($46)					\$46
	else	Output(C);					\others
	end;
Output($7E);							\end marker
Output($7E);							\pusher
end;	\RLE



proc	Streamline;		\Filter out unnecessary changes in attributes
int	I, A, C, A0;
begin
A0:= $07;
for I:= 0, 2000-1 do			\for all of the words in Image
	begin
	C:= Image(I*2);			\char
	A:= Image(I*2+1);		\attrib
	if C = $20 \space\ then
		begin
		A:= A & $F0;		\strip off unnecessary foreground color
		A:= A ! ($0F & A0);	\put on previous foreground color
		\A:= A0;	\\attrib doesn't matter
		end;
	if C = $DB then
		begin
		A:= A & $0F;		\strip off unnecessary backegroung color
		A:= A ! ($F0 & A0);	\put on previous background color
		end;
	Image(I*2):= C;
	Image(I*2+1):= A;
	A0:= A;
	end;
end;	\Streamline



proc	Crunch;
int	I, T;
begin
\Read in image.asm file and convert it to binary in Image array
for I:= 0, 4000-1 do
	begin
	if (I & $0F) = 0 then T:= HexIn(3);
	\skip the "db" (which looks like a hex number)
	Image(I):= HexIn(3);
	end;

Text(0, "Converting...
");
Streamline;
RLE;
Text(0, "Size = "); IntOut(0, Inx); CrLf(0);

Shift;
Text(0, "Size = "); IntOut(0, Inx); CrLf(0);

Bin2Asm;	\output ImageY (binary) as a .asm file
end;	\Crunch

\-------------------------------------------------------------------------------

begin	\Main
OpenInFile("Image.asm");
OpenOutFile("ImageX.asm");
Crunch;
ShowCounts;
\Huffman;
end;	\Main
