;Event:   27th Hugi Size Coding Compo
;Author:  Akos Fekete (alias: Chut or akosf)
;Country: Hungary
;E-mail:  fekete.akos@freemail.hu
;Compiler:Flat Assembler

		ORG	100h

_BG		EQU	006h
_BL		EQU	007h
_BD		EQU	008h
_BY		EQU	00Eh
_BW		EQU	00Fh
_GB		EQU	060h
_GD		EQU	068h
_GW		EQU	06Fh
_LB		EQU	070h
_LG		EQU	076h
_LD		EQU	078h
_LW		EQU	07Fh

_A		EQU	020h
_B		EQU	021h
_C		EQU	048h
_D		EQU	050h
_E		EQU	052h
_F		EQU	061h
_G		EQU	063h
_H		EQU	065h
_I		EQU	069h
_J		EQU	06Ch
_K		EQU	06Eh
_L		EQU	06Fh
_M		EQU	070h
_N		EQU	073h
_O		EQU	074h
_P		EQU	077h
_Q		EQU	079h
_R		EQU	0B0h
_S		EQU	0B1h
_T		EQU	0B2h
_U		EQU	0DBh
_V		EQU	0DCh
_W		EQU	0DDh
_X		EQU	0DEh
_Y		EQU	0DFh
_Z		EQU	0FEh

		MOV	AX,0003h	;
		INT	10h		;
					;
		XOR	BP,BP		;
		MOV	DI,CMPRSD	;
					;
		MOV	SI,CMDS 	;
GET_NEW_CMD:	LODSW			;LOAD NEW COMMAND
		PUSHA			;
		INT	29h		;
		POPA			;
		INC	WORD[CCNTR]	;
		CMP	AL,'F'		;
		JE	CMD_COLOR_FIRST ;
		CMP	AL,'N'		;
		JE	CMD_CHAR	;
		CMP	AL,'X'		;
		JE	CMD_COLOR	;
		CMP	AL,'C'		;
		JE	CMD_COPY	;
		CMP	AL,'Q'		;
		JE	CMD_QUIT	;
PRINT_ERROR:	MOV	AX,0900h	;
		MOV	DX,TXTE 	;
		INT	21h		;
		RET			;
					;
		;-----------------------;
					;
CMD_COLOR_FIRST:CALL	BIT0		;N/X bit
		CALL	PACK_COLOR	;
		MOV	WORD[LBP],BP	;
		JMP	GET_NEW_CMD	;
					;
CMD_COLOR:	CALL	BIT1		;CODE1
		CALL	BIT1		;CODE2
		CALL	BIT1		;CODE3
		CALL	BIT0		;N/X bit
		CALL	PACK_COLOR	;
		MOV	WORD[LBP],BP	;
		JMP	GET_NEW_CMD	;
					;
CMD_CHAR:	CALL	PACK_CHAR	;
		MOV	WORD[LBP],BP	;
		JMP	GET_NEW_CMD	;
					;
CMD_COPY:	CALL	PACK_COPY	;
		MOV	WORD[LBP],BP	;
		JMP	GET_NEW_CMD	;
					;
CMD_QUIT:	CALL	BIT1		;CODE1
		CALL	BIT1		;CODE2
		CALL	BIT1		;CODE3
		CALL	BIT0		;N/X bit
		CALL	BIT0		;COLOR1
		CALL	BIT0		;COLOR2
		CALL	BIT0		;COLOR3
		CALL	BIT0		;COLOR4
		MOV	WORD[LBP],BP	;
		JMP	END_OF_CODING	;
					;
		;-----------------------;
					;
PACK_COLOR:	LODSW			;
		MOV	BX,0		;
PACK_COLOR0:	CMP	AL,[TABLE_COLORS+BX]
		LEA	BX,[BX+1]	;
		JNE	PACK_COLOR0	;
		MOV	CX,0008h	;
PACK_COLOR1:	TEST	BX,CX		;COLOR bit
		CALL	BITZ		;
		SHR	CX,1		;
		JNZ	PACK_COLOR1	;
		RET			;
					;
		;-----------------------;
					;
PACK_CHAR:	LODSW			;
		MOV	BX,0		;
PACK_CHAR0:	CMP	AL,[TABLE_CHARS+BX]
		JE	PACK_CHAR2	;
		INC	BX		;
		CMP	BX,7		;
		JB	PACK_CHAR0	;
		CALL	BIT1		;CODE1
		CALL	BIT1		;CODE2
		CALL	BIT1		;CODE3
		CALL	BIT1		;N/X bit
		MOV	CX,0080h	;
PACK_CHAR1:	TEST	AL,CL		;
		CALL	BITZ		;CODE1..8
		SHR	CX,1		;
		JNZ	PACK_CHAR1	;
		RET			;
PACK_CHAR2:	MOV	CX,0004h	;
PACK_CHAR3:	TEST	BL,CL		;
		CALL	BITZ		;CODE1..3
		SHR	CX,1		;
		JNZ	PACK_CHAR3	;
		CALL	BIT0		;N/C bit
		RET			;
					;
		;-----------------------;
					;
PACK_COPY:	LODSW			;
		MOV	BX,0		;
PACK_COPY0:	CMP	AL,[TABLE_OFFSETS+BX]
		JE	PACK_COPY1	;
		INC	BX		;
		CMP	BX,7		;
		JB	PACK_COPY0	;
		JMP	PRINT_ERROR	;
PACK_COPY1:	MOV	CX,0004h	;
PACK_COPY2:	TEST	BL,CL		;
		CALL	BITZ		;CODE1..3
		SHR	CX,1		;
		JNZ	PACK_COPY2	;
		CALL	BIT1		;N/C bit
		CMP	AX,2		;
		JB	PRINT_ERROR	;
		LODSW			;
		MOV	BX,8000h	;
PACK_COPY3:	SHR	BX,1		;
		TEST	AX,BX		;
		JZ	PACK_COPY3	;
		SHR	BX,1		;
		JMP	PACK_COPY5	;
PACK_COPY4:	CALL	BIT1		;SIZE: more
PACK_COPY5:	TEST	AX,BX		;
		CALL	BITZ		;SIZE bit
		SHR	BX,1		;
		JNZ	PACK_COPY4	;
		CALL	BIT0		;SIZE: end
		RET			;
					;
		;-----------------------;
					;
BITC:		JC	BIT1		;
BIT0:		PUSHA			;
		MOV	AL,'0'		;
		INT	29h		;
		POPA			;
		BTR	WORD[DI],BP	;
		JMP	BIT_INC_POINTER ;
BITZ:		JZ	BIT0		;
BIT1:		PUSHA			;
		MOV	AL,'1'		;
		INT	29h		;
		POPA			;
		BTS	WORD[DI],BP	;
BIT_INC_POINTER:INC	BP		;
		RET			;
					;
		;-----------------------;
					;
END_OF_CODING:	MOV	AX,3C00h	;CREATE 'PACKED.BIN'
		XOR	CX,CX		;
		MOV	DX,FILEN	;
		INT	21h		;
		MOV	BX,AX		;SAVE DATA STREAM TO FILE
		MOV	AX,4000h	;
		MOV	CX,7		;
		ADD	CX,BP		;
		SHR	CX,3		;
		MOV	DX,CMPRSD	;
		INT	21h		;
		MOV	AX,3E00h	;CLOSE FILE
		INT	21h		;
		MOV	AX,0900h	;PRINT OUT SOME INFOS
		MOV	DX,TXT1 	;
		INT	21h		;
		MOV	AX,[CCNTR]	;
		CALL	PRINTAX 	;
		MOV	AX,0900h	;
		MOV	DX,TXT2 	;
		INT	21h		;
		MOV	AX,[LBP]	;
		CALL	PRINTAX 	;
		RET			;
					;
		;-----------------------;
					;
PRINTAX:	PUSHA			;
		MOV	DX,AX		;
		MOV	CX,4		;
		MOV	BX,HTABLE	;
PRNAXC: 	ROL	DX,4		;
		MOV	AL,DL		;
		AND	AL,0Fh		;
		XLATB			;
		INT	29h		;
		LOOP	PRNAXC		;
		POPA			;
		RET			;
					;
;---------------------------------------;
					;
TXT1:	DB	13,10,'NUM OF COMMANDS: $'
TXT2:	DB	13,10,'COMPRESSED SIZE: $'
TXTE:	DB	13,10,'ERROR!$' 	;
CCNTR:	DW	0			;
LBP:	DW	0			;
HTABLE: DB	'0123456789ABCDEF'	;
FILEN:	DB	'PACKED.BIN',0		;
					;
;---------------------------------------;
					;
TABLE_CHARS:	DB 0DFh,0B0h,0B1h,0B2h,0DBh,0DCh,020h
TABLE_COLORS:	DB 070h,007h,008h,00Eh,00Fh,068h,06Fh,006h,076h,078h,07Fh,060h
TABLE_OFFSETS:	DB -80,-6,-77,-81,-1,-83,-79,-7
					;
;---------------------------------------;
CMDS:	;LINE:01
	DW	'F ',_BG	;BG?
	DW	'N ',_A 	;BGA 1  A
	DW	'C ',-1,7	;BGA 7  AAAAAAA
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_A 	;BGA 1  A
	DW	'C ',-1,15	;BGA 15 AAAAAAAAAAAAAAA
	DW	'X ',_BY	;BYA
	DW	'N ',_V 	;BYV 1  V
	DW	'N ',_V 	;BYV 1  V
	DW	'N ',_U 	;BYU 1  U
	DW	'C ',-1,9	;BYU 9  UUUUUUUUU
	DW	'N ',_V 	;BYV 1  V
	DW	'N ',_V 	;BYV 1  V
	DW	'X ',_BG	;BGV
	DW	'N ',_A 	;BGA 1  A
	DW	'C ',-1,47	;BGA 47 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
	;LINE:02
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-79,16	;BYV 16 AAAAAAAAAAAAAAAV
	DW	'N ',_U 	;BYU 1  U
	DW	'C ',-1,13	;BYU 13 UUUUUUUUUUUUU
	DW	'C ',-81,47	;BGA 47 VAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
	;LINE:03
	DW	'C ',-80,3	;BGR 3  ASR
	DW	'N ',_T 	;BGT 1  T
	DW	'C ',-80,6	;BGA 6  AAAAAA
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-80,5	;BGA 5  AAAAA
	DW	'C ',-79,10	;BYU 10 UUUUUUUUUU
	DW	'N ',_Y 	;BYY 1  Y
	DW	'N ',_Y 	;BYY 1  Y
	DW	'C ',-81,4	;BYU 4  UUUU
	DW	'X ',_BL	;BLU
	DW	'N ',_A 	;BLA 1  A
	DW	'C ',-1,23	;BLA 23 AAAAAAAAAAAAAAAAAAAAAAAAA
	DW	'N ',_V 	;BLV 1  V
	DW	'C ',-1,2	;BLV 2  VV
	DW	'X ',_BD	;BDV
	DW	'N ',_V 	;BDV 1
	DW	'C ',-1,2	;BDV 2  VV
	DW	'C ',-79,17	;BGS 17 AAAAAAAAAAAAAAAAS
	;LINE:04
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_A 	;BGA 1  A
	DW	'C ',-80,4	;BGA 4  TAAA
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-6,5	;BGS 5  TAAAS
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-81,7	;BYU 7  AAAAUUU
	DW	'N ',_Y 	;BYY 1  Y
	DW	'N ',_V 	;BYV 1  V
	DW	'N ',_V 	;BYV 1  V
	DW	'N ',_Y 	;BYY 1  Y
	DW	'N ',_A 	;BYA 1  A
	DW	'N ',_V 	;BYV 1  V
	DW	'C ',-83,2	;BYU 2  UU
	DW	'N ',_V 	;BYV 1  V
	DW	'C ',-79,22	;BLA 22 UUAAAAAAAAAAAAAAAAAAAA
	DW	'N ',_V 	;BLV 1  V
	DW	'N ',_V 	;BLV 1  V
	DW	'X ',_LD	;LDV
	DW	'N ',_A 	;LDA 1  A
	DW	'N ',_A 	;LDA 1  A
	DW	'N ',_R 	;LDR 1  R
	DW	'N ',_S 	;LDS 1  S
	DW	'N ',_S 	;LDS 1  S
	DW	'N ',_U 	;LDU 1  U
	DW	'C ',-80,3	;BDV 3  VVV
	DW	'N ',_Y 	;BDY 1  Y
	DW	'N ',_Y 	;BDY 1  Y
	DW	'C ',-6,3	;BDV 3  UVV
	DW	'C ',-80,11	;BGA 11 AAAAAAAAAAA
	;LINE:05
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-83,3	;BGA 3  SSA
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_A 	;BGA 1  A
	DW	'C ',-1,5	;BGA 5  AAAAA
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-6,5	;BGA 5  AAAAA
	DW	'X ',_BY	;BYA
	DW	'N ',_Y 	;BYY 1  Y
	DW	'N ',_Y 	;BYY 1  Y
	DW	'N ',_U 	;BYU 1  U
	DW	'C ',-1,7	;BYU 7  UUUUUUU
	DW	'N ',_Y 	;BYY 1  Y
	DW	'N ',_Y 	;BYY 1  Y
	DW	'C ',-77,19	;BLV 19 AAAAAAAAAAAAAAAAAAV
	DW	'X ',_LD	;LDV
	DW	'N ',_A 	;LDA 1  A
	DW	'N ',_R 	;LDR 1  R
	DW	'N ',_S 	;LDS 1  S
	DW	'C ',-1,2	;LDS 2  SS
	DW	'N ',_T 	;LDT 1  T
	DW	'N ',_T 	;LDT 1  T
	DW	'N ',_U 	;LDU 1  U
	DW	'N ',_T 	;LDT 1  T
	DW	'N ',_U 	;LDU 1  U
	DW	'C ',-1,5	;LDU 5  UUUUU
	DW	'C ',-79,2	;BDV 2  VV
	DW	'N ',_Y 	;BDY 1  Y
	DW	'N ',_Y 	;BDY 1  Y
	DW	'N ',_U 	;BDU 1  U
	DW	'C ',-83,3	;BGA 3  VAA
	;LINE:06
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-80,5	;BGA 5  AAAAA
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-81,2	;BGS 2  TS
	DW	'C ',-80,2	;BGS 2  SS
	DW	'N ',_T 	;BGT 1  T
	DW	'C ',-79,2	;BGA 2  SA
	DW	'C ',-80,6	;BGA 6  AAAAAA
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_S 	;BGS 1  S
	DW	'X ',_BW	;BWR
	DW	'N ',_A 	;BWA 1  A
	DW	'C ',-1,21	;BWA 21 AAAAAAAAAAAAAAAAAAAAA
	DW	'N ',_V 	;BWV 1  V
	DW	'N ',_V 	;BWV 1  V
	DW	'C ',-80,8	;BLA 8  AAAAAAAA
	DW	'X ',_LD	;LDV
	DW	'N ',_A 	;LDA 1  A
	DW	'C ',-79,3	;LDS 3  ARS
	DW	'N ',_T 	;LDT 1  T
	DW	'N ',_U 	;LDU 1  U
	DW	'N ',_S 	;LDS 1  S
	DW	'N ',_U 	;LDU 1  U
	DW	'N ',_T 	;LDU 1  U
	DW	'X ',_BD	;BDU
	DW	'N ',_U 	;BDU 1  U
	DW	'C ',-1,11	;BDU 11 UUUUUUUUUUU
	DW	'N ',_V 	;BDV 1  V
	DW	'N ',_Y 	;BDV 1  Y
	DW	'N ',_U 	;BDU 1  U
	DW	'C ',-80,2	;BGR 2  AR
	;LINE:07
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-80,2	;BGA 2  AA
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-80,2	;BGT 2  ST
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_A 	;BGA 1  A
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-80,3	;BGA 3  SAA
	DW	'C ',-1,9	;BGA 9  AAAAAAAAA
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-77,18	;BWV 18 AAAAAAAAAAAAAAAAAV
	DW	'N ',_U 	;BWU 1  U
	DW	'C ',-1,5	;BWU 5  UUUUU
	DW	'C ',-83,6	;LDA 6  VAAAAA
	DW	'C ',-79,5	;LDU 5  ARSTU
	DW	'N ',_U 	;LDU 1  U
	DW	'N ',_T 	;LDT 1  T
	DW	'C ',-77,3	;BDU 3  UUU
	DW	'C ',-1,12	;BDU 12 UUUUUUUUUUUU
	DW	'N ',_W 	;BDW 1  W
	DW	'C ',-80,2	;BGA 2  UA
	;LINE:08
	DW	'C ',-1,2	;BGA 2  AA
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-83,3	;BGA 3  RSA
	DW	'C ',-81,2	;BGS 2  RS
	DW	'N ',_U 	;BGU 1  U
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-79,12	;BGA 12 SAAAAAAAAAAA
	DW	'C ',-77,15	;BWA 15 AAAAAAAAAAAAAAAA
	DW	'C ',-1,3	;BWA 3  AAA
	DW	'N ',_X 	;BWX 1  X
	DW	'N ',_U 	;BWU 1  U
	DW	'N ',_Y 	;BWY 1  Y
	DW	'N ',_Y 	;BWY 1  Y
	DW	'C ',-80,2	;BWU 2  UU
	DW	'N ',_Y 	;BWY 1  Y
	DW	'N ',_Y 	;BWY 1  Y
	DW	'C ',-83,2	;BWU 2  UU
	DW	'C ',-80,4	;BLA 4  AAAA
	DW	'X ',_LD	;LDA
	DW	'N ',_X 	;LDX 1  X
	DW	'C ',-80,2	;LDS 2  RS
	DW	'C ',-79,2	;LDU 2  UU
	DW	'C ',-1,15	;LDU 15 UUUUUUUUUUUUUUU
	DW	'C ',-80,6	;BGA 6  UUWUAA
	;LINE:09
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-83,2	;BGA 2  AA
	DW	'C ',-80,19	;BWA 19 ARSURRSAAAAAAAAAAAA
	DW	'N ',_Y 	;BWY 1  Y
	DW	'N ',_V 	;BWV 1  V
	DW	'N ',_V 	;BWV 1  V
	DW	'N ',_U 	;BWU 1  U
	DW	'N ',_V 	;BWV 1  V
	DW	'C ',-80,12	;BWA 12 AAAAAAAAAAAA
	DW	'N ',_U 	;BWU 1  U
	DW	'N ',_V 	;BWV 1  V
	DW	'N ',_V 	;BWV 1  V
	DW	'C ',-79,2	;BWU 2  UU
	DW	'N ',_V 	;BWV 1  V
	DW	'N ',_V 	;BWV 1  V
	DW	'N ',_U 	;BWU 1  U
	DW	'C ',-1,3	;BWU 3  UUU
	DW	'C ',-80,4	;LDX 4  AAAX
	DW	'N ',_U 	;LDU 1  U
	DW	'C ',-80,2	;LDU 2  SU
	DW	'X ',_LB	;LBU
	DW	'N ',_Z 	;LBZ 1  Z
	DW	'N ',_E 	;LBE 1  E
	DW	'N ',_H 	;LBH 1  H
	DW	'N ',_N 	;LBN 1  N
	DW	'N ',_O 	;LBO 1  O
	DW	'N ',_A 	;LBA 1  A
	DW	'N ',_I 	;LBI 1  I
	DW	'N ',_K 	;LBK 1  K
	DW	'N ',_A 	;LBA 1  A
	DW	'N ',_A 	;LBA 1  A
	DW	'N ',_D 	;LBD 1  D
	DW	'N ',_H 	;LBH 1  H
	DW	'N ',_F 	;LBF 1  F
	DW	'N ',_G 	;LBG 1  G
	DW	'N ',_H 	;LBH 1  H
	DW	'N ',_Z 	;LBZ 1  Z
	DW	'C ',-80,5	;BGA 5  UUWUA
	;LINE:10
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_A 	;BGA 1  A
	DW	'C ',-1,4	;BGA 4  AAAA
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-80,16	;BWV 16 RSAAAAAAAAAAAYV
	DW	'N ',_U 	;BWU 1  U
	DW	'C ',-1,4	;BWU 4  UUUU
	DW	'N ',_V 	;BWV 1  V
	DW	'C ',-1,2	;BWV 2  VV
	DW	'C ',-80,4	;BWA 4  AAAA
	DW	'C ',-6,2	;BWV 2  VV
	DW	'N ',_U 	;BWU 1  U
	DW	'C ',-1,3	;BWU 3  UUU
	DW	'N ',_V 	;BWV 1  V
	DW	'N ',_A 	;BWA 1  A
	DW	'N ',_A 	;BWA 1  A
	DW	'N ',_Y 	;BWY 1  Y
	DW	'C ',-80,4	;BWU 4  UUUU
	DW	'C ',-81,3	;BLA 3  UAA
	DW	'X ',_LD	;LDA
	DW	'N ',_U 	;LDU 1  U
	DW	'N ',_U 	;LDU 1  U
	DW	'N ',_T 	;LDT 1  T
	DW	'N ',_U 	;LDU 1  U
	DW	'C ',-1,18	;LDU 18 UUUUUUUUUUUUUUUUU
	DW	'C ',-80,3	;BGA 4  WUA
	;LINE:11
	DW	'N ',_A 	;BGA 1  A
	DW	'C ',-80,6	;BGT 6  AAAAAT
	DW	'N ',_A 	;BGA 1  A
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_U 	;BGU 1  U
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-80,14	;BWY 14 SAAAAAAAAAAAAY
	DW	'N ',_A 	;BWA 1  A
	DW	'C ',-1,2	;BWA 2  AA
	DW	'N ',_Y 	;BWY 1  Y
	DW	'N ',_U 	;BWU 1  U
	DW	'C ',-1,23	;BWU 23 UUUUUUUUUUUUUUUUU
	DW	'N ',_V 	;BWV 1  V
	DW	'N ',_V 	;BWV 1  V
	DW	'N ',_A 	;BWV 1  A
	DW	'X ',_BD	;BDA
	DW	'N ',_Y 	;BDY 1  Y
	DW	'N ',_Y 	;BDY 1  Y
	DW	'N ',_U 	;BDU 1  U
	DW	'C ',-80,27	;BDA 27 UUUUUUUUUUWUAAAAA
	;LINE:12
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-80,3	;BGU 3  ATU
	DW	'N ',_T 	;BGT 1  T
	DW	'C ',-80,11	;BGA 11 SAAAAAAAAAA
	DW	'X ',_BD	;BDA
	DW	'N ',_V 	;BDV 1  V
	DW	'C ',-1,5	;BDV 5  VVVVV
	DW	'C ',-83,26	;BWU 26 AAAYUUUUUUUUUUUUU
	DW	'X ',_LW	;LWU
	DW	'N ',_T 	;LWT 1  T
	DW	'N ',_S 	;LWS 1  S
	DW	'X ',_BL	;BLS
	DW	'N ',_U 	;BLU 1  U
	DW	'N ',_V 	;BLV 1  V
	DW	'C ',-1,2	;BLV 2  VV
	DW	'C ',-83,2	;BDU 2  YU
	DW	'N ',_Y 	;BDY 1  Y
	DW	'X ',_BL	;BLY
	DW	'N ',_V 	;BLV 1  V
	DW	'X ',_BD	;BDV
	DW	'N ',_Y 	;BDY 1  Y
	DW	'N ',_Y 	;BDY 1  Y
	DW	'X ',_BL	;BLY
	DW	'N ',_V 	;BLV 1  V
	DW	'N ',_A 	;BLV 1  A
	DW	'X ',_BD	;BDV
	DW	'N ',_Y 	;BDY 1  Y
	DW	'C ',-80,18	;BGS 18 UUUUUUWUAAAAAAS
	;LINE:13
	DW	'C ',-79,2	;BGU 2  TU
	DW	'N ',_A 	;BGA 1  A
	DW	'C ',-80,7	;BGA 7  TSAAAAA
	DW	'C ',-77,3	;BDV 3  AAV
	DW	'N ',_U 	;BDU 1  U
	DW	'N ',_U 	;BDU 1  U
	DW	'X ',_BY	;BYU
	DW	'N ',_C 	;BYC 1  C
	DW	'N ',_F 	;BYF 1  F
	DW	'N ',_M 	;BYM 1  M
	DW	'N ',_M 	;BYM 1  M
	DW	'N ',_Q 	;BYQ 1  Q
	DW	'X ',_BD	;BDQ
	DW	'N ',_U 	;BDU 1  U
	DW	'C ',-1,2	;BDU 2  UU
	DW	'C ',-83,4	;BDA 4  VAAA
	DW	'C ',-79,21	;LWS 21 UUUUUUUUUUUUUUTS
	DW	'N ',_R 	;LWR 1  R
	DW	'X ',_LD	;LDR
	DW	'N ',_A 	;LDA 1  A
	DW	'C ',-1,2	;LDA 2  AA
	DW	'N ',_R 	;LDR 1  R
	DW	'N ',_S 	;LDS 1  S
	DW	'C ',-83,2	;BLV 2  VV
	DW	'N ',_V 	;BLV 1  V
	DW	'X ',_LD	;LDV
	DW	'N ',_R 	;LDR 1  R
	DW	'C ',-6,3	;BLV 3  RSV
	DW	'N ',_Y 	;BLY 1  Y
	DW	'X ',_BD	;BDY
	DW	'N ',_V 	;BDV 1  V
	DW	'C ',-80,16	;BDA 14 UUUUUUWUAAAAAA
	;LINE:14
	DW	'N ',_U 	;BGU 1  U
	DW	'C ',-80,2	;BGU 2  TU
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_T 	;BGT 1  T
	DW	'X ',_BD	;BDT
	DW	'N ',_A 	;BDA 1  A
	DW	'C ',-1,5	;BDA 5  AAAAAA
	DW	'N ',_U 	;BDU 1  U
	DW	'N ',_U 	;BDU 1  U
	DW	'X ',_BY	;BYU
	DW	'N ',_C 	;BYC 1  C
	DW	'N ',_F 	;BYF 1  F
	DW	'N ',_J 	;BYF 1  J
	DW	'N ',_J 	;BYF 1  J
	DW	'N ',_L 	;BYL 1  L
	DW	'N ',_P 	;BYP 1  P
	DW	'N ',_H 	;BYH 1  H
	DW	'N ',_H 	;BYH 1  H
	DW	'N ',_K 	;BYK 1  K
	DW	'N ',_B 	;BYB 1  B
	DW	'C ',-83,2	;BDU 2  UU
	DW	'C ',-81,3	;BWA 2  AAA
	DW	'N ',_Y 	;BWY 1  Y
	DW	'C ',-81,22	;LDU 21 UUUUUUUUUUTSRA
	DW	'N ',_R 	;LDR 1
	DW	'C ',-81,2	;LDR 2  AR
	DW	'C ',-77,3	;LDS 3  RRS
	DW	'C ',-80,3	;LDS 3  RRS
	DW	'X ',_BL	;BLS
	DW	'N ',_Y 	;BLY 1  Y
	DW	'C ',-80,17	;BDA 17 YVUUUUUUUWUAAAAAA
	;LINE:15
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_A 	;BGA 1  A
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_U 	;BGU 1  U
	DW	'C ',-80,9	;BDU 9  TAAAAAAUU
	DW	'N ',_S 	;BDS 1  S
	DW	'C ',-83,2	;BDU 2  UU
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_U 	;BGU 1  U
	DW	'N ',_T 	;BDT 1  T
	DW	'C ',-6,3	;BDT 3  UUT
	DW	'N ',_U 	;BGU 1  U
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_A 	;BDA 1  A
	DW	'C ',-1,2	;BWA 2  AA
	DW	'C ',-83,2	;BWA 2  AA
	DW	'N ',_Y 	;BWY 1  Y
	DW	'N ',_Y 	;BWY 1  Y
	DW	'X ',_LW	;LWY
	DW	'N ',_S 	;LWS 1  S
	DW	'N ',_S 	;LWS 1  S
	DW	'N ',_U 	;LWU 1  U
	DW	'N ',_T 	;LWT 1  T
	DW	'C ',-80,15	;LDA 15 UUUUUUUUUUTSRA
	DW	'C ',-79,4	;LDR 4  URRR
	DW	'X ',_BL	;BLR
	DW	'N ',_Y 	;BLY 1  Y
	DW	'N ',_Y 	;BLY 1  Y
	DW	'X ',_BD	;BDY
	DW	'N ',_A 	;BDA 1  A
	DW	'N ',_V 	;BDV 1  V
	DW	'C ',-1,2	;BDV 2  VV
	DW	'C ',-77,3	;BDU 3  UUU
	DW	'C ',-80,14	;DBA 14 UUUUUUUUUWUAAAAAA
	;LINE:16
	DW	'N ',_U 	;BGU 1  U
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_A 	;BGA 1  A
	DW	'C ',-80,10	;BDU 10 SUTAAAAAAU
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_R 	;BDR 1  R
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_S 	;BDS 1  S
	DW	'C ',-80,2	;BDU 2  TU
	DW	'N ',_S 	;BDS 1  S
	DW	'C ',-83,3	;BDT 3  TUT
	DW	'C ',-80,5	;BDA 7  UTAAA
	DW	'N ',_A 	;BDA 1  A
	DW	'N ',_V 	;BDV 1  V
	DW	'N ',_U 	;BDU 1  U
	DW	'N ',_U 	;BDU 1  U
	DW	'N ',_A 	;BDA 1  A
	DW	'X ',_LW	;LWA
	DW	'N ',_A 	;LWA 1  A
	DW	'C ',-1,2	;LWA 2  AA
	DW	'N ',_Y 	;LWY 1  Y
	DW	'N ',_S 	;LWS 1  S
	DW	'C ',-81,15	;BDU 15 UUUUUUUUTSRUU
	DW	'C ',-77,2	;BLA 2  YA
	DW	'N ',_U 	;BDU 1  U
	DW	'C ',-1,7	;BDU 7  UUUUUUU
	DW	'C ',-80,15	;BDA 15 UUUUUUUWUAAAAAA
	;LINE:17
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_A 	;BGA 1  A
	DW	'N ',_U 	;BGU 1  U
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-80,2	;BGU 2  SU
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-80,6	;BGA 6  AAAAAA
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_S 	;BDS 1  S
	DW	'N ',_R 	;BDR 1  R
	DW	'N ',_S 	;BDS 1  S
	DW	'C ',-80,2	;BDS 2  TS
	DW	'C ',-81,2	;BDT 2  ST
	DW	'N ',_R 	;BDR 1  R
	DW	'N ',_T 	;BDT 1  T
	DW	'C ',-6,2	;BDS 2  TS
	DW	'N ',_U 	;BDU 1  U
	DW	'N ',_S 	;BDU 1  S
	DW	'C ',-80,4	;BDA 4  AAAA
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_U 	;BDU 1  U
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_S 	;BDS 1  S
	DW	'N ',_V 	;BDV 1  V
	DW	'X ',_BL	;BLV
	DW	'N ',_Y 	;BLY 1  Y
	DW	'C ',-81,2	;LWA 2  AA
	DW	'C ',-80,3	;LWU 3  SUU
	DW	'C ',-79,9	;LWS 9  UUUUUUUTS
	DW	'C ',-77,2	;BLY 2  UY
	DW	'X ',_BD	;BDY
	DW	'N ',_V 	;BDV 1  V
	DW	'C ',-1,2	;BDV 2  VV
	DW	'N ',_U 	;BDU 1  U
	DW	'C ',-80,22	;BDA 20 UUUUUUUWUAAAAA
	;LINE:18
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_U 	;BGU 1  U
	DW	'N ',_A 	;BGA 1  A
	DW	'N ',_S 	;BGA 1  S
	DW	'N ',_A 	;BGA 1  A
	DW	'N ',_R 	;BGA 1  R
	DW	'N ',_T 	;BGT 1  T
	DW	'C ',-80,8	;BDT 8  SAAAAAAT
	DW	'N ',_R 	;BDR 1  R
	DW	'C ',-1,2	;BDR 2  RR
	DW	'C ',-83,3	;BDS 3  SRS
	DW	'N ',_S 	;BDS 1  S
	DW	'N ',_R 	;BDR 1  R
	DW	'N ',_S 	;BDS 1  S
	DW	'C ',-1,2	;BDS 2  SS
	DW	'N ',_T 	;BDT 1  T
	DW	'C ',-80,5	;BDA 5  SAAAA
	DW	'N ',_S 	;BDS 1  S
	DW	'C ',-79,2	;BDS 2  TS
	DW	'N ',_R 	;BDR 1  R
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_T 	;BDT 1  T
	DW	'N ',_V 	;BDV 1  V
	DW	'X ',_BL	;BLV
	DW	'N ',_Y 	;BLY 1  Y
	DW	'C ',-80,3	;LWU 3  SUU
	DW	'C ',-81,10	;LWS 10 UUUUUUUUTS
	DW	'N ',_R 	;LWR 1  R
	DW	'X ',_BL	;BLR
	DW	'N ',_V 	;BLV 1  V
	DW	'C ',-1,2	;BLV 2  VV
	DW	'X ',_BD	;BDV
	DW	'N ',_A 	;BDA 1  A
	DW	'N ',_Y 	;BDY 1  Y
	DW	'C ',-1,3	;BDY 3  YYY
	DW	'C ',-80,17	;BDA 17 UUUUUUWUAAAA
	;LINE:19
	DW	'C ',-79,3	;BGA 3  TUA
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-1,2	;BGR 2  RR
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-80,5	;BGA 5  AAAAA
	DW	'N ',_S 	;BDS 1  S
	DW	'N ',_R 	;BDR 1  R
	DW	'N ',_A 	;BDA 1  A
	DW	'N ',_R 	;BDR 1  R
	DW	'C ',-1,3	;BDR 3  RRR
	DW	'C ',-6,3	;BDR 3  RAR
	DW	'C ',-83,3	;BDS 3  SRS
	DW	'N ',_R 	;BDR 1  R
	DW	'C ',-80,4	;BDA 4  AAAA
	DW	'N ',_R 	;BDR 1  R
	DW	'C ',-79,2	;BDR 2  SR
	DW	'N ',_A 	;BDA 1  A
	DW	'N ',_S 	;BDS 1  S
	DW	'C ',-1,3	;BDS 3  SSS
	DW	'X ',_BW	;BWS
	DW	'N ',_A 	;BWA 1  A
	DW	'N ',_Y 	;BWY 1  Y
	DW	'N ',_Y 	;BWY 1  Y
	DW	'C ',-80,8	;BWU 8  UUUUUUUU
	DW	'C ',-79,2	;LWR 1  SR
	DW	'X ',_LD	;LDA
	DW	'N ',_A 	;LDA 1  A
	DW	'C ',-1,4	;LDA 4  AAAA
	DW	'N ',_R 	;LDR 1  R
	DW	'C ',-1,2	;LDR 2  RR
	DW	'N ',_S 	;LDS 1  S
	DW	'X ',_BL	;BLS
	DW	'N ',_V 	;BLV 1  V
	DW	'N ',_A 	;BLA 1  A
	DW	'X ',_BD	;BDA
	DW	'N ',_Y 	;BDY 1  Y
	DW	'C ',-1,5	;BDY 5  YYYYY
	DW	'C ',-80,8	;BDA 8  UUUWUAAA
	;LINE:20
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_T 	;BGT 1  T
	DW	'C ',-83,2	;BGA 2  AA
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-80,2	;BGR 2  RR
	DW	'N ',_A 	;BGA 1  A
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_S 	;BGS 1  S
	DW	'C ',-81,6	;BGA 6  RRAAAA
	DW	'C ',-79,2	;BDA 2  RA
	DW	'C ',-80,3	;BDR 3  ARR
	DW	'N ',_R 	;BDR 1  R
	DW	'N ',_A 	;BDA 1  A
	DW	'C ',-80,3	;BDR 3  RAR
	DW	'C ',-83,3	;BDR 3  RAR
	DW	'C ',-80,6	;BDR 6  RAAAAR
	DW	'C ',-6,3	;BDA 3  RAA
	DW	'N ',_S 	;BDS 1  S
	DW	'N ',_R 	;BDR 1  R
	DW	'C ',-6,3	;BDA 3  RRA
	DW	'C ',-1,5	;BDA 5  AAAAA
	DW	'X ',_BW	;BWA
	DW	'N ',_Y 	;BWY 1  Y
	DW	'C ',-1,4	;BWY 4  YYYY
	DW	'X ',_BL	;BLY
	DW	'N ',_Y 	;BLY 1  Y
	DW	'C ',-77,3	;LDA 3  AAA
	DW	'N ',_A 	;LDA 1  A
	DW	'N ',_R 	;LDR 1  R
	DW	'C ',-1,4	;LDR 4  RRRR
	DW	'N ',_A 	;LDA 1  A
	DW	'C ',-83,3	;LDS 3  RRS
	DW	'N ',_S 	;LDS 1  S
	DW	'N ',_A 	;LDA 1  A
	DW	'C ',-1,2	;LDA 2  AA
	DW	'X ',_BL	;BLA
	DW	'N ',_V 	;BLV 1  V
	DW	'C ',-1,2	;BLV 2  VV
	DW	'C ',-77,2	;BGA 2  AA
	DW	'X ',_BD	;BDA
	DW	'N ',_Y 	;BDY 1  Y
	DW	'N ',_A 	;BDA 1  A
	;LINE:21
	DW	'X ',_BG	;BGA
	DW	'N ',_V 	;BGV 1  V
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_S 	;BGS 1  S
	DW	'X ',_GB	;GBS
	DW	'N ',_N 	;GBN 1  N
	DW	'N ',_G 	;GBG 1  G
	DW	'X ',_BG	;BGG
	DW	'N ',_R 	;BGR 1  R
	DW	'N ',_S 	;BGS 1  S
	DW	'N ',_T 	;BGT 1  T
	DW	'N ',_V 	;BGV 1  V
	DW	'C ',-1,3	;BGV 3  VVV
	DW	'N ',_R 	;BGR 1  R
	DW	'C ',-1,2	;BGR 2  R
	DW	'C ',-6,3	;BGV 3  VVV
	DW	'N ',_A 	;BGA 1  A
	DW	'C ',-1,13	;BGA 13 AAAAAAAAAAAAA
	DW	'N ',_V 	;BGV 1  V
	DW	'C ',-1,22	;BGV 22 VVVVVVVVVVVV
	DW	'X ',_GD	;GDV
	DW	'N ',_Y 	;GDY 1  Y
	DW	'N ',_Y 	;GDY 1  Y
	DW	'C ',-6,3	;BGV 3  VV
	DW	'C ',-1,3	;BGV 3  VVVV
	DW	'X ',_LG	;LGV
	DW	'N ',_V 	;LGV 1  V
	DW	'C ',-1,15	;LGV 15 VVVVVVVVVVVV
	DW	'X ',_GW	;GWV
	DW	'N ',_Y 	;GWY 1  Y
	;LINE:22
	DW	'X ',_BG	;BGY
	DW	'N ',_Y 	;BGY 1  Y
	DW	'C ',-1,79	;BGY 79 YYYYYYYYYYYYY
;---------------------------------------;
					;
	DW	'Q '	       ;QUIT    ;
					;
;---------------------------------------;
					;
CMPRSD: DB	?			;
					;
;---------------------------------------;
