;Hugi Size Coding Competition 27 - The Resurrection!
;submitted by DevFred <fredsose07@gmx.de> on October 15th

;compile with "nasm -o entry.com entry.asm"

org 100h

    push 0b800h
    pop es
;---clear the screen
    mov al, 3
    int 10h

;---generate colors
    mov bx, huffman2
    add di, ax                  ;fffe + 3 = 1
    call decode_huffman

;---generate characters
    mov bx, huffman1
    xor di, di
    call decode_huffman

;---draw colored lines
    mov al, 0dfh
    mov cl, 23                  ;load first length
   ;mov si, lines
lines_1:
    mov ah, [si]                ;load color
    inc si
    rep stosw
    mov cl, [si]                ;load next length +1
    inc si
    loop lines_1                ;correct length and continue

;---insert 0xde character
    dec ax                      ;mov al, 0deh
    mov di, 2 * (7 * 80 + 41)
    stosb
    mov di, 2 * (7 * 80 + 55)
    stosb
    mov di, 2 * (8 * 80 + 55)
    stosb

;---insert 0xdd character
    dec ax                      ;mov al, 0ddh
    mov di, 2 * 557
    mov cl, 13
insert_dd:
    stosb
    add di, 2 * 80 - 1
    loop insert_dd

;---draw strings
    lodsw                       ;load first address
strings_1:
    mov di, ax
    lodsw                       ;load first character and color
strings_2:
    stosw                       ;store character and color
    lodsb                       ;load next character
    test al, al
    jnz strings_2
    lodsw                       ;load next address +1
    dec ax                      ;correct address
    jnz strings_1

;---wait for keypress and exit
   ;xor ah, ah
    int 16h
    ret



;---cl: number of bits to read
read_bits:
    mov ax, bp
    shr bp, cl                  ;shift used bits into nirvana
    sub dl, cl                  ;decrement the bitcounter
    jns read_bits_done          ;at least 8 bits available? then continue

    push ax
    lodsb                       ;load next byte into al
    xor ah, ah                  ;zero extend al to ax
    add dl, 8                   ;increase the bitcounter
    mov cl, dl
    shl ax, cl                  ;align new bits
    or bp, ax                   ;append new bits to bitbuffer
    pop ax
read_bits_done:
ret

%macro read 1
    mov cl, %1
    call read_bits
    and al, (1 << %1) - 1       ;mask off unwanted bits
%endmacro

;---bx: start of huffman codes
;---bx+8: start of stream
;---di: 0 (characters) or 1 (colors)
decode_huffman:
    lea si, [bx + 8]            ;load start of stream
    mov bp, [si]                ;load first (and second) encoded byte into bitbuffer
    inc si
    xor dl, dl                  ;set (bitcounter -8) to zero

decode_byte:
    read 3
    mov cl, 1                   ;assume no rle (1 repetition)
    cmp al, 6                   ;block (6) and space (7) are rle
    xlat                        ;look up character in huffman table
    jnb runlength_encoded

    test di, cx                 ;all colors (odd di) are rle
    jz decode_runlength         ;other characters aren't

runlength_encoded:
    push ax                     ;save byte
    dec cx                      ;start with 0 repetitions
again:
    push cx
    read 4
    pop cx
    jnz not_again               ;1..15 are treated "as-is" once

    add cl, 16                  ;0 is treated as 16 +more
    jmp again
not_again:
    add cl, al
    pop ax                      ;restore byte

decode_runlength:
    stosb
    inc di
    loop decode_runlength

    cmp di, 2 * (1680 - 48)     ;last 48 characters are handled by correction
    jb decode_byte
ret

huffman2 equ $-1
;the first byte was omitted because color code 0 is never used
db 006h, 007h, 008h, 00eh, 00fh, 078h, 07fh

stream2:
db 001h, 024h, 000h, 060h, 000h, 009h, 000h, 018h, 040h, 0c2h, 08bh, 0d7h
db 001h, 024h, 0bch, 0cch, 0b6h, 00eh, 020h, 0e1h, 025h, 0d6h, 075h, 0e0h
db 00bh, 068h, 05eh, 007h, 0beh, 080h, 0e6h, 075h, 0beh, 000h, 068h, 05eh
db 0e7h, 00bh, 080h, 0e6h, 075h, 0beh, 000h, 068h, 05eh, 0e7h, 00bh, 080h
db 083h, 0cch, 0efh, 0fbh, 05fh, 0d1h, 046h, 031h, 091h, 0cch, 0f3h, 0fbh
db 0feh, 0d3h, 0a5h, 0f1h, 048h, 0d6h, 0f9h, 07dh, 0ffh, 06ah, 095h, 0ach
db 0f3h, 0fbh, 0deh, 041h, 05ch, 09ah, 07dh, 07eh, 090h, 007h, 011h, 00dh
db 024h, 03fh, 050h, 0cdh, 059h, 032h, 0b0h, 0fch, 080h, 015h, 077h, 0d1h
db 040h, 0f2h, 083h, 0eeh, 05ch, 09dh, 092h, 071h, 07eh, 0d0h, 05dh, 095h
db 055h, 0b8h, 008h, 040h, 000h

huffman1 equ $-1
;the first byte was omitted because it is equal to the preceding byte
db 0b0h, 0b1h, 0b2h, 0dch, 0dfh, 0dbh, 020h

stream1:
db 047h, 01dh, 08fh, 0a4h, 095h, 03ch, 000h, 01eh, 095h, 03fh, 0edh, 03ch
db 0c0h, 02bh, 0bbh, 06dh, 079h, 059h, 05bh, 0d3h, 001h, 049h, 092h, 03ch
db 01eh, 025h, 0ech, 023h, 0edh, 0a3h, 09ch, 03ch, 025h, 00bh, 05ah, 068h
db 039h, 010h, 009h, 044h, 072h, 090h, 06ch, 01dh, 0e4h, 077h, 08ah, 084h
db 0e8h, 0a6h, 057h, 06bh, 06ch, 00fh, 042h, 044h, 0d2h, 0e6h, 098h, 08dh
db 06ch, 01dh, 004h, 0f2h, 0d2h, 024h, 04dh, 0bfh, 044h, 007h, 023h, 0afh
db 0d1h, 01ch, 072h, 0cch, 0cch, 03ah, 010h, 001h, 08ah, 0b6h, 040h, 0fah
db 0e6h, 010h, 0b4h, 0f1h, 016h, 0cdh, 032h, 043h, 07ch, 012h, 021h, 072h
db 024h, 03ah, 0b8h, 0a3h, 0b5h, 0b4h, 096h, 057h, 064h, 028h, 020h, 0fah
db 044h, 08eh, 044h, 0e7h, 092h, 00eh, 09eh, 01dh, 0a4h, 085h, 034h, 09dh
db 01ch, 032h, 014h, 0f2h, 09ah, 0a6h, 0e8h, 05ch, 0bah, 048h, 09eh, 048h
db 013h, 081h, 0bah, 000h, 0cbh, 00ch, 0f5h, 01bh, 0e6h, 090h, 0ceh, 0fdh
db 0d4h, 080h, 024h, 05ah, 043h, 0fdh, 084h, 039h, 0a6h, 02bh, 049h, 092h
db 09fh, 01ah, 06ch, 072h, 090h, 0ach, 0a3h, 06ch, 089h, 05ah, 07fh, 09ah
db 003h, 0d3h, 08fh, 056h, 07eh, 00ch, 033h, 0e5h, 013h, 091h, 04ch, 0c4h
db 0d2h, 0f9h, 073h, 0cch, 091h, 0edh, 066h, 0ffh, 0d4h, 020h, 053h, 010h
db 024h, 051h, 0a2h, 096h, 0ceh, 0dbh, 086h, 0c8h, 0b1h, 09bh, 045h, 096h
db 0cdh, 031h, 0cbh, 01ch, 07bh, 0b5h, 092h, 063h, 0deh, 029h, 040h, 092h
db 016h, 024h, 0bdh, 037h, 087h, 002h, 039h, 076h, 073h, 02ch, 09bh, 0e6h
db 0d0h, 01ch, 073h, 0ech, 044h, 0cbh, 0a9h, 0b2h, 04eh, 0b1h, 014h, 086h
db 0b8h, 00dh, 00eh, 0c9h, 0a1h, 0dbh, 014h, 04dh, 05ah, 036h, 039h, 074h
db 09ah, 063h, 062h, 02dh, 072h, 04eh, 08eh, 092h, 034h, 0c8h, 06bh, 00eh
db 008h, 099h, 06eh, 04bh, 0a2h, 048h, 091h, 034h, 09dh, 034h, 065h, 063h
db 065h, 09dh, 042h, 012h, 06dh, 0ebh, 03eh, 0cdh, 081h, 025h, 059h, 0f2h
db 052h, 090h, 024h, 041h, 014h, 0e5h, 014h, 005h, 092h, 084h, 0d6h, 0a8h
db 0bch, 092h, 088h, 068h, 0dbh, 0d6h, 0f5h, 0d9h, 000h, 025h, 098h, 092h
db 053h, 080h, 024h, 008h, 012h, 024h, 0a7h, 004h, 050h, 092h, 05bh, 0dbh
db 0b6h, 0a6h, 024h, 009h, 012h, 0c9h, 043h, 012h, 028h, 018h, 001h, 0d1h
db 048h, 032h, 009h, 0c9h, 03bh

; filler byte resulting in si pointing to lines after decoding
; (without the filler byte, it would point one byte past lines)
db 23

lines:
db 60h, 2 +1, 68h, 6 +1, 60h, 16 +1, 67h, 1 +1, 6fh, 80 +1, 06h, 0 +1

strings:
dw 2*699
db 0feh, 070h, "Rest in  Peace", 0feh, 0

dw 2*982 +1
db "H", 00eh, "appy", 0

dw 2*1060 +1
db "H", 00eh, "alloween!", 0

dw 2*1603 +1
db "s", 060h, "c", 0

dw 0 +1
