/***********************************************************
*  LZ77 Optimal Compressor, based in Piccard's HC02 entry  *
*                             by                           *
*    Espineter (Antonio Jose Villena Godoy from Spain)     *
************************************************************/
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
typedef struct {
  unsigned int Type;
  unsigned int Size;
  unsigned int Pos;
  unsigned int Count;
  unsigned int Color;
} ttok;
int MinCount= 2;
int stac[256];
int stad[256];
int stae[256];
char output[5000];
unsigned char Data[5000];
ttok Token[5000];
unsigned char magicl[600];
char liter[]= {1,2,3,4,5,6,7,16,17,19,20,21,22,23,24,25,26,31,32,33,34,35,36,37,38,39};
int repet[]= {0,280,280,11,8,280,280,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
              60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
              80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
              100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,
              120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,
              140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
              160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,
              180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,
              200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,
              220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
              240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,
              260,261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279};
unsigned char color[]= {12,9,10,13,14,15,18,27,28,29,30};
int magicv[600];
int Size= 1760, outcount, outpos, outbit, i, j;
char* CharSet[]= {"ENFBHKJPOLQ", " HCDABEMUKJNLSGQPRIVTYOF!W"};
unsigned char micol[]= {8,0x70,0x78,0x0F,6,0x7F,0x0E,0x68,0x60,0x67,0x6F};
void putbit(int i) {
  outcount++;
  outbit+= outbit;
  if (outbit == 256)
    outbit= 1,
    output[++outpos]= 0;
  if (i)
    output[outpos] |= outbit;
}
int putbits(long val, int count) {
  while (count--)
    putbit(val & (1<<count));
}
int putmagic(int i){
  putbits(magicv[i], magicl[i]);
}
void SetBest(int i, int Size, int Type, int Count, int Pos, int Color) {
  ttok* p= &Token[i];
  if (p->Size > p[Count].Size + Size)
    p->Size= p[Count].Size + Size,
    p->Type= Type,
    p->Count= Count,
    p->Pos= Pos,
    p->Color= Color;
}
void Search(int Pos) {
  if (Data[Pos+1]!=Data[Pos] && Token[Pos+1].Type!=2)
    SetBest(Pos, magicl[color[Data[Pos+1]]]+magicl[liter[Data[Pos+2000]]], 0, 1, Data[Pos+2000], Data[Pos+1]);
  else
    SetBest(Pos,                            magicl[liter[Data[Pos+2000]]], 0, 1, Data[Pos+2000], -1);
  for (int i= 0; i<4; i++){
    int Count= 0;
    int Ofs= i?i+78:1;
    while (Pos+Count < Size && Data[Pos-Ofs+Count] == Data[Pos+Count] && Data[Pos-Ofs+Count+2000] == Data[Pos+Count+2000])
      if (++Count>=MinCount && Pos>=Ofs)
        if (Data[Pos+Count]!=Data[Pos+Count-1] && Token[Pos+Count].Type!=2)
          SetBest(Pos, magicl[color[Data[Pos+Count]]]+magicl[repet[Count-MinCount]]+2, 2, Count, Ofs, Data[Pos+Count]);
        else
          SetBest(Pos,                                magicl[repet[Count-MinCount]]+2, 2, Count, Ofs, -1);
  }
}
int main() {
  magicl[0]= 2;
  for (i= 0; i++<30;)
    for (j= i+1; j--;)
      magicl[i*(i+1)/2+j]= i+2,
      magicv[i*(i+1)/2+j]= (4<<i)-2*i-4+j;
  read(open("input.raw", O_BINARY), Data, 4050);
  for (i= 0; i<4000; i++)
    Data[i]= strchr(CharSet[i/2000], toupper(Data[i+i/80])) - CharSet[i/2000];
  memset(&Token,0xFF,sizeof(Token));
  Token[Size].Size= 137*8+magicl[122];
  for (i= Size; i-->=0;)
    Search(i);
  printf("Bits: %i      Bytes: %.3f\n", Token[0].Size, (float)(Token[0].Size)/8);
  outpos= -1;
  outbit= 128;
  for (i= 0; i < Size; i+= Token[i].Count){
    if (Token[i].Type==0)
      stac[Token[i].Pos]++,
      putmagic(liter[Token[i].Pos]),
      printf("lit%3i   %3i%3i\n", Token[i].Pos, liter[Token[i].Pos], magicl[liter[Token[i].Pos]]);
    else
      stad[Token[i].Count-MinCount]++,
      printf("rep%3i%3i%3i%3i\n", Token[i].Count, Token[i].Pos, repet[Token[i].Count-MinCount], magicl[repet[Token[i].Count-MinCount]]+2),
      putmagic(repet[Token[i].Count-MinCount]),
      putbits(Token[i].Pos==1 ? 0 : 82-Token[i].Pos, 2);
    if (Token[i].Color!=-1)
      stae[Token[i].Color]++,
      putmagic(color[Token[i].Color]),
      printf("col%3i   %3i%3i\n", Token[i].Color, color[Token[i].Color], magicl[color[Token[i].Color]]);
  }
  putmagic(122);
  Size= read(open("unpack.com", O_BINARY), Data, 200);
  i= open("entry.com", O_RDWR|O_BINARY|O_TRUNC|O_CREAT, S_IREAD|S_IWRITE);
  write(i, Data, Size);
  write(i, output, outcount/8);
  for (j= 0; j<58; j++)
    printf("%i:%i %i %i\n",j,stac[j],stad[j],stae[j]);
}