; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ;
;          Decompressor code.  LZ77+Huffman: 90b. Table: 40b          ;
;                                   by                                ;
;          Espineter (Antonio Jose Villena Godoy from Spain)          ;
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ;
org 256
        mov     al, 3
        int     10h
        push    0B800h
        pop     es
        mov     bx, read        ;Save 1 byte in each "call" (read a bit)
        mov     bp, (fin-read)*8;point bp to first bit
coti    mov     cl, 0           ;resets cx
        cmp     al, 47          ;is a match > length 6
        jnc     matc            ;goto matc, processing this match
        xlat                    ;read token in table
        cmp     al, 6           ;is a match =< length 6 (2,5,6)
        jc      m256            ;goto m256, processing this match
        js      lite            ;if value is >86 is a literal, process it
        cmp     al,10h          ;if value is between 10 and 5F, is a color
        jc      colo            ;goto label colo for process it
        cmp     al,60h
        jnc     colo
lite    mov     ah, 6           ;read actual color
        sub     al, 3Eh         ;decode the ascii code
        stosw                   ;put literal in screen
        jmp     short empi
matc    sbb     al, 39          ;ax is the number of repetitions
m256    inc     ax              ;for avoiding collision between color 6 and match length 6
        xchg    ax, cx          ;cx now stores length of match, ax is 0
        call    bx              ;read 2 bits
        call    bx
        jz      clin            ;back position is -1. Can be -1, -81, -80, -79.
        sub     ax, 81          ;back position is -81, -80, -79.
clin    lea     si, [2*eax+edi-2] ;point source of match
        db      26h             ;copy ocurrence from es:si to es:di cx times
        rep     movsw
        dec     si              ;read color of last symbol
        db      26h             ;from es:si-1
        lodsb
colo    mov     [lite+1], al    ;stores this last
empi    mul     cx              ;start magic routine, resets ax and dx
        call    bx
bucl    call    bx
        sub     ax, dx
        inc     cx
        add     dx, cx
        cmp     dx, ax
        jbe     bucl            ;end magic routine
        add     al, 7           ;add offset 7 for xlat (bx points 7 bytes down)
        jno     coti            ;last number==122..125? if not repeat loop
        int     16h             ;wait a key
read    bt      [bx], bp        ;read bit routine, idea from piccard hc02
        inc     bp
        adc     ax, ax
        ret
tabla   db      1,03Dh,019h,0EEh,0EFh,01Dh,01Ah,0F0h,5,70h,78h,4,08h,06h
        db      0Fh,7Fh,0A3h,09Fh,0Eh,0A1h,03Ch,0ACh,0AAh,0B1h,01Ch,086h
        db      0AEh,68h,60h,67h,6Fh,090h,0A7h,08Eh,0B2h,0B7h,0ADh,01Bh,05Fh,0B5h
fin:
;1,4,5= length-1 of a match
;06 08 0E 0F 60 68 6F 70 76 78 7F= colors
; !  H  P  R  a  c  e  i  l  n  o  p  s  t  w  y= literal
;21 48 50 52 61 63 65 69 6C 6E 6F 70 73 74 77 79 B0 B1 B2 DB DC DD DE DF FE FF= ascii code
;5F 86 8E 90 9F A1 A3 A7 AA AC AD AE B1 B2 B5 B7 EE EF F0 19 1A 1B 1C 1D 3C 3D= table code

;The Magic routine, my Huffman aproximation:

;    00->     0       there is one 2 bit symbol

;    010->    1       there are two 3 bits symbols
;    011->    2

;    1000->   3       there are three 4 bits symbols
;    1001->   4
;    1010->   5

;    (D+1)*2->  N+1   there are X (X+1) bits symbols

;Compile with nasm: nasm unpack.asm -o unpack.com