#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <list.h>


int window_cmp( char *w, int i, int j, int length )
{
	int count = 0;
	while ( length-- ) 
	{
		if ( w[ i++ ] == w[ j++ ] )
			count++;
		else
			return( count );
	}
	return( count );
}

int getindex(int* sortedseq,int value)
{
	int retval=500;
	int i;
	for(i=0;i<500;i++)
	{
		if ( sortedseq[i] == value )
		{
			retval = i;
			break;
		}
	}
	retval = retval;
	return retval;
}

int main(void)
{ 
	string s;
	ifstream inFile("image.asm");
	ofstream out1File("image_compressed.asm");
	char instr[100];

	int num;

	char results[100];
	char* pCh;
	int count;
	int i,j,k,l;
	int line;
	char outbuf[500];
	int found;
	bool bseq;
	int sequence;
	int content[4000];
	int* pcontent;
	
	int sequences[500];
	int frequencies[500];
	int sorted[500];
	int sortedf[500];

	int max;
	
	list<int> a;
	list<int>::iterator iter;

	for(i=0;i<500;i++)
	{
		sequences[i] = 0;
		frequencies[i] = 0;
		sorted[i] = 0;
		sortedf[i] = 0;
	}


	line = 0;
	
	a.clear();
  pcontent = content;
	//wsprintf(outbuf,"\tDB\t");
	//out1File.write(outbuf,strlen(outbuf));
	while (!inFile.eof())
	{
		inFile.getline(instr,100);
		pCh = instr;

		bseq = 0;
		while (*pCh!='\0')
		{
			if ( *pCh == '0' )
			{
				// start of number
				pCh++;
				if ( *pCh >= '0' && *pCh <= '9' )
					num = 16*(*pCh-'0');
				else
					num = 16*(*pCh-'A'+10);
				pCh++;
				if ( *pCh >= '0' && *pCh <= '9' )
					num = num +(*pCh-'0');
				else
					num = num +(*pCh-'A'+10);
					
				if ( bseq == 0 )
				{
					bseq = 1;
					sequence = num;
					
				}
				else
				{
					bseq = 0;
					sequence = (sequence<<8)+num;
					*pcontent++ = sequence;
					found = 0;
					for (i=0;i<500;i++)
					{
						if ( sequence == sequences[i] )
						{
							found = 1;
							frequencies[i]++;
							break;
						}
					}
					if ( !found )
					{
						i=0;
						while(sequences[i]!=0)
							i++;
						sequences[i] = sequence;
						frequencies[i]++;
					}
				}
			}
			pCh++;
		}
		line++;

	}
	
	
	max = 0;
	for (i=0;i<500;i++)
	{
		found = 0;
		for (j=0;j<500;j++)
		{
			if ( frequencies[j] > max )
			{
				found = 1;
				max = frequencies[j];
				k = j;
			}
		}
		if ( !found )
			break;

		max = 0;
		for (j=0;j<500;j++)
		{
			if ( sortedf[j] == 0 )
			{
				//printf("debug: sorted: %d, sortedf: %d\r\n",sequences[k],frequencies[k]);
				sorted[j] = sequences[k];
				sortedf[j] = frequencies[k];
				break;
			}
		}
		frequencies[k] = 0;
		sequences[k] = 0;
		
	}

	
	*pcontent = 0;

	
	/*
	while (*pcontent!=0)
	{
		printf("%02X ",*pcontent++);
	}
	*/
	
	i = 0;
	
	int copycounter;
	int savedlpointer;
	int bestlength;
	int bestindex;
	int length;
	int bytes;
	int value;

	bytes = 0;
	
	
	while (content[i] != 0)
	{
		j = i-245;
		if ( j<0 )
			j=0;
		bestlength = 0;
		bestindex = 0;
		while (j<i)
		{
			length = 0;
			k = i;
			l = j;
			while ( (content[k] != 0) && (content[k] == content[l]) && (l<i) )
			{
				length++;
				k++;
				l++;
			}
			//printf("length=%d, k=%d, l=%d,j=%d,i=%d\r\n",length,k,l,j,i);
			if ( length > bestlength )
			{
				bestlength = length;
				bestindex = j;
				//printf(" New best: i=%d, content[i]=%d, j=%d, bestlength=%d, bestindex=%d, k=%d, l=%d\r\n",i,content[i],j,bestlength,bestindex,k,l);
			}
			j++;
		}
		if ( bestlength == 0 )
		{
			//printf("No Match! i=%d, content[i] = %d \r\n",i,content[i]);
		}
		j = i;
		length = 0 ;
		while ( (content[j] == content[i]) && (content[j] != 0) )
		{
			length++;
			j++;
		}
		wsprintf(outbuf,"\tDB\t");
		out1File.write(outbuf,strlen(outbuf));
		
		if ( length >= bestlength )
		{
			//printf("i=%d, j=%d, content[j]=%d\r\n",i,j,content[j]);
			if ( length == 1 )
			{
				k = getindex(sorted,content[i]);
				wsprintf(outbuf,"%03Xh,%03Xh\r\n",0xfd,k);
				//wsprintf(outbuf,"%02X %02X\r\n",0xfd,content[i]);
				out1File.write(outbuf,strlen(outbuf));
				printf("%02X %02X\r\n",0xfd,content[i]);
				bytes = bytes + 2;
			}
			else if ( length == 2 )
			{
				k = getindex(sorted,content[i]);
				wsprintf(outbuf,"%03Xh,%03Xh\r\n",0xfc,k);
				out1File.write(outbuf,strlen(outbuf));
				printf("%02X %02X\r\n",0xfc,content[i]);
				bytes = bytes + 2;
			}
			else if ( length == 3 )
			{
				k = getindex(sorted,content[i]);
				wsprintf(outbuf,"%03Xh,%03Xh\r\n",0xfb,k);
				out1File.write(outbuf,strlen(outbuf));
				printf("%02X %02X\r\n",0xfb,content[i]);
				bytes = bytes + 2;
			}
			else if ( length == 4 )
			{
				k = getindex(sorted,content[i]);
				wsprintf(outbuf,"%03Xh,%03Xh\r\n",0xfa,k);
				out1File.write(outbuf,strlen(outbuf));
				printf("%02X %02X\r\n",0xfa,content[i]);
				bytes = bytes + 2;
			}
			else if ( length == 5 )
			{
				k = getindex(sorted,content[i]);
				wsprintf(outbuf,"%03Xh,%03Xh\r\n",0xf9,k);
				out1File.write(outbuf,strlen(outbuf));
				printf("%02X %02X\r\n",0xf9,content[i]);
				bytes = bytes + 2;
			}
			else if ( length == 6 )
			{
				k = getindex(sorted,content[i]);
				wsprintf(outbuf,"%03Xh,%03Xh\r\n",0xf8,k);
				out1File.write(outbuf,strlen(outbuf));
				printf("%02X %02X\r\n",0xf8,content[i]);
				bytes = bytes + 2;
			}
			else if ( content[i] == 0xDB70 )
			{
				wsprintf(outbuf,"%03Xh,%03Xh\r\n",0xff,length);
				out1File.write(outbuf,strlen(outbuf));
				printf("%02X %02X\r\n",0xff,length);
				bytes = bytes + 2;
			}
			else if ( content[i] == 0xDB08 )
			{
				wsprintf(outbuf,"%03Xh,%03Xh\r\n",0xfe,length);
				out1File.write(outbuf,strlen(outbuf));
				printf("%02X %02X\r\n",0xfe,length);
				bytes = bytes + 2;
			}
			else
			{
				k = getindex(sorted,content[i]);
				// we are not using the "extended packing" in this case because this particular dataset
				// does not contain data that will lead us here
				// however the code is kept as is for referenc
				if ( (k <= 0x0F) && (length <= 0x07) )
				{
					length = length + 0x08;
					k = k + (length<<4);
					wsprintf(outbuf,"%03Xh,%03Xh\r\n",0,k);
					out1File.write(outbuf,strlen(outbuf));
					bytes = bytes +2;
				}
				else
				{
					wsprintf(outbuf,"%03Xh,%03Xh,%03Xh\r\n",0,length,k);
					out1File.write(outbuf,strlen(outbuf));
					bytes = bytes+3;
				}
				
				printf("%02X %02X %02X\r\n",0,length,content[i]);
				
			}
			i = j;
			//printf("new i : %d\r\n",i);
		}
		else
		{
			k = getindex(sorted,content[i+bestlength]);
			if ( (k <= 0x0F) && (bestlength <= 0x07) )
			{
				k = (bestlength<<4) + 0x80 +k;
				wsprintf(outbuf,"%03Xh,%03Xh\r\n",i-bestindex,k);
				out1File.write(outbuf,strlen(outbuf));
				bytes = bytes+2;
			}
			else
			{
				wsprintf(outbuf,"%03Xh,%03Xh,%03Xh\r\n",i-bestindex,bestlength,k);
				out1File.write(outbuf,strlen(outbuf));
				bytes = bytes+3;
			}
			//printf("i=%d, j=%d, content[j]=%d\r\n",i,j,content[j]);
			printf("%02X %02X %02X\r\n",i-bestindex,bestlength,content[i+bestlength]);
			
			i = i+bestlength+1;
			//printf("new i : %d\r\n",i);
		}

		//if ( i > 90 )
			//break;
	}
	wsprintf(outbuf,"\tDB\t0F7h\r\n");
	out1File.write(outbuf,strlen(outbuf));
	for (i=0;i<500;i++)
	{
		if ( sorted[i] == 0 )
			break;
		wsprintf(outbuf,"Seq%d:\r\n",i);
		out1File.write(outbuf,strlen(outbuf));
		wsprintf(outbuf,"\tDB\t");
		out1File.write(outbuf,strlen(outbuf));
		k = (sorted[i]>>8) & 0x00FF;
		l = (sorted[i]) & 0x00FF;
		wsprintf(outbuf,"%03Xh,%03Xh\r\n",k,l);
		out1File.write(outbuf,strlen(outbuf));
	}
	
	
	printf("Estimated bytes: %d\r\n",bytes);

	inFile.close();
	out1File.close();	
	
	return 0;
}
