; Hugi Size Coding Competition 27 - The Resurrection!
;
; Entry by Flyke ( ville@heaven.dk )
; 
; Last changed 30.10.2008
;
; A few notes..
; image.asm has been optimized by hand by exchanging space (0x20) characters with differing attributes 
; to block character (0xdb). There may have been other optimizations but they've already left my mind.
;
; compress.cpp produces the compressed image "image_compressed.asm"
; 
; The compression algorithm uses is a sliding window ( LZ77 ).
; It includes escape sequences to further improve compression.
;
;
; masm 6.14
; ml /c entry.asm
; link /tiny entry.obj,entry.com, , , ,

.model tiny
.486
.code

org	100h
start:	

	call	clrscr

	mov     si, offset IMAGEDATA
	mov			di, offset ENDPROG
	push		di

unpackloop:

	mov		bx, seq0
	xor		ax, ax

	lodsb
	cmp		al, 0FFh
	je		func_0xff
	
	cmp		al, 0FEh
	je		func_0xfe

	cmp		al, 0F8h
	jae		funcs_0xf8_0xfd
	
	
	cmp		al, 0F7h
	je		unpackdone
	
	cmp		al, 000h
	je		func_0x00
	
	
	push	ax
	lodsb
	test	al, 080h
	jnz		func__packed
	
	xchg	cx, ax
	
	lodsb
	
	jmp short func_skip
func__packed:
	
	and		al, 07Fh
	mov		cl, al
	shr		cl, 4
	
	and		al, 0Fh
	
func_skip:
	add		bx, ax
	add		bx, ax

	pop		ax	
	push	si
	mov		si, di
	sub		si, ax
	sub		si, ax
	rep		movsw
	pop		si
	
	mov		ax, word ptr [bx]
	stosw
	
	
	jmp		unpackloop
	


funcs_0xf8_0xfd:
	mov	cl, 0feh
	sub	cl, al
	jmp	short	dofill



; func 0x00 is followed by two bytes, first byte means # of repeats and second byte means what sequence
; if the msb of the byte following is set only one byte is used, high nibble ( except msb ) 
; means # of repeats and low nibble means sequence.
; However the particular dataset does not contain this combination and it is thus not present in
; the program ( commented out ).
func_0x00:
	lodsb
	;test	al, 080h
	;jnz		func_0x00_packed
	xchg	cx, ax

dofill:
	lodsb
	add		bx, ax
	add		bx, ax
	jmp		dostosw
	
	


func_0x00_packed:
	;and		al, 07Fh

	;xor		cx, cx
	;mov		cl, al
	;shr		cl, 4

	;and		ax, 00Fh
	;mov 	bx, seq0	
	;add		bx, ax
	;add		bx, ax
	;mov		ax, word ptr [bx]
	;rep  	stosw
	;jmp		unpackloop

; 0xfe means repeat second most frequent sequence (seq1)
func_0xfe:
	inc		bx
	inc		bx
	
; 0xff means repeat most frequent sequence (seq0)
func_0xff:

funcs_0xfe_0xff:
	lodsb
	xchg	cx, ax
	
dostosw:
	mov		ax, word ptr[bx]
	rep 	stosw
	jmp		unpackloop
	

unpackdone:

	; offset ENDPROG is pushed on to the stack in the beginning of the program
	pop		si
	;mov   si, offset ENDPROG
	push	0b800h
	pop		es
	
	xor		di, di
	mov   cx, 2000
	rep 	movsw
	
	mov		ah, 0		;wait for keystroke
	int		16h

clrscr:
	mov		ax, 0003h	;clean up
	int		10h
	ret


IMAGEDATA:

include image_compressed.asm

ENDPROG:
 end start