comment $

Hugi Size Coding Competition 27 - The Resurrection!


entry by
Hannes Uppman / 2008

hannes.uppman@gmail.com


Discovered this competition way too late. Spent most time trying to come up with
a decent compressor.
First version of this unpacker was made on the day of the deadline. This is a
second version with a few minor optimizations.

The compressor is a LZ-variant where most numbers are represented using a
variable bit length and both vertical and horizontal copy-offsets are given.

One bit describes if an element is a symbol or a reference. If the element is a
symbol two numbers are given (most of the time). One for the color (color 0 =
use previous color), and one to identify the character (this one have a fixed
with of 3 bits).
The color number is used to look the real color up from a table. High color
numbers indicate a string, these are a sequence of ASCII characters all using
the same color. The data for these strings follows immediately after the color
number and are terminated by a zero byte, no 3 bits for the character are given.

If the element represents a reference three numbers are given. One for vertical
offset, one for horizontal, and finally one for length.

$

DATA_SIZE equ 3862
VERTICAL equ -78
MIN_COPY equ 2
STRING_COLOR equ 11

.model tiny
.386
.code
org 100h

hugi27:
;assume ah=0, di=FFFE, ch=0
    mov     al,3
    int     10h
    push    0B800h
    pop     es
    mov     bx,offset colors
    mov     si,(offset data - offset colors) * 8 + DATA_SIZE - 1 + 8
    ;+8 so that we will read the extra 0 at the end of the data

@1: stosw                       ; initially this makes di = 0
string:
    mov     cl,8
    call    getBits
    jnz     @1

mainLoop:
; ah = background color
    call    readDigit           ; read color / vertical offset
    bt      [bx],si             ; check if symbol or reference
    dec     si
    jc      copy

    dec     al                  ; damn inc si destroy zf, have to test
    js      @2                  ; color -1 = use previous
    cmp     al,STRING_COLOR     ; high color number indicates string
    xlatb
    mov     ah,al
    jae     string

@2: test    ax,ax               ; should be as below, but feature not used with color -1
    jz      @3
;   cmp     ah,0
;   jz      @4
            
    mov     cl,3
    call    getBits             ; get symbol
    cmp     al,5
    jb      @3
    add     al,176-219-5
@3: add     al,219
    stosw
    jmp     mainLoop    

copy:
    cbw
    imul    bp,ax,VERTICAL
    call    readDigit
    sub     bp,ax
    call    readDigit
    add     al,MIN_COPY
    xchg    ax,cx
    add     bp,bp
@4: mov     ax,es:[di+bp-2]
    stosw
    loop    @4
    cmp     si,14*8
    jae     mainLoop

    xchg    ax,si
    int     16h
    ; fall through

getBits:
    sub     al,al
@5: bt      [bx],si
    dec     si
    adc     al,al
    loop    @5
    ret

readDigit:
    mov     cl,2
    call    getBits
    cmp     al,2
    jb      @7
    xchg    al,cl
    mov     dl,2
    je      @6
    inc     cl
    mov     dl,6
@6: call    getBits
    add     al,dl
@7: ret

colors:
db      8, 0, 6, 7, 15, 14, 120, 127, 118, 104, 111, 112, 96, 14

data:
; the data is reversed, read it from the end
db       50,249,201, 79,126, 66, 73,245, 77, 98,214, 56,  4,209, 62,137,180
db      217,183, 73,142,145,224, 32,  3, 48, 54,231, 54,138, 72, 72, 61,228
db       99,118, 12,163, 13, 36,233, 91, 63,145,208, 38,105,131,174,141,182
db       48, 21,136, 13,166,184,238, 49,204,178, 46,108, 27, 68,227,101,125
db       35,233,132, 91,121,141, 88,  8,  7, 91,197,104, 19,169, 32, 24,179
db      149,129, 20,151,177,188, 69, 40, 24,124,237,140,228,194, 23,156,108
db      193, 11,147, 14, 82,192,141,184,178, 55,248,250, 13,128, 68, 68,243
db      149, 27, 56,210,192, 72, 30, 54,224,101, 60,131,102, 20,198,181,113
db      165,149,187,252,231, 11,137, 27,103,144, 12,  1,141,142,209,182, 48
db       52,227, 56,138, 67,110,112,102,111, 30, 87, 72,  4,  9, 82,100,119
db       59, 25,214, 48,153, 80,191, 82,218,128, 57, 14, 48, 70,220,240, 14
db       31,151,121, 35,173, 25, 16, 10, 44,156, 31, 71,114,  0, 33,110,101
db      101,119,111,108,108, 97, 72,112,  0, 82,118, 28,  5,  0, 17,111, 17
db      209,166,226,118,152,143, 65,139,158,161, 14,  2,  1,228,193,193,133
db       33,193,  1, 32,138, 27,132,233,141,123, 96,200, 16,232, 32,  1,168
db      113,114,228,215, 37,137,230,118,208,182, 95,255,141,160,218,239, 79
db        0,204,216,205,  0, 40,218,254,140, 53, 19, 23,198,101, 42, 21, 18
db       32,  1,240, 70,217,249,194,176,  1,248,151,141,133,149, 65,129,128
db      184,165,129,208,205,149, 73,249,179,107,214,194,101, 38, 61,176,116
db       11,128, 32,160,221, 91,106,172,233,  4,162, 77,140, 45, 51,  0, 65
db        0,179, 62, 89, 22, 28,  0, 76,186, 54,210,132,154,132,  1,146,169
db       46,  9, 16,155,179,220,109, 43,103,113,208, 80,171, 65,  3,208,205
db      132,  6, 89, 12, 29, 49, 80,152,  5,177, 61,137, 30,125,150, 29, 16
db      112,154,177, 18,166,187, 36, 20,232, 56, 32, 70,197, 64,168,206,228
db      141,  4,193,116, 95,201,164, 35,227,229,220,218, 16, 68, 13, 50,140
db      138,  1, 32,  8,245, 89,128,118, 36,130,128, 88, 92,145,155,224,212
db      208,153, 51, 72,  4,  9,253,  9,196, 13, 65,200, 76,235, 29,151,202
db       14,108, 63,249,113, 53,  1,112, 86,192,126,242, 19, 72,157,152,  0
db       65,192, 55,129,150, 75, 32

db      0   ;extra byte

end hugi27