/*

Hugi Size Coding Competition 27 - The Resurrection!


entry by
Hannes Uppman / 2008

hannes.uppman@gmail.com


This is the compressor used. Its really ugly and probably contains a good amount of bugs.
I have not made any attempts to clean this up due to lack of time.
You are hereby warned :-)

have fun!

*/


#include <iostream>
#include <iomanip>
#include <time.h>
#include <limits>
#include <windows.h>
#undef max

#define _inline inline
#define SAFE

// The following data is color and character combined. All character that only have one color
// have it set as forground color, and have the background set to black.

#define SIZE (sizeof(dataOrg)/sizeof(int))
int dataOrg[] =
{
  219,  219,  219,  219,  219,  219,  219,  219, 1713,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 3804, 3804, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3804, 3804,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,
  219,  219,  219,  219,  219,  219,  219, 1713, 1712,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 3804, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3804,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,
  219,  219,  219,  219,  219,  219,  219, 1713, 1712, 1714,  219,  219,  219,  219,  219,  219, 1714, 1714, 1712,  219,  219,  219,  219,  219, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3807, 3807, 3803, 3803, 3803, 3803,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 2012, 2012, 2012, 2268, 2268, 2268,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,
  219,  219,  219,  219,  219,  219, 1713, 1713,  219, 1714,  219,  219,  219, 1713, 1713, 1714,  219,  219,  219, 1713, 1712,  219,  219,  219,  219, 3803, 3803, 3803, 3807, 3804, 3804, 3807,  219, 3804, 3803, 3803, 3804, 3803, 3803,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 2012, 2012, 2011, 2011,30896,30897,30897, 2267, 2268, 2268, 2268, 2271, 2271, 2267, 2268, 2268,  219,  219,  219,  219,  219,
  219,  219,  219,  219,  219,  219, 1714, 1713, 1712, 1713, 1713,  219, 1712, 1713,  219,  219,  219,  219,  219,  219, 1713,  219,  219,  219,  219,  219, 3807, 3807, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3803, 3807, 3807,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 2012, 2011,30896,30897,30897,30897,30898,30898, 2267,30898, 2267, 2267, 2267, 2267, 2267, 2267, 2268, 2268, 2271, 2271, 2267, 2268,  219,  219,
 1712,  219,  219,  219,  219,  219, 1713, 1714, 1713, 1713, 1713, 1714, 1713,  219,  219,  219,  219,  219,  219,  219, 1712, 1712, 1713,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 4060, 4060,  219,  219,  219,  219,  219,  219,  219,  219, 2011, 2011,30896,30897,30898, 2267,30897, 2267,30898, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2268, 2271, 2267,  219,
 1712, 1713,  219,  219, 1713, 1712, 1713, 1714, 1714, 1712,  219, 1713, 1713,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 1712,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 4060, 4059, 4059, 4059, 4059, 4059, 4059, 4060,  219,  219,  219,  219,  219, 2011,30896,30897,30898, 2267, 2267,30898, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219, 1712, 1712, 1713,  219, 1712, 1713, 1755, 1712, 1712, 1713,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 4062, 4059, 4063, 4063, 4059, 4059, 4063, 4063, 4059, 4059,  219,  219,  219,  219,30942,30896,30897, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219, 1712, 1713,  219,  219,  219, 1712, 1713, 1755, 1712, 1712, 1713,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 4063, 4060, 4060, 4059, 4060,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 4059, 4060, 4060, 4059, 4059, 4060, 4060, 4059, 4059, 4059, 4059,  219,  219,  219,30942, 2267,30897, 2267,28926,28754,28773,28787,28788,28704,28777,28782,28704,28704,28752,28773,28769,28771,28773,28926, 2267, 2267, 2269, 2267,  219,
 1712,  219,  219,  219,  219,  219, 1714, 1713, 1714, 1713, 1712, 1713,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 4063, 4060, 4059, 4059, 4059, 4059, 4059, 4060, 4060, 4060,  219,  219,  219,  219, 4060, 4060, 4059, 4059, 4059, 4059, 4060,  219,  219, 4063, 4059, 4059, 4059, 4059, 4059,  219,  219, 2267, 2267,30898, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219,  219,  219,  219,  219, 1714,  219, 1714, 1755, 1713, 1713,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 4063,  219,  219,  219, 4063, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4060, 4060,  219, 2271, 2271, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219,  219,  219,  219,  219, 1713,  219, 1714, 1755, 1714, 1713,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 2268, 2268, 2268, 2268, 2268, 2268,  219,  219,  219, 4063, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059,32690,32689, 2011, 2012, 2012, 2012, 2271, 2267, 2271, 2012, 2271, 2271, 2012,  219, 2271, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219,  219,  219,  219,  219, 1713, 1714, 1755,  219, 1714, 1713,  219,  219,  219,  219,  219,  219,  219, 2268, 2267, 2267, 3656, 3681, 3696, 3696, 3705, 2267, 2267, 2267, 2268,  219,  219,  219, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059,32690,32689,32688, 2011, 2011, 2011,30896,30897, 2012, 2012, 2012,30896,30896,30897, 2012, 2015, 2268, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219,  219,  219,  219,  219, 1755, 1714, 1755, 1712, 1714, 1714,  219,  219,  219,  219,  219,  219, 2267, 2267, 3656, 3681, 3692, 3692, 3695, 3703, 3685, 3685, 3694, 3617, 2267, 2267,  219,  219,  219, 4063, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059,32690,32689,32688, 2011,30896, 2011,30896,30896,30896,30897,30896,30896,30897, 2015, 2015, 2268, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219,  219,  219,  219, 1714, 1714,  219, 1712, 1713, 1755, 1714,  219,  219,  219,  219,  219,  219, 2267, 2267, 2225, 2267, 2267, 2226, 2226, 2267, 2226, 2267, 2267, 2226, 2267, 2226,  219,  219,  219,  219,  219, 4063, 4063,32689,32689, 4059,32690, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059,32690,32689,32688, 2011, 2011,30896,30896,30896, 2015, 2015,  219, 2268, 2268, 2268, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219,  219,  219,  219, 1755, 1713, 1712,  219, 1713, 1755, 1714,  219,  219,  219,  219,  219,  219, 2267, 2226, 2224, 2226, 2226, 2225, 2226, 2267, 2225, 2226, 2267, 2226, 2267, 2226,  219,  219,  219,  219, 2268, 2267, 2267,  219, 2011, 2011, 2011,32735,32689, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059,32690,32689,32688, 2011, 2011, 2015,  219, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219,  219,  219,  219, 1714,  219, 1755, 1713, 1713, 1755, 1713,  219,  219,  219,  219,  219,  219, 2226, 2225, 2224, 2225, 2226, 2225, 2225, 2226, 2224, 2226, 2226, 2225, 2267, 2225,  219,  219,  219,  219, 2226, 2267, 2226, 2225, 2268, 2015, 2011, 2011,32689, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059,32690,32689, 2011, 2015, 2268, 2268, 2268, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219,  219,  219, 1714, 1755,  219, 1713,  219, 1712, 1714, 1713,  219,  219,  219,  219,  219,  219, 2226, 2224, 2224, 2224, 2225, 2224, 2225, 2225, 2224, 2225, 2225, 2225, 2226, 2225,  219,  219,  219,  219, 2225, 2226, 2225, 2224, 2226, 2226, 2268, 2015,32689, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059,32690,32689,32688, 2012, 2012, 2012,  219, 2271, 2271, 2271, 2271, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219,  219, 1714, 1755,  219, 1714, 1712, 1712, 1712, 1714, 1712, 1712,  219,  219,  219,  219,  219, 2225, 2224,  219, 2224, 2224, 2224, 2224, 2224,  219, 2224, 2225, 2224, 2225, 2224,  219,  219,  219,  219, 2224, 2225, 2224,  219, 2225, 2225, 2225, 2225,  219, 4063, 4063, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4059,32689,32688, 2011, 2011, 2011, 2011, 2011,30896,30896,30896,30897, 2012,  219, 2271, 2271, 2271, 2271, 2271, 2271, 2267, 2267, 2267, 2269, 2267,  219,
  219,  219, 1714, 1714,  219,  219, 1713, 1712, 1712,  219, 1714, 1713, 1712, 1712,  219,  219,  219,  219, 2224,  219,  219, 2224, 2224, 2224,  219, 2224,  219, 2224, 2224,  219, 2224, 2224,  219,  219,  219,  219, 2224, 2224,  219,  219, 2225, 2224, 2224, 2224,  219,  219,  219,  219,  219,  219, 4063, 4063, 4063, 4063, 4063, 2015, 2011, 2011, 2011, 2011,30896,30896,30896,30896,30896, 2011,30896,30896,30897,30897, 2011, 2011, 2011, 2012, 2012, 2012,  219,  219, 2271,  219,
 1756, 1712, 1713,24691,24675, 1712, 1713, 1714, 1756, 1756, 1756, 1756, 1712, 1712, 1712, 1756, 1756, 1756,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219,  219, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756, 1756,26847,26847, 1756, 1756, 1756, 1756, 1756, 1756,30428,30428,30428,30428,30428,30428,30428,30428,30428,30428,30428,30428,30428,30428,30428,30428,28639,
 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759
};

#define NORMAL_COLORS (11)

int colorsOrg[] =
{
  0,	// Black, Black
  8,	// Black, Gray
  6,	// Black, Brown
 15,	// Black, BrightWhite
 14,	// Black, Yellow
  7,	// Black, White
120,	// White, Gray
127,	// White, BrightWhite
118,	// White, Brown				(dr spket har kontakt med marken)
104,	// Brown, Gray				(de tv under spket)
111,	// Brown, BrightWhite		(lngst ner till hger)

// sakerna hr nedan tas om hand av strngutskriftsfunktionen
112,	// White, Black				(text Rest in peace..)
 96,	// Brown, Black				(text sc)
 14,	// Black, Yellow			(en extra, lt texten Happy.. peka p denna)
};

int colors[sizeof(colorsOrg)/sizeof(int)] =
{ 14, 0, 8, 6, 15, 7, 120, 127, 118, 104, 111, 112, 96, 14 };
int data[SIZE];

unsigned char string[] =
{
	254,'R','e','s','t',' ','i','n',' ',' ','P','e','a','c','e',254,
	'H','a','p','p','y',
	'H','a','l','l','o','w','e','e','n','!',
	's','c'
};

int numberSizes[256];
int MAX;
HANDLE  hConsole;
int workCounter;

void refineColorInformation()
{
	for (int i = 0; i < SIZE; ++i)
	{
		int da = (dataOrg[i] & 255);
		int co = (dataOrg[i] >> 8);

		for (int j = 0; j < sizeof(colors)/sizeof(int); ++j)
		{
			if (colors[j] == co)
			{
				co = j;
				break;
			}
		}
		if (colors[co] == 14 && i > 7*80)
		{
			// hr r vi p den lilla gravstenen och lser
			co = sizeof(colors)/sizeof(int)-1;
		}
		data[i] = (co << 8) + da;
	}
}


void initialize(int systemOfChoice)
{
	
	for (int i = 0; i < sizeof(colors)/sizeof(int); ++i)
	{
		colors[i] = colorsOrg[i];
	}
	
	refineColorInformation();
	hConsole = GetStdHandle(STD_OUTPUT_HANDLE);

	int sizes[][12] =
	{
		{2,2,2, 5,5,5,5,5,5, 9,9,9},
		{1, 4,4,4,4,4,4, 8,8,8,8,8},
		{1, 4,4,4,4, 7,7,7,7,7,7,7},
		{1, 3,3,3, 8,8,8,8,8,8,8,8},
		{2, 3,3, 5,5,5,5,5,5,5,5, 7},
		{2,2, 5,5,5,5,5,5,5,5, 7,7},
		{2,2, 5,5,5,5,5,5,5,5, 6,6},
		{2,2, 4,4,4,4, 6,6,6,6,6,6},
		{2,2,2, 6,6,6,6,6,6,6,6,6},
		{2,2, 4,4,4,4, 5,5,5,5,5,5}
	};
	int maxSizes[12] =
	{
		3+6+16+16 -1,
		1+6+16+16 -1,
		1+4+8+8+8+8 -1,
		1+3+32 -1,
		1+2+8+32 -1,
		2+8+32 -1,
		2+8+16 -1,
		2+4+16 -1,
		3+16 -1,
		2+4+8 -1
	};

	for (int i = 0; i < 256; ++i)
	{
		if (i < 12)
		{
			numberSizes[i] = sizes[systemOfChoice][i];
		}
		else
		{
			numberSizes[i] = numberSizes[i-1];
		}
	}
	MAX = maxSizes[systemOfChoice];

	srand(static_cast<unsigned int>(time(NULL)));
	workCounter = 0;
}

_inline
int match(const int * ref, const int * src)
{
	for (int length = 0; length < 256; ++length)
	{
		int col = (src[length] >> 8);
		// tillt inte ngra koiperingar av strngar
		if (ref[length] != src[length] || col >= NORMAL_COLORS)
		{
			return length;
		}
	}
	std::cout << "too long match\n";
	exit(1);
}

int table[SIZE][SIZE];

// bygg match-tabellen
void precalc()
{
	for (int pos = SIZE-1; pos >= 0; --pos)
	{
		for (int offset = 0; offset < SIZE; ++offset)
		{
			if (pos - offset >= 0 && offset > 0)
			{
				table[pos][offset] = match(data + pos - offset, data + pos);
			}
			else
			{
				table[pos][offset] = 0;
			}
		}
	}
}

template <class T>
inline T max(T a, T b)
{
	return a > b ? a : b;
}

struct Info
{
	int distance;

	int refbit;
	//om refbit == 1, dvs ref
	int length;
	int vOffset;
	int hOffset;
	//om refbit == 0, dvs symbol
	int data;
	int color;

	int lastPos;
};


Info infoTable[SIZE+1];

int smallestSlutionFound = std::numeric_limits<int>::max();
#define END (-1)

int pathfind(Info* dataCompressed, bool verticalWindow, int minimumCopyLength, int verticalOffsetSize)
{
	int verticalOffsetLower = 0;
	int verticalOffsetUpper = verticalWindow ? MAX : 0;

	// har aldrig offset 0, allts
	int horizontalOffsetLower = 1;
	int horizontalOffsetUpper = MAX + 1;
	
	// har minsta lngd..
	int lengthLower = minimumCopyLength;
	int lengthUpper = MAX + minimumCopyLength;

	for (int i=0; i < SIZE+1; ++i)
	{
		infoTable[i].distance = std::numeric_limits<int>::max();
	}

	// starta bakifrn (hr bakom alla data)
	infoTable[SIZE].distance = 0;
	infoTable[SIZE].lastPos = END;

	// kolla nu alla mjliga hopp
	for (int dist = 0; dist < smallestSlutionFound; ++dist)
	{
		for (int pos = SIZE; pos > 0; --pos)
		{
			if (infoTable[pos].distance == dist)
			{
				for (int verticalOffset = verticalOffsetLower; verticalOffset <= verticalOffsetUpper; ++verticalOffset)
				{
					for (int horizontalOffset = horizontalOffsetLower; horizontalOffset <= horizontalOffsetUpper; ++horizontalOffset)
					{
						for (int length = lengthLower; length <= lengthUpper; ++length)
						{
							int offset = verticalOffset * verticalOffsetSize + horizontalOffset;
							int early = pos - offset - length;
							int late = pos - length;

							if (early >= 0)
							{
								if (table[late][offset] >= length)
								{

									int newDistance = dist + 1 +
												numberSizes[horizontalOffset-1] +
												(verticalWindow ? numberSizes[verticalOffset] : 0) +
												numberSizes[length-minimumCopyLength];
										
									if (infoTable[late].distance > newDistance)
									{
										infoTable[late].distance = newDistance;
										infoTable[late].refbit = 1;
										infoTable[late].hOffset = horizontalOffset;
										infoTable[late].vOffset = verticalOffset;
										infoTable[late].length = length;
										infoTable[late].lastPos = pos;
										// the last color in the copied sequence
										infoTable[late].color = (data[pos-1] >> 8);

									}
								}
							}
						}
					}
				}


				int color = (data[pos-1] >> 8);

				if (color >= NORMAL_COLORS)
				{
					int length = 1;
					while ((data[pos-1-length] >> 8) >= NORMAL_COLORS)
					{
						++length;
					}
					// color 0 = previous color
					int newDistance = dist + 1 + numberSizes[color+1] + length*8 + 8;	// + sizes[length-1] TRY
					//int newDistance = dist + 1 + numberSizes[color] + length*8 + 8;	// + sizes[length-1] TRY

					if (infoTable[pos-length].distance > newDistance)
					{
						infoTable[pos-length].distance = newDistance;
						infoTable[pos-length].refbit = 0;
						infoTable[pos-length].length = length;
						infoTable[pos-length].color = color;
						infoTable[pos-length].lastPos = pos;
					}
				}
				else
				{

					if (pos-2 >= 0 && (data[pos-2] >> 8) == color)
					{
						color = -1;
					}
					// color 0 = previous color
					int newDistance = dist + 1 + numberSizes[color+1];
					// om svart bakgrund och frgrund, skippa tecken
					if (colors[color] != 0)
					{
						newDistance += 3;
					}
					//int newDistance = dist + 1 + numberSizes[color] + 3;

					if (infoTable[pos-1].distance > newDistance)
					{
						infoTable[pos-1].distance = newDistance;
						infoTable[pos-1].refbit = 0;
						infoTable[pos-1].data = (data[pos-1] & 255);
						infoTable[pos-1].color = color;
						infoTable[pos-1].lastPos = pos;
					}
				}

				if (pos == 1)
				{
					if (infoTable[0].distance < smallestSlutionFound)
					{
						// hr r vi klara med hela jobbet
						int i = 0;
						for (int pos = 0; infoTable[pos].lastPos != -1; pos = infoTable[pos].lastPos, ++i)
						{
							dataCompressed[i] = infoTable[pos];
						}
						dataCompressed[i].refbit = -1; //end marker

						smallestSlutionFound = infoTable[0].distance;
					}
				}
			}
		}
	}
	return smallestSlutionFound;
}

void decode(int* uncompressed, const Info* compressed, int scaleVerticalOffset)
{
	int uncompressedPtr = 0;
	int stringOffset = 0;

	for (int i = 0; compressed[i].refbit != END; ++i)
	{
		if (compressed[i].refbit==0)
		{
			if (compressed[i].color >= NORMAL_COLORS)
			{
				for (int length = compressed[i].length; length > 0; --length)
				{
					uncompressed[uncompressedPtr] = (compressed[i].color << 8) + static_cast<int>(string[stringOffset]);
					++uncompressedPtr;
					++stringOffset;
				}
			}
			else if (compressed[i].color == -1)
			{
				int color = (uncompressed[uncompressedPtr-1] >> 8);
				uncompressed[uncompressedPtr] = (color << 8) + compressed[i].data;
				++uncompressedPtr;
			}
			else
			{
				uncompressed[uncompressedPtr] = (compressed[i].color << 8) + compressed[i].data;
				++uncompressedPtr;
			}
		}
		else
		{
			int offset = compressed[i].hOffset + compressed[i].vOffset * scaleVerticalOffset;
			for (int length = compressed[i].length; length > 0; --length)
			{
				uncompressed[uncompressedPtr] = uncompressed[uncompressedPtr - offset];
				++uncompressedPtr;
			}
		}
	}
}

void displayEncoded(const Info* compressed, int scaleVerticalOffset)
{
	std::cout << "\n\n";

	for (int i = 0; compressed[i].refbit != END; ++i)
	{
		if (compressed[i].refbit==0)
		{
			SetConsoleTextAttribute(hConsole, colors[compressed[i].color]);

			if (compressed[i].color == -1)
			{
				SetConsoleTextAttribute(hConsole, 13);
			}
			std::cout << static_cast<char>(compressed[i].data);

			if (compressed[i].color >= NORMAL_COLORS)
			{
				std::cout << "\b<";
				for (int k=0; k < compressed[i].length-2; ++k)
				{
					std::cout << '.';
				}
				std::cout << ">";
			}

			SetConsoleTextAttribute(hConsole, 7);
		}
		else
		{
			std::cout << "([" << compressed[i].vOffset << ',' << compressed[i].hOffset << "]," << compressed[i].length << ")";
		}
	}
	std::cout << "\n\n";
}

Info compressed[20*SIZE];
int unpacked[SIZE];


void displayColormap()
{
	std::cout << "\ncolors:\n";
	for (int i = 0; i < sizeof(colors)/sizeof(int); ++i)
	{
		std::cout << colors[i] << ", ";
	}
	std::cout << "\n\n";
}

void displayResults(int verticalOffsetSize, int minimumCopyLength, int bitSize)
{
	std::cout
		<< "\nminsta:\n"
		<< " minCopy=" << minimumCopyLength
		<< " verticalOffset=" << verticalOffsetSize
		<< " size=" << (bitSize+7)/8 << " (" << bitSize << " bits)";
	displayColormap();
	displayEncoded(compressed, verticalOffsetSize);
}

bool findError(int verticalOffsetSize)
{
	bool error = false;
	for (int i = 0; i < SIZE; ++i)
	{
		if (unpacked[i] != data[i])
		{
			error = true;
			std::cout << "position " << i << " corrupted\n";
			displayColormap();
			displayEncoded(compressed, verticalOffsetSize);
		}
	}
	return error;
}

class Bitstream
{
private:
	unsigned __int8 bitPackedData[SIZE];
	int offset;
public:
	Bitstream() : offset(0)
	{
		for (int i = 0; i < SIZE; ++i)
		{
			bitPackedData[i]=0;
		}
	}
	void add(int data, int bits)
	{
		for (int bitOffset = bits-1; bitOffset >= 0; --bitOffset)
		{
			int tmp = (data >> bitOffset) & 1;
			bitPackedData[offset / 8] |= tmp << (offset % 8);
			++offset;
		}
	}
	void display() const
	{
		int width = 17;
		for (int row = 0; 8 * row * width < offset; ++row)
		{
			std::cout << "\ndb\t";
			for (int column = 0; column < width && 8 * (row * width + column) < offset; ++column)
			{
				if (column != 0)
				{
					std::cout << ',';
				}
				std::cout << std::setw(3) << static_cast<int>(bitPackedData[row * width + column]);
			}
		}
		std::cout << "\n";
	}
	int getBit(int bit) const
	{
		return (bitPackedData[bit/8] >> (bit%8)) & 1;
	}
	void reverse()
	{
		Bitstream reversed;
		for (int i = offset-1; i >= 0; --i)
		{
			reversed.add(getBit(i),1);
		}
		*this = reversed;
	}
};

// OBS, only for number system 7
int numberRepresentations[] =
{
	0,		// 00
	1,		// 01
	8+0,	// 10 00
	8+1,	// 10 01
	8+2,	// 10 10
	8+3,	// 10 11
	48+0,	// 11 0000
	48+1,	// 11 0001
	48+2,	// 11 0010
	48+3,	// 11 0011
	48+4,	// 11 0100
	48+5,	// 11 0101
	48+6,	// 11 0110
	48+7,	// 11 0111
	48+8,	// 11 1000
	48+9,	// 11 1001
	48+10,	// 11 1010
	48+11,	// 11 1011
	48+12,	// 11 1100
	48+13,	// 11 1101
	48+14,	// 11 1110
	48+15	// 11 1111
};


void generateBitPackedData(int minimumCopyLength)
{
	Bitstream bitData;
	int stringOffset = 0;
	int lastColor = 0;

	for (int i = 0; compressed[i].refbit != END; ++i)
	{
		if (compressed[i].refbit==0)
		{
			lastColor = compressed[i].color == -1 ? lastColor : compressed[i].color;
			
			int col = compressed[i].color + 1;
			int dta = compressed[i].data;
			dta = dta < 219 ? 5 + dta - 176 : dta - 219;

			bitData.add(numberRepresentations[col], numberSizes[col]);
			bitData.add(0, 1);

			if (compressed[i].color >= NORMAL_COLORS)
			{
				for (int length = compressed[i].length; length > 0; --length)
				{
					bitData.add(static_cast<int>(string[stringOffset]), 8);
					++stringOffset;
				}
				bitData.add(0, 8);
			}
			else
			{
				if (colors[lastColor] != 0)
				{
					bitData.add(dta, 3);
				}
			}
		}
		else
		{
			bitData.add(numberRepresentations[compressed[i].vOffset],
				numberSizes[compressed[i].vOffset]);
			bitData.add(1, 1);
			bitData.add(numberRepresentations[compressed[i].hOffset - 1],
				numberSizes[compressed[i].hOffset - 1]);
			bitData.add(numberRepresentations[compressed[i].length - minimumCopyLength],
				numberSizes[compressed[i].length - minimumCopyLength]);

			lastColor = compressed[i].color;
		}
	}

	bitData.display();
	bitData.reverse();
	bitData.display();
}

void pack()
{
	for (int minimumCopyLength = 1; minimumCopyLength <= 2; ++minimumCopyLength)
	{
		for (int verticalOffsetSize = 77; verticalOffsetSize <= 79; ++verticalOffsetSize)
		{
			++workCounter;
			bool vertical = (verticalOffsetSize != 0);
			int oldBestSize = smallestSlutionFound;	//smallestSlutionFound updated by pathfind
			int bitSize = pathfind(compressed, vertical, minimumCopyLength, verticalOffsetSize);

			if (oldBestSize > bitSize)
			{
#ifdef SAFE
				decode(unpacked, compressed, verticalOffsetSize);
				findError(verticalOffsetSize);
#endif
				displayResults(verticalOffsetSize, minimumCopyLength, bitSize);
				generateBitPackedData(minimumCopyLength);
			}
			else
			{
				std::cout << "\b\b\b\b\b\b" << workCounter;
			}
		}
	}
}

// OBS, this is only for number system 7 ... quick test
// should generate 11 * binom(10,4) = 11!/6!/4! = 2310 calls to pack, so keep other param bounds tight :-)
void permutateColorsAndPack()
{
	// a,b,c kan eg vljas utan hnsyn till ordning
	// testa drfr bara varianterna dr a < b < c
	for (int first = 0; first < NORMAL_COLORS; ++first)
	{
		for (int a = 0; a < NORMAL_COLORS; ++a)
		{
			for (int b = a+1; b < NORMAL_COLORS; ++b)
			{
				for (int c = b+1; c < NORMAL_COLORS; ++c)
				{
					for (int d = c+1; d < NORMAL_COLORS; ++d)
					{
						if (first == a || first == b || first == c || first == d)
						{
							continue;
						}

						colors[0] = colorsOrg[first];
						colors[1] = colorsOrg[a];
						colors[2] = colorsOrg[b];
						colors[3] = colorsOrg[c];
						colors[4] = colorsOrg[d];
						for (int colorToSet = 5; colorToSet < NORMAL_COLORS; ++colorToSet)
						{
							for (int setColorTo = 0; setColorTo < NORMAL_COLORS; ++setColorTo)
							{
								bool alreadyIn = false;
								for (int k = 0; k < colorToSet; ++k)
								{
									if (colors[k] == colorsOrg[setColorTo])
									{
										alreadyIn = true;
										break;
									}
								}
								if (!alreadyIn)
								{
									colors[colorToSet] = colorsOrg[setColorTo];
									break;
								}
							}
						}

						refineColorInformation();
						pack();
					}
				}
			}
		}
	}
}


int main()
{
	initialize(7);
	precalc();

	permutateColorsAndPack();

	return 0;
}