;-----------------------------------------------------------------------;
;                                                                       ;
; Entry for HUGI size coding competition #27: The Ressurection          ;
; To compile with MASM: ml entry.asm                                    ;
; After compiling, append IMAGE.CMP, the output of the compress.c       ;
;  program.                                                             ;
;                                                                       ;
; By Jeff (USA)                                                         ;
;                                                                       ;
;-----------------------------------------------------------------------;
                .model  tiny
                .code
                .386
                .startup



; Clear the screen
                call    ClearScreen

; Decompress image
                mov     si, OFFSET CompData
NextChar:
                lodsb
                xchg    ax, dx
                mov     bl, 8
DoCode:
                shr     dl, 1
                jc      Literal + 1
LookBack:
                lodsw
                mov     cl, al
                and     cl, 3fh
                jz      DecompDone
                shr     ax, 6
                push    si
                mov     si, di
                sub     si, ax
                rep     movs byte ptr es:[si], es:[di]
                pop     si
Literal:
                rep     movsb
Cleanup:
                dec     bx
                jnz     DoCode
                jmp     NextChar


; Wait for a key
DecompDone:
                int     16h

; Clear screen and exit
ClearScreen:
                mov     ax, 3
                int     10h
                mov     ax, 0b800h
                mov     es, ax
                ret


CompData        EQU     $


                END
