; Entry for Hugi Size Compo #27

; Author: lego
; Compile:
;	make

; The strings were removed from the original input in order to reduce number
; of different characters. The number of characters in both color and character
; data was reduced below 16, and then substituded with a 4 bit code. After that
; the data is RLE encoded. The color data was assigned 5-bit rle counter, and
; characters were assigned 3-bit counter because the colors are repeated in
; larger groups, and chars in smaller.

; The generated files require a bit of manual tinkery to get it down to 878
; bytes - the extra zeroes must be removed.

org 0x100

main:
	call .clean

	push 0xb800
	pop es

	mov bx, col_subst
	mov si, col_data
	mov dx, col_len
	mov di, 1
    mov cl, col_blk_bits
	call unpack
	
	mov bx, chr_subst
	mov si, chr_data
	mov dx, chr_len
	xor di, di
    mov cl, chr_blk_bits
	call unpack

	; packed data for the last line takes more space than the following piece of
	; code.
	; DI points to exactly where the last bits need to be copied.
	mov ax, 0x06df
	mov cl, 80
	rep stosw

	; print the three strings that were removed prior to compression.
	mov si, halloween
	mov cl, 3
	.nextString:
		lodsw
		xchg ax, di ; shorter than "mov di, ax" ..
		.nextByte:
			lodsb
			or al, al
			je .end
				stosb
				inc di
				jmp .nextByte
			.end:
		loop .nextString

.getch:
	; the last byte read using lodsb is 0. extend that to ah.
	cbw
	int 0x16

.clean:
	;mov al, 3 ; XXX: if int 0x16 sets ah anything else, this won't work
    mov ax, 3
	int 0x10

	ret

; In:
    ; si - data
    ; dx - data_size in bits
    ; bx - subst_table
    ; cx - length of data + length of count in bits
    ; di - points to output buffer
; Out:
    ; bp = dx
    ; di += 3360
    ; ax = xx
; Not changed:
    ; cx
    ; si
    ; dx
    ; bx
unpack:
    xor bp, bp
    .next:
        xor ax, ax          ; buffer
        push cx             ; save counter for next iteration
        .getCountAndByte:
            bt [si], bp     ; test the bp'th bit in the array
            rcr ax, 1           ; 
            inc bp              ; 
            loop .getCountAndByte

        pop cx          ; restore counter
        push cx         ; and keep the value on stack
        rol ax, cl      ; move the bits to the right side of ax

        ; extract counter 
        mov cx, ax
        shr cx, 4
        inc cx

        ; extract index
        and al, 0x0f
        xlatb


        .unrollRle:
            stosb
            inc di
            loop .unrollRle

        pop cx
        cmp bp, dx
        jb .next
	ret

; Include the generated files.
%include "image.chr.asm"
%include "image.col.asm"


; offset, string, terminator
halloween:
	dw 2*(80*13+20)
	db 'Halloween!',0
happy:
	dw 2*(80*12+22)
	db 'Happy',0
rip:
	dw 2*(80*8+60)
	db 'Rest in  Peace',0

