#include <cstdio>
#include <boost/shared_ptr.hpp>

void _nop(FILE*) { }

int main(int argc, char** argv)
{
    if (argc != 3)
    {
        std::fprintf(stderr, "Made by lego for hc27.\n\n");
        std::fprintf(stderr, "Splits the image into two pieces - characters and color.\n\n");
        std::fprintf(stderr, "Usage:\n\n\tsplit chrfile colfile < input\n\n");
        return 1;
    }

	boost::shared_ptr<FILE> finput;
	finput.reset(stdin, _nop);

    char buf[4000];
	std::size_t const bytes = std::fread(buf, 1, 4000, finput.get());

    boost::shared_ptr<FILE> fchr(fopen(argv[1], "wb"), fclose);
    if (!fchr)
    {
        std::fprintf(stderr, "Failed to open '%s' for writing.\n", argv[1]);
        return 2;
    }

    boost::shared_ptr<FILE> fcol(fopen(argv[2], "wb"), fclose);
    if (!fcol)
    {
        std::fprintf(stderr, "Failed to open '%s' for writing.\n", argv[2]);
        return 3;
    }

    // put the characters in stdout, and colors in stderr
    for (unsigned i = 0; i < bytes/2; ++i)
    {
        std::fwrite(buf+2*i+0, 1, 1, fchr.get());
        std::fwrite(buf+2*i+1, 1, 1, fcol.get());
    }

    return 0;
}

