;assemble with 
;  nasm -fbin -O999 -o entry.com entry.asm
;
;The image data is compressed based on the repetition of the characters as we go through the data word by word.
;There are 66 different words in the image, 64 of them are encoded from numbers 0 to 63
;Whereever possible we are constructing the data and the repetition in a single byte!  (using encoded index)
;
;Email:  mathiisalive@yahoo.com
;
org 100h

MOV     Ah,0B8H
MOV     ES,AX
mov	ax, 0003h	;clear the screen
int	10h

mov si,ImageData
mov dx,605  ; Length of compressed data
xor di,di

Mainloop:
	xor ax,ax
	lodsb
	mov bx,ax
	cmp bl,215
	jb short normalencode
	not bl
	mov cx,bx
	xor ax,ax
	jmp short ActualPrint
	normalencode:
	and bl,0x3F
	and al,0xC0
	jz  short Nodecode
	shr al,6
	jmp short PutChar	
Nodecode:
	lodsb
	
PutChar:
	xchg ax,cx
	shl bx,1
	mov ax,word[ImageChars+bx]
ActualPrint:
	repne stosw 
	dec dx
jnz  short Mainloop

;;;;Begin residue chars printing
mov ax,0x6fdf
stosw
mov ah,0x06
mov cl,80
repne stosw
;;;End residue chars printing

	xor ax,ax;wait for keystroke
	int	16h
	
	ret


ImageData:
	db	247,70,239,155,5,10,155,0,48,70,71,240,91,5,14,91,0,47,70,71,74,249,138
	db	71,250,5,10,161,5,4,231,210,204,239,134,73,74,201,134,74,201,70,71
	db	9,4,197,97,155,97,110,91,133,91,133,235,146,157,78,150,65,204,145,65
	db	140,244,74,70,71,134,73,71,70,249,70,250,161,5,8,161,237,82,93,78
	db	214,158,65,94,99,1,5,140,145,65,76,128,71,250,70,74,198,74,70,248
	db	135,70,233,147,247,93,79,78,86,94,65,86,65,94,65,163,1,9,76,81
	db	65,64,71,70,137,70,71,70,138,71,73,134,244,71,238,83,2,6,83,250
	db	93,78,86,94,129,94,99,1,14,90,65,64,132,135,70,73,71,70,88,135
	db	70,226,67,66,148,130,148,130,21,4,107,78,86,129,99,1,16,90,65,64
	db	68,71,70,201,71,70,88,135,70,243,84,147,66,83,243,66,147,130,147,2
	db	4,213,107,65,86,99,109,114,101,123,124,100,118,120,164,113,101,115,117,101
	db	109,129,90,65,64,71,250,74,70,74,70,71,70,243,84,83,2,5,211,21
	db	4,147,2,4,83,149,84,2,5,149,129,94,1,19,90,65,248,74,73,74
	db	88,134,243,84,213,84,2,24,147,85,145,1,19,90,65,248,70,73,74,88
	db	74,70,245,12,6,196,84,2,22,95,89,79,210,81,65,81,82,145,82,64
	db	81,1,8,90,65,248,70,74,88,73,74,70,248,76,129,102,103,170,126,193
	db	76,196,2,19,95,89,98,143,93,78,86,210,142,86,82,92,76,1,7,90
	db	65,248,88,74,88,71,138,249,129,102,103,169,121,125,168,119,112,129,196,84
	db	2,5,96,2,12,95,89,98,79,78,79,206,86,142,86,156,76,1,7,90
	db	65,249,138,73,71,70,88,74,249,129,77,129,144,65,80,129,80,65,80,250
	db	148,153,96,95,160,2,9,95,89,98,143,206,156,64,204,1,9,90,65,249
	db	88,70,71,73,70,88,74,249,65,80,75,144,77,80,65,77,80,65,80,65
	db	80,4,4,76,129,68,207,127,89,96,2,9,95,89,98,143,92,64,1,15
	db	90,65,249,74,73,88,134,88,70,249,80,77,75,77,80,141,80,75,144,77
	db	65,77,4,4,80,65,80,77,76,92,143,89,160,2,7,95,89,79,92,204
	db	1,16,90,65,64,4,4,74,88,73,70,73,71,74,70,249,80,203,77,75
	db	141,75,205,80,77,4,4,77,80,77,75,144,76,92,89,2,9,96,95,89
	db	98,210,64,17,4,1,11,90,65,64,196,74,88,73,74,199,74,135,250,77
	db	75,68,11,5,68,75,77,75,77,75,4,4,75,77,75,68,13,4,68,148
	db	2,8,89,98,111,143,157,206,86,82,64,17,6,193,90,65,64,132,138,137
	db	70,135,73,74,70,135,9,4,75,132,203,68,75,68,139,68,139,4,4,139
	db	132,77,203,249,20,5,92,15,4,14,5,79,142,150,207,210,128,81,64,72
	db	71,70,122,116,71,70,74,8,4,199,200,241,8,23,172,8,6,23,16

 
ImageChars:

dw	0x0720,0x08db,0x0fdb,0x0fde,0x0820,0x0edb,0x06b1,0x06b0,0x06dc,0x0620,0x06b2
dw	0x08b0,0x08dc,0x08b1,0x78b0,0x07db,0x08b2,0x08df,0x07dc,0x0fdc,0x0fdf,0x0f20
dw	0x78b1,0x76dc,0x06db,0x7fb1,0x08dd,0x0edc,0x07df,0x7820,0x78b2,0x7fb2,0x7fdb
dw	0x0edf,0x7fb0,0x78db,0x7020,0x7065,0x0e48,0x0e61,0x0e65,0x0e6c,0x0e70,0x78de
dw	0x68df,0x70fe,0x0e20,0x7f20,0x0e21,0x7050,0x7052,0x7061,0x6063,0x7063,0x7069
dw	0x0e6e,0x706e,0x0e6f,0x6073,0x7073,0x7074,0x0e77,0x0e79,0x7fdf

;Residue:
;6FDF-1,
;06DF-80,
;0720-240,

