a_dest_ptr	equ	0
a_dest_bit	equ	4
a_intervalsize	equ	6
a_intervalmin	equ	8

	global	_AritCodeInit
	global	_AritCode
	global	_AritCodeEnd
	
section code
	;; object, dest ptr
_AritCodeInit:
	mov	eax, [esp + 1*4]
	mov	edx, [esp + 2*4]
	mov	dword [eax + a_dest_ptr], edx
	mov	word [eax + a_dest_bit], -1
	mov	word [eax + a_intervalsize], 8000h
	mov	word [eax + a_intervalmin], 0
	ret

	;; object, zero prob, one prob, bit
_AritCode:
	push ebx
	push edi
	push ebp
	push esi
	mov	esi, [esp + (4+1)*4]
	mov	edx, [esp + (4+2)*4]
	mov	ebx, [esp + (4+3)*4]

	mov	edi, [esi + a_dest_ptr]
	mov	bp, [esi + a_dest_bit]
	movzx	eax, word [esi + a_intervalsize]
	mov	cx, [esi + a_intervalmin]

	;; bp = dest bit index
	;; cx = interval min
	;; ax = interval size
	;; dx = zero prob
	;; bx = one prob
	;; edi = dest ptr
	add	bx, dx
	test bx, bx
	jz .fail
	mul	edx
	
	div	ebx
	;; ax = threshold value between 0 and 1
	test eax, eax
	jz .fail
	test eax, 0xFFFF0000
	jz .fine
	.fail:
		;overflow, try again!
		pop esi
		pop ebp
		pop edi
		pop ebx
		mov eax, 1
		ret
	.fine:

	test [esp + (4+4)*4], byte 1
	jz	.zero
	add	cx, ax
	jnc	.not_overflow
	call	PutBit
.not_overflow:
	sub	ax, word [esi + a_intervalsize]
	neg ax
.zero:
	;; cx = new interval min
	;; ax = new interval size

	test	ax, ax
	js	.filled
.floop:
	inc	bp
	add	cx, cx
	jnc	.not_one
	call	PutBit
.not_one:
	add	ax, ax
	jns	.floop
.filled:

	mov	word [esi + a_dest_bit], bp
	mov	word [esi + a_intervalsize], ax
	mov	word [esi + a_intervalmin], cx

	pop esi
	pop ebp
	pop edi
	pop ebx
	xor eax, eax
	ret

PutBit:
	mov	bx, bp
.carry_loop:
	dec	bx
	js	.not
	btc	[edi], bx
	jc	.carry_loop
.not:
	ret

	;; object
_AritCodeEnd:
	pusha
	mov	ebx, [esp + (8+1)*4]
	mov	edi, dword [ebx + a_dest_ptr]
	movzx	ebp, word [ebx + a_dest_bit]
	mov	ax, word [ebx + a_intervalsize]
	mov	cx, word [ebx + a_intervalmin]

	add	cx, ax
	jc	.over
	inc	bp
.over:
	call	PutBit
	mov	[esp + 7*4], ebp
	popa
	ret