	page	80,132

DEBUG	equ	0


;	File: entry.asm
;	Vers: 0.1
;	Date: 2008-oct-06
;	Auth: Pete Disdale
;
;	Description:
;	------------
;	This is basically an exercise in Run Length Encoding (RLE)
;	the performance boost being achieved through separating out
;	the characters from their attributes as such a scheme lends
;	itself to encoding "similar" data streams.
;
;	Attributes:
;	-----------
;	All attributes are in the range 00-7F (strictly 06-0F, 60-6F)
;	so these are encoded "as is" for single bytes, or preceded by
;	(run length + 80h) for a run of identical bytes.
;
;	Characters:
;	-----------
;	This is more tricky -- the range of characters is from 20-FE,
;	though the distribution is sparse.  Actually it is 20, 21,
;	48-79 and B0-FE so what we do is:
;
;	20,21	- handle individually, encode as 00 and 01 respectively
;	48-79	- subtract 40, giving the range 08-39
;	B0-FE	- subtract 70, giving the range 40-8E
;
;	This leaves values 90-FF (range 6F) for encoding the run length,
;	which is enough as the longest run length is 51h (excluding the
;	empty lines at the bottom of the screen which do not need to be
;	written as the CLS has already set them to 0720h). Decoding then
;	becomes:
;
;	>= 90h? - subtract 90h and use as RLE count
;	0 ?	- expand to <spc>
;	1 ?	- expand to '!'
;	< 40h ? - add 40h and display
;	< 90h ? - add 70h and display
;
;	The screen data for both chars and attribs was created using the
;	program SCRNDMP3 (included somewhere here).
;
;	There is no doubt scope for refining what has been done so far,
;	but I have a job, family and life to consider so will settle for
;	a saving of 30 or so bytes over EXAMPLE.COM!
;
;

	IF DEBUG
MODE	equ	24h	; 80x30 screen mode here
	ELSE
MODE	equ	03h	; normal 80x25 screen mode
	ENDIF

cseg	segment public 'code'
	assume	cs:cseg, ds:cseg, ss:cseg

	org	100h

start:	call	cls			;clear screen (necessary)

;;	mov	ax, cs			;assume DS == CS
;;	mov	ds, ax
	mov	ax,0B800h
	mov	es, ax
	xor	di, di			;ES:DI -> B800:0000

	mov	si, offset attr_data	;attributes first
;;	xor	cx, cx			;assume CH == 0
aloop:
	lodsb				;get attribute/count
	mov	cl, al
	jcxz	attr_done		;end of data
	test	al, 080h
	jnz	multi_byte_attr
	mov	cl, 1
	jmp	short	a2loop
multi_byte_attr:
	sub	cl, 080h		;adjust count
	lodsb				;get data byte
a2loop:
	inc	di			;point to attrib byte
	stosb				;and write it
	loop	a2loop
	jmp	short	aloop
attr_done:
	mov	si, offset chr_data	;now character bytes
	xor	di, di			;ES:DI -> B800:0000
cloop:
	lodsb
	cmp	al, 0FFh
	jz	chr_done		;end of list
	mov	cl, 1			;set provisional count
	cmp	al, 090h
	jb	multi_byte_chr
	sub	al, 090h		;reset RLE count
	mov	cl, al
	lodsb
multi_byte_chr: 			;CX = count, AL = CHR (encoded)
	or	al, al			;0?
	jnz	exclam			;no, try '!'
	mov	al, ' '                 ;substitute <spc>
	jmp	short	c2loop
exclam:
	cmp	al, 1			;1?
	jnz	ascii			;no, try ASCII char
	mov	al, '!'                 ;substitute exclamation mark
	jmp	short	c2loop
ascii:
	add	al, 40h 		;provisionally assume ASCII
	cmp	al, 80h 		;was it?
	jb	c2loop			;yes
	add	al, 30h 		;else add bias for graphic chars
c2loop:
	stosb				;write character
	inc	di			;skip attribute byte
	loop	c2loop
	jmp	short	cloop
chr_done:
	IF DEBUG
	mov	ah, 2		;set curpos
	sub	bx, bx		;page 0
	mov	dx, 25 * 256
	int	10h
	mov	ax, 4C00h	;clean termination
	int	21h
	ENDIF
	mov	ah, 0		;wait for keystroke
	int	16h
cls:	mov	ax, MODE	;clean up
	int	10h
	ret

chr_data  label byte

	db	098h, 000h
	db	041h
	db	0A0h, 000h
	db	092h, 06Ch
	db	09Ah, 06Bh
	db	092h, 06Ch
	db	0C0h, 000h
	db	041h
	db	040h
	db	09Fh, 000h
	db	06Ch
	db	09Eh, 06Bh
	db	06Ch
	db	0BFh, 000h
	db	041h
	db	040h
	db	042h
	db	096h, 000h
	db	092h, 042h
	db	040h
	db	095h, 000h
	db	09Ah, 06Bh
	db	092h, 06Fh
	db	094h, 06Bh
	db	0A8h, 000h
	db	096h, 06Ch
	db	0A0h, 000h
	db	092h, 041h
	db	000h
	db	042h
	db	093h, 000h
	db	092h, 041h
	db	042h
	db	093h, 000h
	db	041h
	db	040h
	db	094h, 000h
	db	093h, 06Bh
	db	06Fh
	db	092h, 06Ch
	db	06Fh
	db	000h
	db	06Ch
	db	092h, 06Bh
	db	06Ch
	db	092h, 06Bh
	db	0A4h, 000h
	db	092h, 06Ch
	db	092h, 000h
	db	040h
	db	092h, 041h
	db	06Bh
	db	093h, 06Ch
	db	092h, 06Fh
	db	06Bh
	db	092h, 06Ch
	db	09Bh, 000h
	db	042h
	db	041h
	db	040h
	db	092h, 041h
	db	000h
	db	040h
	db	041h
	db	096h, 000h
	db	041h
	db	095h, 000h
	db	092h, 06Fh
	db	098h, 06Bh
	db	092h, 06Fh
	db	0A2h, 000h
	db	06Ch
	db	000h
	db	040h
	db	093h, 041h
	db	092h, 042h
	db	06Bh
	db	042h
	db	096h, 06Bh
	db	092h, 06Ch
	db	092h, 06Fh
	db	06Bh
	db	06Ch
	db	092h, 000h
	db	040h
	db	095h, 000h
	db	041h
	db	042h
	db	093h, 041h
	db	042h
	db	041h
	db	097h, 000h
	db	092h, 040h
	db	041h
	db	0A6h, 000h
	db	092h, 06Ch
	db	099h, 000h
	db	06Bh
	db	040h
	db	041h
	db	042h
	db	06Bh
	db	041h
	db	06Bh
	db	042h
	db	09Ch, 06Bh
	db	06Ch
	db	06Fh
	db	06Bh
	db	000h
	db	040h
	db	041h
	db	092h, 000h
	db	041h
	db	040h
	db	041h
	db	092h, 042h
	db	040h
	db	000h
	db	092h, 041h
	db	09Bh, 000h
	db	040h
	db	0A1h, 000h
	db	06Ch
	db	096h, 06Bh
	db	06Ch
	db	096h, 000h
	db	040h
	db	041h
	db	042h
	db	092h, 06Bh
	db	042h
	db	09Fh, 06Bh
	db	06Dh
	db	06Bh
	db	093h, 000h
	db	092h, 040h
	db	041h
	db	000h
	db	040h
	db	041h
	db	06Bh
	db	092h, 040h
	db	041h
	db	0ADh, 000h
	db	06Eh
	db	06Bh
	db	092h, 06Fh
	db	092h, 06Bh
	db	092h, 06Fh
	db	092h, 06Bh
	db	094h, 000h
	db	06Eh
	db	040h
	db	041h
	db	0A3h, 06Bh
	db	06Dh
	db	06Bh
	db	092h, 000h
	db	040h
	db	041h
	db	093h, 000h
	db	040h
	db	041h
	db	06Bh
	db	092h, 040h
	db	041h
	db	09Ch, 000h
	db	06Fh
	db	092h, 06Ch
	db	06Bh
	db	06Ch
	db	09Ch, 000h
	db	06Bh
	db	092h, 06Ch
	db	092h, 06Bh
	db	092h, 06Ch
	db	094h, 06Bh
	db	093h, 000h
	db	06Eh
	db	06Bh
	db	041h
	db	06Bh
	db	08Eh
	db	012h
	db	025h
	db	033h
	db	034h
	db	000h
	db	029h
	db	02Eh
	db	092h, 000h
	db	010h
	db	025h
	db	021h
	db	023h
	db	025h
	db	08Eh
	db	092h, 06Bh
	db	06Dh
	db	06Bh
	db	000h
	db	040h
	db	095h, 000h
	db	042h
	db	041h
	db	042h
	db	041h
	db	040h
	db	041h
	db	09Ch, 000h
	db	06Fh
	db	06Ch
	db	095h, 06Bh
	db	093h, 06Ch
	db	094h, 000h
	db	092h, 06Ch
	db	094h, 06Bh
	db	06Ch
	db	092h, 000h
	db	06Fh
	db	095h, 06Bh
	db	092h, 000h
	db	092h, 06Bh
	db	042h
	db	0A3h, 06Bh
	db	06Dh
	db	06Bh
	db	097h, 000h
	db	042h
	db	000h
	db	042h
	db	06Bh
	db	092h, 041h
	db	09Ch, 000h
	db	06Fh
	db	093h, 000h
	db	06Fh
	db	0A8h, 06Bh
	db	092h, 06Ch
	db	000h
	db	092h, 06Fh
	db	0A3h, 06Bh
	db	06Dh
	db	06Bh
	db	097h, 000h
	db	041h
	db	000h
	db	042h
	db	06Bh
	db	042h
	db	041h
	db	09Ah, 000h
	db	096h, 06Ch
	db	093h, 000h
	db	06Fh
	db	0A6h, 06Bh
	db	042h
	db	041h
	db	06Bh
	db	093h, 06Ch
	db	06Fh
	db	06Bh
	db	06Fh
	db	06Ch
	db	092h, 06Fh
	db	06Ch
	db	000h
	db	06Fh
	db	098h, 06Bh
	db	06Dh
	db	06Bh
	db	097h, 000h
	db	041h
	db	042h
	db	06Bh
	db	000h
	db	042h
	db	041h
	db	097h, 000h
	db	06Ch
	db	092h, 06Bh
	db	008h
	db	021h
	db	092h, 030h
	db	039h
	db	093h, 06Bh
	db	06Ch
	db	093h, 000h
	db	0A3h, 06Bh
	db	042h
	db	041h
	db	040h
	db	092h, 06Bh
	db	000h
	db	040h
	db	041h
	db	093h, 06Ch
	db	092h, 040h
	db	041h
	db	06Ch
	db	06Fh
	db	06Ch
	db	097h, 06Bh
	db	06Dh
	db	06Bh
	db	097h, 000h
	db	06Bh
	db	042h
	db	06Bh
	db	040h
	db	092h, 042h
	db	096h, 000h
	db	092h, 06Bh
	db	008h
	db	021h
	db	092h, 02Ch
	db	02Fh
	db	037h
	db	092h, 025h
	db	02Eh
	db	001h
	db	092h, 06Bh
	db	093h, 000h
	db	06Fh
	db	0A2h, 06Bh
	db	042h
	db	041h
	db	040h
	db	06Bh
	db	040h
	db	06Bh
	db	093h, 040h
	db	041h
	db	092h, 040h
	db	041h
	db	092h, 06Fh
	db	06Ch
	db	097h, 06Bh
	db	06Dh
	db	06Bh
	db	096h, 000h
	db	092h, 042h
	db	000h
	db	040h
	db	041h
	db	06Bh
	db	042h
	db	096h, 000h
	db	092h, 06Bh
	db	041h
	db	092h, 06Bh
	db	092h, 042h
	db	06Bh
	db	042h
	db	092h, 06Bh
	db	042h
	db	06Bh
	db	042h
	db	095h, 000h
	db	092h, 06Fh
	db	092h, 041h
	db	06Bh
	db	042h
	db	09Bh, 06Bh
	db	042h
	db	041h
	db	040h
	db	092h, 06Bh
	db	093h, 040h
	db	092h, 06Fh
	db	000h
	db	093h, 06Ch
	db	099h, 06Bh
	db	06Dh
	db	06Bh
	db	096h, 000h
	db	06Bh
	db	041h
	db	040h
	db	000h
	db	041h
	db	06Bh
	db	042h
	db	096h, 000h
	db	06Bh
	db	042h
	db	040h
	db	092h, 042h
	db	041h
	db	042h
	db	06Bh
	db	041h
	db	042h
	db	06Bh
	db	042h
	db	06Bh
	db	042h
	db	094h, 000h
	db	06Ch
	db	092h, 06Bh
	db	000h
	db	093h, 06Bh
	db	06Fh
	db	041h
	db	09Ah, 06Bh
	db	042h
	db	041h
	db	040h
	db	092h, 06Bh
	db	06Fh
	db	000h
	db	09Fh, 06Bh
	db	06Dh
	db	06Bh
	db	096h, 000h
	db	042h
	db	000h
	db	06Bh
	db	092h, 041h
	db	06Bh
	db	041h
	db	096h, 000h
	db	042h
	db	041h
	db	040h
	db	041h
	db	042h
	db	092h, 041h
	db	042h
	db	040h
	db	092h, 042h
	db	041h
	db	06Bh
	db	041h
	db	094h, 000h
	db	042h
	db	06Bh
	db	042h
	db	041h
	db	06Ch
	db	06Fh
	db	092h, 06Bh
	db	041h
	db	099h, 06Bh
	db	042h
	db	041h
	db	06Bh
	db	06Fh
	db	093h, 06Ch
	db	0A0h, 06Bh
	db	06Dh
	db	06Bh
	db	095h, 000h
	db	042h
	db	06Bh
	db	000h
	db	041h
	db	000h
	db	040h
	db	042h
	db	041h
	db	096h, 000h
	db	042h
	db	093h, 040h
	db	041h
	db	040h
	db	092h, 041h
	db	040h
	db	093h, 041h
	db	042h
	db	041h
	db	094h, 000h
	db	041h
	db	042h
	db	041h
	db	040h
	db	092h, 042h
	db	06Ch
	db	06Fh
	db	041h
	db	09Ah, 06Bh
	db	042h
	db	041h
	db	040h
	db	093h, 06Ch
	db	000h
	db	094h, 06Fh
	db	09Bh, 06Bh
	db	06Dh
	db	06Bh
	db	094h, 000h
	db	042h
	db	06Bh
	db	000h
	db	042h
	db	093h, 040h
	db	042h
	db	092h, 040h
	db	095h, 000h
	db	041h
	db	040h
	db	000h
	db	095h, 040h
	db	000h
	db	040h
	db	041h
	db	040h
	db	041h
	db	040h
	db	094h, 000h
	db	040h
	db	041h
	db	040h
	db	000h
	db	094h, 041h
	db	000h
	db	092h, 06Fh
	db	098h, 06Bh
	db	041h
	db	040h
	db	000h
	db	092h, 06Bh
	db	092h, 000h
	db	093h, 040h
	db	041h
	db	06Ch
	db	000h
	db	096h, 06Fh
	db	093h, 06Bh
	db	06Dh
	db	06Bh
	db	093h, 000h
	db	092h, 042h
	db	092h, 000h
	db	041h
	db	092h, 040h
	db	000h
	db	042h
	db	041h
	db	092h, 040h
	db	094h, 000h
	db	040h
	db	092h, 000h
	db	093h, 040h
	db	000h
	db	040h
	db	000h
	db	092h, 040h
	db	000h
	db	092h, 040h
	db	094h, 000h
	db	092h, 040h
	db	092h, 000h
	db	041h
	db	093h, 040h
	db	096h, 000h
	db	096h, 06Fh
	db	094h, 06Bh
	db	095h, 040h
	db	06Bh
	db	092h, 040h
	db	092h, 041h
	db	093h, 06Bh
	db	093h, 06Ch
	db	092h, 000h
	db	06Fh
	db	000h
	db	06Ch
	db	040h
	db	041h
	db	033h
	db	023h
	db	040h
	db	041h
	db	042h
	db	094h, 06Ch
	db	093h, 040h
	db	093h, 06Ch
	db	09Eh, 000h
	db	0A7h, 06Ch
	db	092h, 06Fh
	db	0A6h, 06Ch
	db	0E1h, 06Fh
;;	db	0180h, 000h	;ignore this stuff - spaces to EOS
	db	0FFh		;end of data

attr_data  label byte

	db	088h, 007h
	db	006h
	db	090h, 007h
	db	08Eh, 00Eh
	db	0B0h, 007h
	db	082h, 006h
	db	08Fh, 007h
	db	090h, 00Eh
	db	0AFh, 007h
	db	083h, 006h
	db	086h, 007h
	db	083h, 006h
	db	085h, 007h
	db	090h, 00Eh
	db	09Bh, 007h
	db	083h, 008h
	db	090h, 007h
	db	093h, 006h
	db	08Eh, 00Eh
	db	096h, 007h
	db	085h, 078h
	db	089h, 008h
	db	08Bh, 007h
	db	088h, 006h
	db	086h, 007h
	db	006h
	db	085h, 007h
	db	08Ch, 00Eh
	db	093h, 007h
	db	087h, 078h
	db	008h
	db	082h, 078h
	db	08Bh, 008h
	db	082h, 007h
	db	006h
	db	085h, 007h
	db	087h, 006h
	db	087h, 007h
	db	083h, 006h
	db	096h, 007h
	db	082h, 00Fh
	db	088h, 007h
	db	078h
	db	007h
	db	083h, 078h
	db	008h
	db	078h
	db	008h
	db	078h
	db	008h
	db	082h, 078h
	db	08Ch, 008h
	db	007h
	db	08Dh, 006h
	db	08Bh, 007h
	db	006h
	db	091h, 007h
	db	088h, 00Fh
	db	085h, 007h
	db	084h, 078h
	db	082h, 008h
	db	082h, 078h
	db	090h, 008h
	db	007h
	db	082h, 008h
	db	08Ah, 006h
	db	09Dh, 007h
	db	08Eh, 00Fh
	db	083h, 078h
	db	082h, 008h
	db	078h
	db	092h, 008h
	db	007h
	db	008h
	db	08Bh, 006h
	db	08Ch, 007h
	db	085h, 00Fh
	db	08Ch, 007h
	db	08Eh, 00Fh
	db	078h
	db	008h
	db	082h, 078h
	db	090h, 070h
	db	084h, 008h
	db	007h
	db	006h
	db	085h, 007h
	db	086h, 006h
	db	08Ch, 007h
	db	09Fh, 00Fh
	db	082h, 008h
	db	078h
	db	095h, 008h
	db	087h, 007h
	db	086h, 006h
	db	08Ch, 007h
	db	0A0h, 00Fh
	db	097h, 008h
	db	087h, 007h
	db	086h, 006h
	db	08Ah, 007h
	db	089h, 008h
	db	097h, 00Fh
	db	082h, 07Fh
	db	084h, 007h
	db	083h, 008h
	db	007h
	db	082h, 008h
	db	082h, 007h
	db	08Bh, 008h
	db	087h, 007h
	db	086h, 006h
	db	087h, 007h
	db	083h, 008h
	db	085h, 00Eh
	db	087h, 008h
	db	093h, 00Fh
	db	083h, 07Fh
	db	082h, 007h
	db	083h, 078h
	db	083h, 007h
	db	083h, 078h
	db	082h, 007h
	db	08Ah, 008h
	db	087h, 007h
	db	086h, 006h
	db	086h, 007h
	db	082h, 008h
	db	08Ah, 00Eh
	db	085h, 008h
	db	086h, 00Fh
	db	07Fh
	db	08Ch, 00Fh
	db	083h, 07Fh
	db	007h
	db	078h
	db	007h
	db	087h, 078h
	db	082h, 007h
	db	08Ah, 008h
	db	086h, 007h
	db	087h, 006h
	db	086h, 007h
	db	08Eh, 008h
	db	085h, 007h
	db	082h, 00Fh
	db	086h, 07Fh
	db	089h, 00Fh
	db	083h, 07Fh
	db	082h, 007h
	db	083h, 078h
	db	083h, 007h
	db	08Eh, 008h
	db	086h, 007h
	db	087h, 006h
	db	086h, 007h
	db	096h, 008h
	db	083h, 007h
	db	083h, 07Fh
	db	089h, 00Fh
	db	083h, 07Fh
	db	084h, 007h
	db	091h, 008h
	db	086h, 007h
	db	087h, 006h
	db	086h, 007h
	db	097h, 008h
	db	083h, 007h
	db	083h, 07Fh
	db	087h, 00Fh
	db	082h, 07Fh
	db	082h, 007h
	db	095h, 008h
	db	007h
	db	084h, 008h
	db	088h, 006h
	db	086h, 007h
	db	099h, 008h
	db	007h
	db	07Fh
	db	089h, 00Fh
	db	084h, 07Fh
	db	084h, 007h
	db	091h, 008h
	db	007h
	db	083h, 008h
	db	08Ah, 006h
	db	085h, 007h
	db	09Bh, 008h
	db	08Ah, 00Fh
	db	083h, 07Fh
	db	082h, 007h
	db	086h, 078h
	db	082h, 007h
	db	08Bh, 008h
	db	007h
	db	082h, 008h
	db	090h, 006h
	db	09Ah, 008h
	db	086h, 007h
	db	085h, 00Fh
	db	085h, 007h
	db	085h, 078h
	db	007h
	db	084h, 078h
	db	088h, 007h
	db	008h
	db	007h
	db	083h, 006h
	db	082h, 060h
	db	08Dh, 006h
	db	08Eh, 007h
	db	097h, 006h
	db	082h, 068h
	db	086h, 006h
	db	090h, 076h
	db	06Fh
	db	0D0h, 006h
;;	db	0f0h, 007h	; ignore this bit - attr 07 to EOS
	db	00h		; end of data

cseg	ends
	end	start
