#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WRITE	"wb"
#define ARG_ERR 1
#define IFP_ERR 2
#define OFP_ERR 3

#define PROGNAME	"ScrnDump"      /* force compiler to include */
#define VERSION 	"0.3"           /*   version specific info   */
#define VNDATE		"05 Oct 2008"

#define SCRSIZ		25*80	/* size in words */


char	text[] = "textdata.3";    /* output filename - text only */
char	attr[] = "attrdata.3";    /* output filename - attribs only */

FILE	*fpt, *fpa;		/* output FILE pointers */

unsigned
int	far *pi = (unsigned int far *) 0xb8000000UL;

/* -------------------------------------------------------------- */
int	main (argc, argv)
int	argc;
char	*argv[];
{
int	i,
	ccnt, acnt;	// character + attrib count
unsigned
int	word;		// read from screen
unsigned
char	chr,
	prv_chr,
	att,
	prv_att;

    if ((fpt = fopen (text, WRITE)) == NULL)
	usage (OFP_ERR, text);

    if ((fpa = fopen (attr, WRITE)) == NULL)
	usage (OFP_ERR, attr);

    // initialise first "read"
    word = *pi;
    prv_chr = word & 0xff;
    prv_att = (word & 0xff00) >> 8;
    ccnt = acnt = 0;

    if (prv_chr == ' ')
	prv_chr = 0;
    else if (prv_chr == '!')
	prv_chr = 1;
    else if (prv_chr < 0x80)
	prv_chr -= 0x40;
    else
	prv_chr -= 0x70;

    for (i = 0; i < SCRSIZ; i++)
    {
	word = *pi++;
	chr = word & 0xff;
	att = (word & 0xff00) >> 8;

	if (chr == ' ')
	    chr = 0;
	else if (chr == '!')
	    chr = 1;
	else if (chr < 0x80)
	    chr -= 0x40;
	else
	    chr -= 0x70;

	if (chr == prv_chr)
	{
	    ++ccnt;
	}
	else
	{
	    if (ccnt == 1)
	    {
		fprintf (fpt, "\tdb\t0%02Xh\r\n", prv_chr);
	    }
	    else
	    {
		fprintf (fpt, "\tdb\t0%02Xh, 0%02Xh\r\n", (ccnt + 0x90), prv_chr);
		ccnt = 1;
	    }
	    prv_chr = chr;
	}

	if (att == prv_att)
	{
	    ++acnt;
	}
	else
	{
	    if (acnt == 1)
	    {
		fprintf (fpa, "\tdb\t0%02Xh\r\n", prv_att);
	    }
	    else
	    {
		fprintf (fpa, "\tdb\t0%02Xh, 0%02Xh\r\n", (acnt | 0x80), prv_att);
		acnt = 1;
	    }
	    fprintf (fpa, "\r\n");
	    prv_att = att;
	}
    }

    // leftovers
    if (ccnt == 1)
    {
	fprintf (fpt, "\tdb\t0%02Xh\r\n", prv_chr);
    }
    else
    {
	fprintf (fpt, "\tdb\t0%02Xh, 0%02Xh\r\n", (ccnt + 0x90), prv_chr);
    }

    if (acnt == 1)
    {
	fprintf (fpa, "\tdb\t0%02Xh\r\n", prv_att);
    }
    else
    {
	fprintf (fpa, "\tdb\t0%02xh, 0%02Xh\r\n", (acnt | 0x80), prv_att);
    }

    fclose (fpa);
    fclose (fpt);

    return 0;
}

/* -------------------------------------------------------------- */
int	usage (int val, char *file)
{
    switch (val)
    {
	case ARG_ERR:
	     fprintf (stderr, "Usage:-   " PROGNAME "\n");
	     break;

	case IFP_ERR:
	     fprintf (stderr, "Cannot open input file\n");
	     break;

	case OFP_ERR:
	     fprintf (stderr, "Cannot create output file: %s\n", file);
	     break;

	default:
	    break;
    }

    exit (val);
}

/* -------------------------------------------------------------- */
/*			End of Module				  */
/* -------------------------------------------------------------- */


