#! /bin/sh
set -eu

if [ "${1-}" = "clean" ]; then
	rm -f IMAGE [bf]g.bin [bf]gsimple.rle roland0.bin patches.bin
	exit
fi

# Get the raw binary image data.
nasm IMAGE.ASM

# Separate the image into foreground and background.
perl -e 'while (sysread(STDIN, $x, 2) == 2) { print substr($x,0,1); }' < IMAGE > fg.bin
perl -e 'while (sysread(STDIN, $x, 2) == 2) { print substr($x,1,1); }' < IMAGE > bg.bin

# Now edit fg.bin and bg.bin manually to remove the least used bytes,
# until only eight unique bytes remain in each file. Save the edited
# files as fgsimple.bin and bgsimple.bin.

# RLE-compress the simplified files, using 3 bits for the index into an
# 8-entry character table, and the remaining 5 bits as a counter.
perl rle.pl < fgsimple.bin > fgsimple.rle
perl rle.pl < bgsimple.bin > bgsimple.rle

nasm roland0.asm
mv roland0 ENTRY.COM
ls -l ENTRY.COM
